/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.CommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.IRemoteSystemProxy;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSECallback;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.services.terminals.ITerminalService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;

public class RemoteSystemProxy
implements IRemoteSystemProxy {
    private final IHost fHost;

    public RemoteSystemProxy(IHost host) {
        this.fHost = host;
    }

    @Override
    public IShellService getShellService() {
        ISubSystem ss = this.getShellServiceSubSystem();
        if (ss != null) {
            return (IShellService)ss.getSubSystemConfiguration().getService(this.fHost).getAdapter(IShellService.class);
        }
        return null;
    }

    @Override
    public ITerminalService getTerminalService() {
        ISubSystem ss = this.getTerminalServiceSubSystem();
        if (ss != null) {
            return (ITerminalService)ss.getSubSystemConfiguration().getService(this.fHost).getAdapter(ITerminalService.class);
        }
        return null;
    }

    @Override
    public ISubSystem getShellServiceSubSystem() {
        if (this.fHost == null) {
            return null;
        }
        ISubSystem[] subSystems = this.fHost.getSubSystems();
        IShellService ssvc = null;
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            IService svc = subSystems[i].getSubSystemConfiguration().getService(this.fHost);
            if (svc != null && (ssvc = (IShellService)svc.getAdapter(IShellService.class)) != null) {
                return subSystems[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public ISubSystem getTerminalServiceSubSystem() {
        if (this.fHost == null) {
            return null;
        }
        ISubSystem[] subSystems = this.fHost.getSubSystems();
        ITerminalService ssvc = null;
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            IService svc = subSystems[i].getSubSystemConfiguration().getService(this.fHost);
            if (svc != null && (ssvc = (ITerminalService)svc.getAdapter(ITerminalService.class)) != null) {
                return subSystems[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IFileServiceSubSystem getFileServiceSubSystem() {
        if (this.fHost == null) {
            return null;
        }
        ISubSystem[] subSystems = this.fHost.getSubSystems();
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            if (subSystems[i] instanceof IFileServiceSubSystem) {
                return (IFileServiceSubSystem)subSystems[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.getShellServiceSubSystem() != null) {
            return this.getShellServiceSubSystem().getConnectorService().getPort();
        }
        return -1;
    }

    @Override
    public void setPort(int port) {
        if (this.getShellServiceSubSystem() != null && port > 0) {
            this.getShellServiceSubSystem().getConnectorService().setPort(port);
        }
    }

    @Override
    public void connect(IRSECallback callback) throws ExecutionException {
        ISubSystem shellSubSystem = this.getShellServiceSubSystem();
        if (shellSubSystem != null) {
            if (!shellSubSystem.isConnected()) {
                try {
                    shellSubSystem.connect(false, callback);
                }
                catch (OperationCanceledException e) {
                    callback.done(Status.CANCEL_STATUS, null);
                }
                catch (Exception e) {
                    throw new ExecutionException(e.toString(), (Throwable)e);
                }
            } else {
                callback.done(Status.OK_STATUS, null);
            }
        }
    }

    @Override
    public void disconnect() throws ExecutionException {
        ISubSystem shellSubSystem = this.getShellServiceSubSystem();
        if (shellSubSystem != null) {
            try {
                shellSubSystem.disconnect();
            }
            catch (Exception e) {
                throw new ExecutionException(e.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public ICommandShell createCommandShell() throws ExecutionException {
        CommandShell shell = new CommandShell(this);
        shell.connect();
        return shell;
    }

    @Override
    public void addCommunicationListener(ICommunicationsListener listener) {
        IConnectorService[] css;
        IConnectorService[] iConnectorServiceArray = css = this.fHost.getConnectorServices();
        int n = css.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService cs = iConnectorServiceArray[n2];
            cs.addCommunicationsListener(listener);
            ++n2;
        }
    }

    @Override
    public void removeCommunicationListener(ICommunicationsListener listener) {
        IConnectorService[] css;
        IConnectorService[] iConnectorServiceArray = css = this.fHost.getConnectorServices();
        int n = css.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService cs = iConnectorServiceArray[n2];
            cs.removeCommunicationsListener(listener);
            ++n2;
        }
    }

    @Override
    public boolean isLocal() {
        return this.fHost.getSystemType().isLocal();
    }
}

