/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.make.internal.ui.text.WordPartDetector;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OpenDeclarationAction
extends TextEditorAction {
    public OpenDeclarationAction() {
        this(null);
    }

    public OpenDeclarationAction(ITextEditor editor) {
        super(MakeUIPlugin.getDefault().getResourceBundle(), "OpenDeclarationAction.", editor);
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        ISelectionProvider provider = editor.getSelectionProvider();
        if (provider == null) {
            return;
        }
        IMacroDefinition[] directives = null;
        IWorkingCopyManager fManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
        IMakefile makefile = fManager.getWorkingCopy(editor.getEditorInput());
        if (makefile != null) {
            IDocumentProvider prov = editor.getDocumentProvider();
            IDocument doc = prov.getDocument((Object)editor.getEditorInput());
            try {
                ITextSelection textSelection = (ITextSelection)provider.getSelection();
                int offset = textSelection.getOffset();
                WordPartDetector wordPart = new WordPartDetector(doc, offset);
                String name = wordPart.getName();
                if (wordPart.isMacro()) {
                    directives = makefile.getMacroDefinitions(name);
                } else if (wordPart.isFunctionCall()) {
                    directives = makefile.getMacroDefinitions(wordPart.getName());
                } else if (wordPart.isIncludeDirective()) {
                    String incFile = wordPart.getName();
                    incFile = makefile.expandString(incFile, true);
                    IDirective[] iDirectiveArray = makefile.getDirectives();
                    int n = iDirectiveArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDirective dir = iDirectiveArray[n2];
                        if (dir instanceof IInclude) {
                            IInclude includeDirective = (IInclude)dir;
                            if (Arrays.asList(((IInclude)dir).getFilenames()).contains(incFile)) {
                                IDirective[] includedMakefiles;
                                IDirective[] iDirectiveArray2 = includedMakefiles = includeDirective.getDirectives();
                                int n3 = includedMakefiles.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IMakefile includedMakefile;
                                    URI uri;
                                    IDirective includedMakefileDir = iDirectiveArray2[n4];
                                    if (includedMakefileDir instanceof IMakefile && (uri = (includedMakefile = (IMakefile)includedMakefileDir).getFileURI()) != null && uri.toString().endsWith(incFile)) {
                                        directives = new IDirective[]{includedMakefileDir};
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n2;
                    }
                } else {
                    directives = makefile.getTargetRules(name);
                }
                if (directives != null && directives.length > 0) {
                    OpenIncludeAction.openInEditor((IDirective)directives[0]);
                }
            }
            catch (Exception exception) {}
        }
    }
}

