/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.confluence.core.ConfluenceDocumentBuilder;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.CodeBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ColorBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ExtendedPreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ExtendedQuoteBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.QuoteBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.TableOfContentsBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.TextBoxBlock;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.ColorPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.ConfluenceWrappedPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.EmphasisPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.HyperlinkPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.ImagePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.phrase.SimpleWrappedPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.confluence.core.token.AnchorReplacementToken;
import org.eclipse.mylyn.internal.wikitext.confluence.core.token.EscapedCharacterReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternEntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLineBreakReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLiteralReplacementToken;

public class ConfluenceLanguage
extends AbstractMarkupLanguage {
    private final List<Block> nestedBlocks = new ArrayList<Block>();

    public ConfluenceLanguage() {
        this.setName("Confluence");
    }

    protected void clearLanguageSyntax() {
        super.clearLanguageSyntax();
        this.nestedBlocks.clear();
    }

    public List<Block> getNestedBlocks() {
        return this.nestedBlocks;
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        HeadingBlock headingBlock = new HeadingBlock();
        blocks.add(headingBlock);
        paragraphBreakingBlocks.add(headingBlock);
        this.nestedBlocks.add(headingBlock);
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        this.nestedBlocks.add(listBlock);
        blocks.add(new QuoteBlock());
        TableBlock tableBlock = new TableBlock();
        blocks.add(tableBlock);
        paragraphBreakingBlocks.add(tableBlock);
        this.nestedBlocks.add(tableBlock);
        ExtendedQuoteBlock quoteBlock = new ExtendedQuoteBlock();
        blocks.add(quoteBlock);
        paragraphBreakingBlocks.add(quoteBlock);
        ExtendedPreformattedBlock noformatBlock = new ExtendedPreformattedBlock();
        blocks.add(noformatBlock);
        paragraphBreakingBlocks.add(noformatBlock);
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.PANEL, "panel"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.NOTE, "note"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.INFORMATION, "info"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.WARNING, "warning"));
        blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.TIP, "tip"));
        CodeBlock codeBlock = new CodeBlock();
        blocks.add(codeBlock);
        paragraphBreakingBlocks.add(codeBlock);
        blocks.add(new TableOfContentsBlock());
        ColorBlock colorBlock = new ColorBlock();
        blocks.add(colorBlock);
        paragraphBreakingBlocks.add(colorBlock);
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new HyperlinkPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG, true));
        phraseModifierSyntax.add((PatternBasedElement)new EmphasisPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("??", DocumentBuilder.SpanType.CITATION, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("-", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, false));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, false));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleWrappedPhraseModifier("{{", "}}", DocumentBuilder.SpanType.MONOSPACE, false));
        phraseModifierSyntax.add((PatternBasedElement)new ConfluenceWrappedPhraseModifier("{quote}", DocumentBuilder.SpanType.QUOTE, true));
        phraseModifierSyntax.add((PatternBasedElement)new ColorPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new ImagePhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\\\\\\\ ?)"));
        tokenSyntax.add((PatternBasedElement)new EscapedCharacterReplacementToken());
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=(?:\\w\\s)|^)(---)(?=\\s\\w))", "#8212"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=(?:\\w\\s)|^)(--)(?=\\s\\w))", "#8211"));
        tokenSyntax.add((PatternBasedElement)new PatternLiteralReplacementToken("(----)", "<hr/>"));
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new AnchorReplacementToken());
    }

    protected Block createParagraphBlock() {
        return new ParagraphBlock();
    }

    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        return new ConfluenceDocumentBuilder(out);
    }
}

