/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.ICEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public final class GcovAnnotationModelTracker {
    private static GcovAnnotationModelTracker single;
    private final IWorkbench workbench;
    private final Map<IProject, IPath> trackedProjects = new HashMap<IProject, IPath>();
    private IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener(GcovAnnotationModelTracker.this.partListener);
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.getPartService().removePartListener(GcovAnnotationModelTracker.this.partListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partOpened(IWorkbenchPartReference partref) {
            GcovAnnotationModelTracker.this.annotateCEditor(partref);
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };

    private GcovAnnotationModelTracker(IWorkbench workbench) {
        this.workbench = workbench;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            w.getPartService().addPartListener(this.partListener);
            ++n2;
        }
        workbench.addWindowListener(this.windowListener);
    }

    public static GcovAnnotationModelTracker getInstance() {
        if (single == null) {
            single = new GcovAnnotationModelTracker(PlatformUI.getWorkbench());
        }
        return single;
    }

    public IPath getBinaryPath(IProject project) {
        return this.trackedProjects.get(project);
    }

    public boolean containsProject(IProject project) {
        return this.trackedProjects.containsKey(project);
    }

    public void addProject(IProject project, IPath binary) {
        this.trackedProjects.put(project, binary);
    }

    public void dispose() {
        this.workbench.removeWindowListener(this.windowListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            w.getPartService().removePartListener(this.partListener);
            ++n2;
        }
    }

    public void annotateAllCEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = w.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage p = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = p.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference e = iEditorReferenceArray[n6];
                    this.annotateCEditor((IWorkbenchPartReference)e);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void annotateCEditor(IWorkbenchPartReference partref) {
        IWorkbenchPart part = partref.getPart(false);
        if (part instanceof ICEditor) {
            ICEditor editor = (ICEditor)part;
            ICElement element = CDTUITools.getEditorInputCElement((IEditorInput)editor.getEditorInput());
            IProject project = element.getCProject().getProject();
            GcovAnnotationModel.attach((ITextEditor)part);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectBuildListener(project, editor), 16);
        }
    }

    private class ProjectBuildListener
    implements IResourceChangeListener {
        private IProject project;
        private ICEditor editor;

        public ProjectBuildListener(IProject targetProject, ICEditor editor) {
            this.editor = editor;
            this.project = targetProject;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.project != null && this.isPostBuildEvent(event)) {
                IResourceDelta[] childrenDelta;
                IResourceDelta delta = event.getDelta();
                IResourceDelta[] iResourceDeltaArray = childrenDelta = delta.getAffectedChildren(4);
                int n = childrenDelta.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta childDelta = iResourceDeltaArray[n2];
                    if (this.isProjectDelta(childDelta, this.project)) {
                        GcovAnnotationModel.clear((ITextEditor)this.editor);
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                        GcovAnnotationModelTracker.this.trackedProjects.remove(this.project);
                    }
                    ++n2;
                }
            }
        }

        public boolean isProjectDelta(IResourceDelta delta, IProject project) {
            if (delta != null) {
                IResource resource = delta.getResource();
                return delta.getKind() == 4 && resource != null && resource.getType() == 4 && resource.equals((Object)project);
            }
            return false;
        }

        private boolean isPostBuildEvent(IResourceChangeEvent event) {
            if (event != null) {
                int buildKind = event.getBuildKind();
                return event.getType() == 16 && (buildKind == 6 || buildKind == 10 || buildKind == 15);
            }
            return false;
        }
    }
}

