/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.preferences.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RemoteDevelopmentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor indexerErrorLimit;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                RemoteDevelopmentPreferencePage.this.updateValidState();
            }
        }
    };

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    private Composite createComposite(Composite parent, int span, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = span;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Group createGroup(Composite parent, int span, int numColumns, String text) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(text);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected Control createContents(Composite parent) {
        Composite composite_tab = this.createComposite(parent, 1, 1);
        Group ErrorReportingDialogsGroup = this.createGroup(composite_tab, 1, 1, Messages.RemoteDevPreferencePage_ErrorReportingGroupLabel);
        Composite comp = new Composite((Composite)ErrorReportingDialogsGroup, 0);
        this.indexerErrorLimit = this.createIndexErrorLimit(comp);
        GridData data = (GridData)this.indexerErrorLimit.getTextControl(comp).getLayoutData();
        data.horizontalAlignment = 1;
        data.widthHint = this.convertWidthInCharsToPixels(6);
        this.initializeValues();
        return composite_tab;
    }

    private IntegerFieldEditor createIndexErrorLimit(Composite group) {
        IntegerFieldEditor result = new IntegerFieldEditor("org.eclipse.ptp.rdt.ui.INDEXER_ERRORS_DISPLAY_LIMIT", Messages.RemoteDevPreferencePage_IndexErrorLimitLabel, group, 4);
        result.setValidRange(1, 1000);
        result.setPropertyChangeListener(this.validityChangeListener);
        return result;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.indexerErrorLimit.setStringValue(String.valueOf(store.getInt("org.eclipse.ptp.rdt.ui.INDEXER_ERRORS_DISPLAY_LIMIT")));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initalizeDefaults();
    }

    private void initalizeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.indexerErrorLimit.setStringValue(String.valueOf(store.getInt("org.eclipse.ptp.rdt.ui.INDEXER_ERRORS_DISPLAY_LIMIT")));
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.ptp.rdt.ui.INDEXER_ERRORS_DISPLAY_LIMIT", this.indexerErrorLimit.getIntValue());
    }

    private void updateValidState() {
        if (!this.indexerErrorLimit.isValid()) {
            this.setErrorMessage(this.indexerErrorLimit.getErrorMessage());
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

