/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.eclipse.linuxtools.tmf.ctf.core.CtfIterator;
import org.eclipse.linuxtools.tmf.ctf.core.CtfLocationInfo;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfContext;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

class CtfTraceManager {
    private static final int MAX_SIZE = 100;
    private final HashMap<CtfTmfContext, CtfIterator> fMap = new HashMap();
    private final ArrayList<CtfTmfContext> fRandomAccess = new ArrayList();
    private final CtfTmfTrace fTrace;
    private final Random fRnd = new Random(System.nanoTime());

    public CtfTraceManager(CtfTmfTrace trace) {
        this.fTrace = trace;
    }

    public CtfIterator getIterator(CtfTmfContext context) {
        CtfIterator retVal = this.fMap.get(context);
        if (retVal == null) {
            if (this.fRandomAccess.size() < 100) {
                retVal = this.fTrace.createIterator();
                this.addElement(context, retVal);
            } else {
                retVal = this.replaceRandomElement(context);
            }
            if (context.getLocation() != null) {
                CtfLocationInfo location = (CtfLocationInfo)context.getLocation().getLocationInfo();
                retVal.seek(location);
            }
        }
        return retVal;
    }

    public void removeIterator(CtfTmfContext context) {
        this.fMap.remove(context);
        this.fRandomAccess.remove(context);
    }

    private void addElement(CtfTmfContext context, CtfIterator elem) {
        this.fMap.put(context, elem);
        this.fRandomAccess.add(context);
    }

    private CtfIterator replaceRandomElement(CtfTmfContext context) {
        int size = this.fRandomAccess.size();
        int pos = this.fRnd.nextInt(size);
        CtfTmfContext victim = this.fRandomAccess.get(pos);
        this.fRandomAccess.set(pos, context);
        CtfIterator elem = this.fMap.remove(victim);
        this.fMap.put(context, elem);
        return elem;
    }

    void clear() {
        for (CtfIterator iterator : this.fMap.values()) {
            iterator.dispose();
        }
        this.fMap.clear();
        this.fRandomAccess.clear();
    }
}

