/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.request;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;

public class TmfCoalescedEventRequest
extends TmfEventRequest {
    private final List<ITmfEventRequest> fRequests = new ArrayList<ITmfEventRequest>();
    private TmfTimeRange fRange;

    public TmfCoalescedEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
        super(ITmfEvent.class, null, index, nbRequested, priority);
        this.fRange = range;
        if (TmfCoreTracer.isRequestTraced()) {
            String type = this.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            String message = "CREATED " + (this.getExecType() == ITmfEventRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " Range=" + this.getRange() + " DataType=" + this.getDataType().getSimpleName();
            TmfCoreTracer.traceRequest(this, message);
        }
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    public void addRequest(ITmfEventRequest request) {
        this.fRequests.add(request);
        this.merge(request);
    }

    public boolean isCompatible(ITmfEventRequest request) {
        return request.getExecType() == this.getExecType() && this.ranksOverlap(request) && this.timeRangesOverlap(request);
    }

    private boolean ranksOverlap(ITmfEventRequest request) {
        long start = request.getIndex();
        long end = start + (long)request.getNbRequested();
        return start <= this.fIndex + (long)this.fNbRequested + 1L && end >= this.fIndex - 1L;
    }

    private boolean timeRangesOverlap(ITmfEventRequest request) {
        ITmfTimestamp endTime;
        ITmfTimestamp startTime = request.getRange().getStartTime();
        return startTime.compareTo(endTime = request.getRange().getEndTime()) <= 0 && this.fRange.getStartTime().compareTo(this.fRange.getEndTime()) <= 0;
    }

    private void merge(ITmfEventRequest request) {
        long start = request.getIndex();
        long end = Math.min(start + (long)request.getNbRequested(), Integer.MAX_VALUE);
        if (start < this.fIndex) {
            if (this.fNbRequested != Integer.MAX_VALUE) {
                this.fNbRequested = (int)((long)this.fNbRequested + (this.fIndex - start));
            }
            this.fIndex = start;
        }
        this.fNbRequested = request.getNbRequested() == Integer.MAX_VALUE || this.fNbRequested == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.max(end - this.fIndex, (long)this.fNbRequested);
        ITmfTimestamp startTime = request.getRange().getStartTime();
        ITmfTimestamp endTime = request.getRange().getEndTime();
        if (!this.fRange.contains(startTime) && this.fRange.getStartTime().compareTo(startTime) > 0) {
            this.fRange = new TmfTimeRange(startTime, this.fRange.getEndTime());
        }
        if (!this.fRange.contains(endTime) && this.fRange.getEndTime().compareTo(endTime) < 0) {
            this.fRange = new TmfTimeRange(this.fRange.getStartTime(), endTime);
        }
    }

    public String getSubRequestIds() {
        StringBuffer result = new StringBuffer("[");
        int i = 0;
        while (i < this.fRequests.size()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.fRequests.get(i).getRequestId());
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public void handleData(ITmfEvent data) {
        super.handleData(data);
        long index = this.getIndex() + (long)this.getNbRead() - 1L;
        for (ITmfEventRequest request : this.fRequests) {
            long start = request.getIndex();
            if (request.isCompleted() || index < start || request.getNbRead() >= request.getNbRequested()) continue;
            ITmfTimestamp ts = data.getTimestamp();
            if (!request.getRange().contains(ts) || !request.getDataType().isInstance(data)) continue;
            request.handleData(data);
        }
    }

    @Override
    public void start() {
        for (ITmfEventRequest request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.start();
        }
        super.start();
    }

    @Override
    public void done() {
        for (ITmfEventRequest request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.done();
        }
        super.done();
    }

    @Override
    public void fail() {
        for (ITmfEventRequest request : this.fRequests) {
            request.fail();
        }
        super.fail();
    }

    @Override
    public void cancel() {
        for (ITmfEventRequest request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.cancel();
        }
        super.cancel();
    }

    @Override
    public synchronized boolean isCompleted() {
        if (super.isCompleted()) {
            return true;
        }
        if (this.fRequests.size() > 0) {
            for (ITmfEventRequest request : this.fRequests) {
                if (request.isCompleted()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        if (super.isCancelled()) {
            return true;
        }
        if (this.fRequests.size() > 0) {
            for (ITmfEventRequest request : this.fRequests) {
                if (request.isCancelled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfCoalescedEventRequest) {
            TmfCoalescedEventRequest request = (TmfCoalescedEventRequest)other;
            return request.getDataType() == this.getDataType() && request.getIndex() == this.getIndex() && request.getNbRequested() == this.getNbRequested() && request.getRange().equals(this.fRange);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfCoalescedEventRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + (Object)((Object)this.getExecType()) + "," + this.getRange() + "," + this.getIndex() + "," + this.getNbRequested() + ", " + this.fRequests.toString() + ")]";
    }
}

