/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap;

import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.mipmap.TmfMipmapFeature;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;

public class MaxMipmapFeature
extends TmfMipmapFeature {
    public MaxMipmapFeature(int baseQuark, int mipmapQuark, int mipmapResolution, ITmfStateSystemBuilder ss) {
        super(baseQuark, mipmapQuark, mipmapResolution, ss);
    }

    @Override
    protected ITmfStateValue computeMipmapValue(List<ITmfStateInterval> lowerIntervals, long startTime, long endTime) {
        ITmfStateValue maxValue = null;
        try {
            for (ITmfStateInterval interval : lowerIntervals) {
                ITmfStateValue value = interval.getStateValue();
                if (value.getType() == ITmfStateValue.Type.DOUBLE) {
                    if (maxValue != null && !(value.unboxDouble() > maxValue.unboxDouble())) continue;
                    maxValue = value;
                    continue;
                }
                if (maxValue != null && value.unboxLong() <= maxValue.unboxLong()) continue;
                maxValue = value;
            }
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        return maxValue;
    }
}

