/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace.indexer;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.linuxtools.internal.tmf.core.trace.indexer.BTree;
import org.eclipse.linuxtools.internal.tmf.core.trace.indexer.BTreeNode;

public class BTreeNodeCache {
    private static final int CACHE_SIZE = 15;
    private final BTree fTree;
    private BTreeNode fRootNode = null;
    private final Deque<BTreeNode> fCachedNodes = new ArrayDeque<BTreeNode>(15);
    private int fCcheMisses = 0;

    BTreeNodeCache(BTree tree) {
        this.fTree = tree;
    }

    BTreeNode getNode(long offset) {
        if (this.fRootNode != null && this.fRootNode.getOffset() == offset) {
            return this.fRootNode;
        }
        for (BTreeNode nodeSearch : this.fCachedNodes) {
            if (nodeSearch.getOffset() != offset) continue;
            this.fCachedNodes.remove(nodeSearch);
            this.fCachedNodes.push(nodeSearch);
            return nodeSearch;
        }
        ++this.fCcheMisses;
        BTreeNode node = new BTreeNode(this.fTree, offset);
        node.serializeIn();
        this.addNode(node);
        return node;
    }

    void serialize() {
        if (this.fRootNode != null && this.fRootNode.isDirty()) {
            this.fRootNode.serializeOut();
        }
        for (BTreeNode nodeSearch : this.fCachedNodes) {
            if (!nodeSearch.isDirty()) continue;
            nodeSearch.serializeOut();
        }
    }

    void addNode(BTreeNode node) {
        BTreeNode removed;
        if (this.fCachedNodes.size() >= 15 && (removed = this.fCachedNodes.removeLast()).isDirty()) {
            removed.serializeOut();
        }
        this.fCachedNodes.push(node);
    }

    void setRootNode(BTreeNode newRootNode) {
        BTreeNode oldRootNode = this.fRootNode;
        this.fRootNode = newRootNode;
        if (oldRootNode != null) {
            this.addNode(oldRootNode);
        }
    }

    int getCacheMisses() {
        return this.fCcheMisses;
    }
}

