/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace.indexer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.internal.tmf.core.trace.indexer.AbstractFileCheckpointCollection;
import org.eclipse.linuxtools.internal.tmf.core.trace.indexer.Messages;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;

public class FlatArray
extends AbstractFileCheckpointCollection {
    public static final String INDEX_FILE_NAME = "checkpoint_flatarray.idx";
    private int fCheckpointSize = this.getTrace().getCheckpointSize();
    private ByteBuffer fByteBuffer = ByteBuffer.allocate(this.fCheckpointSize);

    public FlatArray(File file, ITmfPersistentlyIndexable trace) {
        super(file, trace);
        this.fByteBuffer.clear();
    }

    @Override
    public void insert(ITmfCheckpoint checkpoint) {
        try {
            AbstractFileCheckpointCollection.CheckpointCollectionFileHeader header = this.getHeader();
            ++header.fSize;
            this.getRandomAccessFile().seek(this.getRandomAccessFile().length());
            this.fByteBuffer.clear();
            checkpoint.serialize(this.fByteBuffer);
            this.getRandomAccessFile().write(this.fByteBuffer.array());
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.FlatArray_IOErrorWriting, this.getFile()), e);
        }
    }

    public ITmfCheckpoint get(long rank) {
        TmfCheckpoint checkpoint = null;
        try {
            long pos = (long)this.getHeader().getSize() + (long)this.fCheckpointSize * rank;
            this.getRandomAccessFile().seek(pos);
            this.fByteBuffer.clear();
            this.getRandomAccessFile().read(this.fByteBuffer.array());
            ITmfLocation location = this.getTrace().restoreLocation(this.fByteBuffer);
            TmfTimestamp timeStamp = new TmfTimestamp(this.fByteBuffer);
            checkpoint = new TmfCheckpoint((ITmfTimestamp)timeStamp, location, this.fByteBuffer);
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.FlatArray_IOErrorReading, this.getFile()), e);
        }
        return checkpoint;
    }

    @Override
    public long binarySearch(ITmfCheckpoint checkpoint) {
        if (this.getHeader().fSize == 1) {
            return 0L;
        }
        long lower = 0L;
        long upper = this.getHeader().fSize - 1;
        long lastMiddle = -1L;
        long middle = 0L;
        while (lower <= upper && lastMiddle != middle) {
            lastMiddle = middle;
            middle = (lower + upper) / 2L;
            ITmfCheckpoint found = this.get(middle);
            this.incCacheMisses();
            int compare = checkpoint.compareTo(found);
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                upper = middle;
                continue;
            }
            lower = middle + 1L;
        }
        long insertionPoint = lower;
        return -insertionPoint - 1L;
    }
}

