/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.component;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.internal.tmf.core.component.TmfEventThread;
import org.eclipse.linuxtools.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfRequestExecutor;
import org.eclipse.linuxtools.tmf.core.component.ITmfEventProvider;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;

public abstract class TmfEventProvider
extends TmfComponent
implements ITmfEventProvider {
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    private static final long DELAY = 1000L;
    private final List<TmfCoalescedEventRequest> fPendingCoalescedRequests = new LinkedList<TmfCoalescedEventRequest>();
    private Class<? extends ITmfEvent> fType;
    private final TmfRequestExecutor fExecutor;
    private final Object fLock = new Object();
    private int fSignalDepth = 0;
    private int fRequestPendingCounter = 0;
    private Timer fTimer;
    private boolean fIsTimeout = false;

    public TmfEventProvider() {
        this.fExecutor = new TmfRequestExecutor();
    }

    public TmfEventProvider(String name, Class<? extends ITmfEvent> type) {
        this();
        this.init(name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String name, Class<? extends ITmfEvent> type) {
        super.init(name);
        this.fType = type;
        this.fExecutor.init();
        this.fSignalDepth = 0;
        Object object = this.fLock;
        synchronized (object) {
            this.fTimer = new Timer();
        }
        TmfProviderManager.register(this.fType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        TmfProviderManager.deregister(this.fType, this);
        this.fExecutor.stop();
        Object object = this.fLock;
        synchronized (object) {
            if (this.fTimer != null) {
                this.fTimer.cancel();
            }
            this.fTimer = null;
        }
        super.dispose();
    }

    public Class<? extends ITmfEvent> getType() {
        return this.fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            if (request.getExecType() == ITmfEventRequest.ExecutionType.FOREGROUND) {
                if (this.fSignalDepth > 0 || this.fRequestPendingCounter > 0) {
                    this.coalesceEventRequest(request);
                } else {
                    this.queueRequest(request);
                }
                return;
            }
            if (this.fTimer == null) {
                this.queueRequest(request);
                return;
            }
            boolean startTimer = this.getNbPendingBackgroundRequests() == 0;
            this.coalesceEventRequest(request);
            if (startTimer) {
                TimerTask task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TmfEventProvider.this.fLock;
                        synchronized (object) {
                            TmfEventProvider.this.fIsTimeout = true;
                            TmfEventProvider.this.fireRequest();
                        }
                    }
                };
                this.fTimer.schedule(task, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRequest() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fRequestPendingCounter > 0) {
                return;
            }
            if (this.fPendingCoalescedRequests.size() > 0) {
                Iterator<TmfCoalescedEventRequest> iter = this.fPendingCoalescedRequests.iterator();
                while (iter.hasNext()) {
                    ITmfEventRequest request;
                    ITmfEventRequest.ExecutionType type = this.fIsTimeout ? ITmfEventRequest.ExecutionType.BACKGROUND : ITmfEventRequest.ExecutionType.FOREGROUND;
                    if (type != (request = (ITmfEventRequest)iter.next()).getExecType()) continue;
                    this.queueRequest(request);
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingRequest(boolean isIncrement) {
        Object object = this.fLock;
        synchronized (object) {
            if (isIncrement) {
                ++this.fRequestPendingCounter;
            } else {
                if (this.fRequestPendingCounter > 0) {
                    --this.fRequestPendingCounter;
                }
                if (this.fRequestPendingCounter == 0) {
                    this.fireRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newCoalescedEventRequest(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(request.getDataType(), request.getRange(), request.getIndex(), request.getNbRequested(), request.getExecType());
            coalescedRequest.addRequest(request);
            if (TmfCoreTracer.isRequestTraced()) {
                TmfCoreTracer.traceRequest(request, "COALESCED with " + coalescedRequest.getRequestId());
                TmfCoreTracer.traceRequest(coalescedRequest, "now contains " + coalescedRequest.getSubRequestIds());
            }
            this.fPendingCoalescedRequests.add(coalescedRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coalesceEventRequest(ITmfEventRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            for (TmfCoalescedEventRequest coalescedRequest : this.fPendingCoalescedRequests) {
                if (!coalescedRequest.isCompatible(request)) continue;
                coalescedRequest.addRequest(request);
                if (TmfCoreTracer.isRequestTraced()) {
                    TmfCoreTracer.traceRequest(request, "COALESCED with " + coalescedRequest.getRequestId());
                    TmfCoreTracer.traceRequest(coalescedRequest, "now contains " + coalescedRequest.getSubRequestIds());
                }
                return;
            }
            this.newCoalescedEventRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNbPendingBackgroundRequests() {
        int nbBackgroundRequests = 0;
        Object object = this.fLock;
        synchronized (object) {
            for (ITmfEventRequest iTmfEventRequest : this.fPendingCoalescedRequests) {
                if (iTmfEventRequest.getExecType() != ITmfEventRequest.ExecutionType.BACKGROUND) continue;
                ++nbBackgroundRequests;
            }
        }
        return nbBackgroundRequests;
    }

    protected void queueRequest(ITmfEventRequest request) {
        if (this.fExecutor.isShutdown()) {
            request.cancel();
            return;
        }
        TmfEventThread thread = new TmfEventThread(this, request);
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(request, "QUEUED");
        }
        this.fExecutor.execute(thread);
    }

    public abstract ITmfContext armRequest(ITmfEventRequest var1);

    public boolean isCompleted(ITmfEventRequest request, ITmfEvent event, int nbRead) {
        boolean requestCompleted = TmfEventProvider.isCompleted2(request, nbRead);
        if (!requestCompleted) {
            ITmfTimestamp endTime = request.getRange().getEndTime();
            return event.getTimestamp().compareTo(endTime, false) > 0;
        }
        return requestCompleted;
    }

    private static boolean isCompleted2(ITmfEventRequest request, int nbRead) {
        return request.isCompleted() || nbRead >= request.getNbRequested();
    }

    protected boolean executorIsShutdown() {
        return this.fExecutor.isShutdown();
    }

    protected boolean executorIsTerminated() {
        return this.fExecutor.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void startSynch(TmfStartSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            ++this.fSignalDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void endSynch(TmfEndSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            --this.fSignalDepth;
            if (this.fSignalDepth == 0) {
                this.fIsTimeout = false;
                this.fireRequest();
            }
        }
    }
}

