/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.request;

import java.util.concurrent.CountDownLatch;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;

public abstract class TmfEventRequest
implements ITmfEventRequest {
    private static int fRequestNumber = 0;
    private final Class<? extends ITmfEvent> fDataType;
    private final ITmfEventRequest.ExecutionType fExecType;
    private final int fRequestId;
    private final TmfTimeRange fRange;
    protected long fIndex;
    protected int fNbRequested;
    private int fNbRead;
    private final CountDownLatch startedLatch = new CountDownLatch(1);
    private final CountDownLatch completedLatch = new CountDownLatch(1);
    private boolean fRequestRunning;
    private boolean fRequestCompleted;
    private boolean fRequestFailed;
    private boolean fRequestCanceled;

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
        this(dataType, TmfTimeRange.ETERNITY, index, nbRequested, priority);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
        this.fRequestId = fRequestNumber++;
        this.fDataType = dataType;
        this.fIndex = index;
        this.fNbRequested = nbRequested;
        this.fExecType = priority;
        this.fRange = range;
        this.fNbRead = 0;
        this.fRequestRunning = false;
        this.fRequestCompleted = false;
        this.fRequestFailed = false;
        this.fRequestCanceled = false;
        if (TmfCoreTracer.isRequestTraced()) {
            String type = this.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            String message = "CREATED " + (this.getExecType() == ITmfEventRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " Range=" + this.getRange() + " DataType=" + this.getDataType().getSimpleName();
            TmfCoreTracer.traceRequest(this, message);
        }
    }

    public static void reset() {
        fRequestNumber = 0;
    }

    @Override
    public int getRequestId() {
        return this.fRequestId;
    }

    @Override
    public long getIndex() {
        return this.fIndex;
    }

    @Override
    public ITmfEventRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    @Override
    public int getNbRequested() {
        return this.fNbRequested;
    }

    @Override
    public synchronized int getNbRead() {
        return this.fNbRead;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.fRequestRunning;
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.fRequestCompleted;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.fRequestFailed;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.fRequestCanceled;
    }

    @Override
    public Class<? extends ITmfEvent> getDataType() {
        return this.fDataType;
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    protected void setIndex(int index) {
        this.fIndex = index;
    }

    @Override
    public void setStartIndex(int index) {
        this.setIndex(index);
    }

    @Override
    public void handleData(ITmfEvent event) {
        ++this.fNbRead;
    }

    @Override
    public void handleStarted() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "STARTED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCompleted() {
        boolean requestFailed = false;
        boolean requestCanceled = false;
        TmfEventRequest tmfEventRequest = this;
        synchronized (tmfEventRequest) {
            requestFailed = this.fRequestFailed;
            requestCanceled = this.fRequestCanceled;
        }
        if (requestFailed) {
            this.handleFailure();
        } else if (requestCanceled) {
            this.handleCancel();
        } else {
            this.handleSuccess();
        }
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "COMPLETED (" + this.fNbRead + " events read)");
        }
    }

    @Override
    public void handleSuccess() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "SUCCEEDED");
        }
    }

    @Override
    public void handleFailure() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "FAILED");
        }
    }

    @Override
    public void handleCancel() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "CANCELLED");
        }
    }

    public void waitForStart() throws InterruptedException {
        while (!this.fRequestRunning) {
            this.startedLatch.await();
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        while (!this.fRequestCompleted) {
            this.completedLatch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        TmfEventRequest tmfEventRequest = this;
        synchronized (tmfEventRequest) {
            this.fRequestRunning = true;
        }
        this.handleStarted();
        this.startedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        TmfEventRequest tmfEventRequest = this;
        synchronized (tmfEventRequest) {
            if (this.fRequestCompleted) {
                return;
            }
            this.fRequestRunning = false;
            this.fRequestCompleted = true;
        }
        try {
            this.handleCompleted();
        }
        finally {
            this.completedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        TmfEventRequest tmfEventRequest = this;
        synchronized (tmfEventRequest) {
            this.fRequestFailed = true;
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        TmfEventRequest tmfEventRequest = this;
        synchronized (tmfEventRequest) {
            this.fRequestCanceled = true;
        }
        this.done();
    }

    public int hashCode() {
        return this.getRequestId();
    }

    public boolean equals(Object other) {
        if (other instanceof TmfEventRequest) {
            TmfEventRequest request = (TmfEventRequest)other;
            return request.fDataType == this.fDataType && request.fIndex == this.fIndex && request.fNbRequested == this.fNbRequested && request.fRange.equals(this.fRange);
        }
        return false;
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(dot + 1);
        }
        return String.valueOf('[') + name + '(' + this.getRequestId() + ',' + this.getDataType().getSimpleName() + ',' + (Object)((Object)this.getExecType()) + ',' + this.getRange() + ',' + this.getIndex() + ',' + this.getNbRequested() + ")]";
    }
}

