/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentContext;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentLocation;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSynchronizedSignal;
import org.eclipse.linuxtools.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.linuxtools.tmf.core.synchronization.SynchronizationManager;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;

public class TmfExperiment
extends TmfTrace
implements ITmfEventParser,
ITmfPersistentlyIndexable {
    public static final String SYNCHRONIZATION_FILE_NAME = "synchronization.bin";
    public static final int DEFAULT_INDEX_PAGE_SIZE = 5000;
    protected ITmfTrace[] fTraces;
    private boolean fInitialized = false;

    public TmfExperiment() {
    }

    public TmfExperiment(Class<? extends ITmfEvent> type, String id, ITmfTrace[] traces) {
        this(type, id, traces, 5000, null);
    }

    public TmfExperiment(Class<? extends ITmfEvent> type, String id, ITmfTrace[] traces, IResource resource) {
        this(type, id, traces, 5000, resource);
    }

    public TmfExperiment(Class<? extends ITmfEvent> type, String path, ITmfTrace[] traces, int indexPageSize) {
        this(type, path, traces, indexPageSize, null);
    }

    public TmfExperiment(Class<? extends ITmfEvent> type, String path, ITmfTrace[] traces, int indexPageSize, IResource resource) {
        this.initExperiment(type, path, traces, indexPageSize, resource);
    }

    @Override
    protected ITmfTraceIndexer createIndexer(int interval) {
        if (this.getCheckpointSize() > 0) {
            return new TmfBTreeTraceIndexer(this, interval);
        }
        return super.createIndexer(interval);
    }

    @Override
    public synchronized void dispose() {
        if (this.getIndexer() != null) {
            this.getIndexer().dispose();
        }
        if (this.fTraces != null) {
            ITmfTrace[] iTmfTraceArray = this.fTraces;
            int n = this.fTraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace trace = iTmfTraceArray[n2];
                trace.dispose();
                ++n2;
            }
            this.fTraces = null;
        }
        super.dispose();
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) {
    }

    public void initExperiment(Class<? extends ITmfEvent> type, String path, ITmfTrace[] traces, int indexPageSize, IResource resource) {
        this.setCacheSize(indexPageSize);
        this.setStreamingInterval(0L);
        this.setParser(this);
        this.fTraces = traces;
        try {
            super.initialize(resource, path, type);
        }
        catch (TmfTraceException e) {
            Activator.logError("Error initializing experiment", e);
        }
        if (resource != null) {
            try {
                this.synchronizeTraces();
            }
            catch (TmfTraceException e) {
                Activator.logError("Error synchronizing experiment", e);
            }
        }
    }

    @Override
    public IStatus validate(IProject project, String path) {
        return Status.OK_STATUS;
    }

    public ITmfTrace[] getTraces() {
        return this.fTraces;
    }

    public ITmfTimestamp getTimestamp(int index) {
        ITmfContext context = this.seekEvent(index);
        ITmfEvent event = this.getNext(context);
        context.dispose();
        return event != null ? event.getTimestamp() : null;
    }

    @Override
    public synchronized ITmfContext armRequest(ITmfEventRequest request) {
        if (this.fTraces == null) {
            return null;
        }
        if (!TmfTimestamp.BIG_BANG.equals(request.getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(request.getRange().getStartTime());
            request.setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfLocation location) {
        if (location != null && !(location instanceof TmfExperimentLocation)) {
            return null;
        }
        if (this.fTraces == null) {
            return null;
        }
        TmfLocationArray locationArray = location == null ? new TmfLocationArray(this.fTraces.length) : ((TmfExperimentLocation)location).getLocationInfo();
        ITmfLocation[] locations = locationArray.getLocations();
        long[] ranks = locationArray.getRanks();
        TmfExperimentContext context = new TmfExperimentContext(this.fTraces.length);
        long rank = 0L;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfContext traceContext = this.fTraces[i].seekEvent(locations[i]);
            context.setContext(i, traceContext);
            traceContext.setRank(ranks[i]);
            locations[i] = traceContext.getLocation();
            context.setEvent(i, this.fTraces[i].getNext(traceContext));
            rank += ranks[i];
            ++i;
        }
        context.setLocation(new TmfExperimentLocation(new TmfLocationArray(locations, ranks)));
        context.setLastTrace(-1);
        context.setRank(rank);
        return context;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        ITmfContext context = this.seekEvent(Math.round(ratio * (double)this.getNbEvents()));
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation location) {
        if (location instanceof TmfExperimentLocation) {
            long rank = 0L;
            TmfLocationArray locationArray = ((TmfExperimentLocation)location).getLocationInfo();
            int i = 0;
            while (i < locationArray.size()) {
                rank += locationArray.getRank(i);
                ++i;
            }
            return (double)rank / (double)this.getNbEvents();
        }
        return 0.0;
    }

    @Override
    public ITmfLocation getCurrentLocation() {
        return null;
    }

    @Override
    public synchronized ITmfEvent parseEvent(ITmfContext context) {
        ITmfContext tmpContext = this.seekEvent(context.getLocation());
        ITmfEvent event = this.getNext(tmpContext);
        return event;
    }

    @Override
    public synchronized ITmfEvent getNext(ITmfContext context) {
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (this.fTraces == null) {
            return null;
        }
        TmfExperimentContext expContext = (TmfExperimentContext)context;
        int lastTrace = expContext.getLastTrace();
        if (lastTrace != -1) {
            ITmfContext traceContext = expContext.getContext(lastTrace);
            expContext.setEvent(lastTrace, this.fTraces[lastTrace].getNext(traceContext));
            expContext.setLastTrace(-1);
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfTimestamp otherTS;
            ITmfEvent event = expContext.getEvent(i);
            if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                trace = i;
                timestamp = otherTS;
            }
            ++i;
        }
        ITmfEvent event = null;
        if (trace != -1 && (event = expContext.getEvent(trace)) != null) {
            this.updateAttributes(expContext, event.getTimestamp());
            expContext.increaseRank();
            expContext.setLastTrace(trace);
            ITmfContext traceContext = expContext.getContext(trace);
            if (traceContext == null) {
                throw new IllegalStateException();
            }
            TmfLocationArray locationArray = new TmfLocationArray(((TmfExperimentLocation)expContext.getLocation()).getLocationInfo(), trace, traceContext.getLocation(), traceContext.getRank());
            expContext.setLocation(new TmfExperimentLocation(locationArray));
            this.processEvent(event);
        }
        return event;
    }

    @Override
    public ITmfTimestamp getInitialRangeOffset() {
        if (this.fTraces == null || this.fTraces.length == 0) {
            return super.getInitialRangeOffset();
        }
        ITmfTimestamp initTs = TmfTimestamp.BIG_CRUNCH;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfTimestamp ts = this.fTraces[i].getInitialRangeOffset();
            if (ts.compareTo(initTs) < 0) {
                initTs = ts;
            }
            ++i;
        }
        return initTs;
    }

    public synchronized SynchronizationAlgorithm synchronizeTraces() throws TmfTraceException {
        return this.synchronizeTraces(false);
    }

    public synchronized SynchronizationAlgorithm synchronizeTraces(boolean doSync) throws TmfTraceException {
        IResource resource = this.getResource();
        String supplDirectory = null;
        try {
            if (resource != null) {
                supplDirectory = resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
            }
        }
        catch (CoreException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        File syncFile = supplDirectory != null ? new File(String.valueOf(supplDirectory) + File.separator + SYNCHRONIZATION_FILE_NAME) : null;
        SynchronizationAlgorithm syncAlgo = SynchronizationManager.synchronizeTraces(syncFile, Arrays.asList(this.fTraces), doSync);
        final TmfTraceSynchronizedSignal signal = new TmfTraceSynchronizedSignal((Object)this, syncAlgo);
        new Thread(){

            @Override
            public void run() {
                TmfExperiment.this.broadcast(signal);
            }
        }.start();
        return syncAlgo;
    }

    @Override
    public synchronized String toString() {
        return "[TmfExperiment (" + this.getName() + ")]";
    }

    private synchronized void initializeStreamingMonitor() {
        if (this.fInitialized) {
            return;
        }
        this.fInitialized = true;
        if (this.getStreamingInterval() == 0L) {
            ITmfContext context = this.seekEvent(0L);
            ITmfEvent event = this.getNext(context);
            context.dispose();
            if (event == null) {
                return;
            }
            TmfTimeRange timeRange = new TmfTimeRange(event.getTimestamp(), TmfTimestamp.BIG_CRUNCH);
            final TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal(this, this, timeRange);
            new Thread(){

                @Override
                public void run() {
                    TmfExperiment.this.broadcast(signal);
                }
            }.start();
            return;
        }
        Thread thread = new Thread("Streaming Monitor for experiment " + this.getName()){
            private ITmfTimestamp safeTimestamp;
            private ITmfTimestamp lastSafeTimestamp;
            private TmfTimeRange timeRange;
            {
                this.safeTimestamp = null;
                this.lastSafeTimestamp = null;
                this.timeRange = null;
            }

            @Override
            public void run() {
                while (!TmfExperiment.this.executorIsShutdown()) {
                    if (!TmfExperiment.this.getIndexer().isIndexing()) {
                        ITmfTimestamp startTimestamp = TmfTimestamp.BIG_CRUNCH;
                        ITmfTimestamp endTimestamp = TmfTimestamp.BIG_BANG;
                        ITmfTrace[] iTmfTraceArray = TmfExperiment.this.fTraces;
                        int n = TmfExperiment.this.fTraces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITmfTrace trace = iTmfTraceArray[n2];
                            if (trace.getStartTime().compareTo(startTimestamp) < 0) {
                                startTimestamp = trace.getStartTime();
                            }
                            if (trace.getStreamingInterval() != 0L && trace.getEndTime().compareTo(endTimestamp) > 0) {
                                endTimestamp = trace.getEndTime();
                            }
                            ++n2;
                        }
                        if (this.safeTimestamp != null && (this.lastSafeTimestamp == null || this.safeTimestamp.compareTo(this.lastSafeTimestamp, false) > 0)) {
                            this.timeRange = new TmfTimeRange(startTimestamp, this.safeTimestamp);
                            this.lastSafeTimestamp = this.safeTimestamp;
                        } else {
                            this.timeRange = null;
                        }
                        this.safeTimestamp = endTimestamp;
                        if (this.timeRange != null) {
                            TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal(TmfExperiment.this, TmfExperiment.this, this.timeRange);
                            TmfExperiment.this.broadcast(signal);
                        }
                    }
                    try {
                        Thread.sleep(TmfExperiment.this.getStreamingInterval());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    @Override
    public long getStreamingInterval() {
        long interval = 0L;
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            interval = Math.max(interval, trace.getStreamingInterval());
            ++n2;
        }
        return interval;
    }

    @Override
    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        if (signal.getTrace() == this) {
            this.initializeStreamingMonitor();
            MultiStatus status = new MultiStatus("org.eclipse.linuxtools.tmf.core", 0, null, null);
            status.add(this.executeAnalysis());
            if (!status.isOK()) {
                Activator.log((IStatus)status);
            }
            TmfTraceManager.refreshSupplementaryFiles(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int getCheckpointSize() {
        int totalCheckpointSize = 0;
        try {
            if (this.fTraces == null) return totalCheckpointSize;
            ITmfTrace[] iTmfTraceArray = this.fTraces;
            int n = this.fTraces.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return totalCheckpointSize;
                }
                ITmfTrace trace = iTmfTraceArray[n2];
                if (!(trace instanceof ITmfPersistentlyIndexable)) {
                    return 0;
                }
                ITmfPersistentlyIndexable persistableIndexTrace = (ITmfPersistentlyIndexable)((Object)trace);
                int currentTraceCheckpointSize = persistableIndexTrace.getCheckpointSize();
                if (currentTraceCheckpointSize <= 0) {
                    return 0;
                }
                totalCheckpointSize += currentTraceCheckpointSize;
                totalCheckpointSize += 8;
                ++n2;
            }
        }
        catch (UnsupportedOperationException e) {
            return 0;
        }
    }

    @Override
    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        ITmfLocation[] locations = new ITmfLocation[this.fTraces.length];
        long[] ranks = new long[this.fTraces.length];
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfTrace trace = this.fTraces[i];
            locations[i] = ((ITmfPersistentlyIndexable)((Object)trace)).restoreLocation(bufferIn);
            ranks[i] = bufferIn.getLong();
            ++i;
        }
        TmfLocationArray arr = new TmfLocationArray(locations, ranks);
        TmfExperimentLocation l = new TmfExperimentLocation(arr);
        return l;
    }
}

