/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.GetMetadataReturnCode;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.IRelayResponse;

public class MetadataPacketResponse
implements IRelayResponse {
    private static final int SIZE = 12;
    private final GetMetadataReturnCode fStatus;
    private final byte[] fData;

    public MetadataPacketResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[12];
        inNet.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        long length = bb.getLong();
        this.fStatus = GetMetadataReturnCode.values()[bb.getInt() - 1];
        if (length >= Integer.MAX_VALUE) {
            throw new IOException("Metadata Packet too big " + length);
        }
        this.fData = new byte[(int)length];
        inNet.readFully(this.fData);
    }

    public byte[] getData() {
        return this.fData;
    }

    public GetMetadataReturnCode getStatus() {
        return this.fStatus;
    }
}

