/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.dialogs;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersCSVExporter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class STDataViewersExportToCSVDialog
extends Dialog {
    private Text previewText = null;
    private Text outputFile = null;
    private Text separatorText = null;
    private Text childLinkText = null;
    private Text noChildLinkText = null;
    private Text childMarkerText = null;
    private Text lastChildMarkerText = null;
    private Text leafMarkerText = null;
    private Text nodeMarkerText = null;
    private Label childLinkLabel = null;
    private Label noChildLinkLabel = null;
    private Label childMarkerLabel = null;
    private Label lastChildMarkerLabel = null;
    private Label leafMarkerLabel = null;
    private Label nodeMarkerLabel = null;
    private Button expandAllButton = null;
    private Button showHiddenColumnsButton = null;
    private Button exportTreePrefixButton = null;
    private STDataViewersCSVExporter exporter = null;
    private ModifyListener updatePreviewModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            STDataViewersExportToCSVDialog.this.updatePreview();
        }
    };
    private SelectionListener updatePreviewSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            STDataViewersExportToCSVDialog.this.updatePreview();
        }
    };

    public STDataViewersExportToCSVDialog(Shell parentShell, STDataViewersCSVExporter exporter) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.exporter = exporter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Export to CSV");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(4, 4, true, true, 2, 1);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        if (this.exporter == null) {
            return composite;
        }
        this.initializeDialogUnits((Control)composite);
        this.createOutputFileArea(composite);
        this.createCSVConfigArea(composite);
        if (this.exporter.isTreeViewerExporter()) {
            this.createTreePrefixConfigArea(composite);
        }
        this.createCSVPreviewArea(composite);
        this.createRestoreDefaultsButton(composite);
        this.createSeparatorLine(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setDefaultWidgetsValues();
        return composite;
    }

    private void createOutputFileArea(Composite composite) {
        Group outputGroup = new Group(composite, 0);
        outputGroup.setText("Output file");
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        outputGroup.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        outputGroup.setLayout((Layout)layout);
        Label outputLabel = new Label((Composite)outputGroup, 0);
        outputLabel.setText("Output file:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        outputLabel.setLayoutData((Object)layoutData);
        this.outputFile = new Text((Composite)outputGroup, 2048);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.outputFile.setLayoutData((Object)layoutData);
        Composite browseComposite = new Composite((Composite)outputGroup, 0);
        layoutData = new GridData(131072, 4, false, false, 2, 1);
        browseComposite.setLayoutData((Object)layoutData);
        layout = new GridLayout(2, false);
        browseComposite.setLayout((Layout)layout);
        Button browseOutputButton = new Button(browseComposite, 8);
        browseOutputButton.setText("File System...");
        browseOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STDataViewersExportToCSVDialog.this.handleBrowse();
            }
        });
        layoutData = new GridData(131072, 4, false, false, 1, 1);
        browseOutputButton.setLayoutData((Object)layoutData);
        Button browseOutputInWorkspaceButton = new Button(browseComposite, 8);
        browseOutputInWorkspaceButton.setText("Workspace...");
        browseOutputInWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STDataViewersExportToCSVDialog.this.handleBrowseWorkspace();
            }
        });
        layoutData = new GridData(131072, 4, false, false, 1, 1);
        browseOutputInWorkspaceButton.setLayoutData((Object)layoutData);
    }

    private void createCSVConfigArea(Composite composite) {
        Group configGroup = new Group(composite, 0);
        configGroup.setText("CSV Configuration");
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        configGroup.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        configGroup.setLayout((Layout)layout);
        Label separatorLabel = new Label((Composite)configGroup, 0);
        separatorLabel.setText("CSV Separator:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        separatorLabel.setLayoutData((Object)layoutData);
        this.separatorText = new Text((Composite)configGroup, 2048);
        this.separatorText.setFont(JFaceResources.getTextFont());
        this.separatorText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.separatorText.setLayoutData((Object)layoutData);
        if (this.exporter.isTreeViewerExporter()) {
            this.expandAllButton = new Button((Composite)configGroup, 32);
            this.expandAllButton.setText("Expand All");
            layoutData = new GridData(4, 4, false, false, 1, 1);
            this.expandAllButton.setLayoutData((Object)layoutData);
        } else {
            new Label((Composite)configGroup, 0).setText("          ");
        }
        this.showHiddenColumnsButton = new Button((Composite)configGroup, 32);
        this.showHiddenColumnsButton.setText("Export Hidden Columns");
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.showHiddenColumnsButton.setLayoutData((Object)layoutData);
    }

    private void createTreePrefixConfigArea(Composite composite) {
        Group prefixConfigGroup = new Group(composite, 0);
        prefixConfigGroup.setText("Tree ascii-art drawing");
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        prefixConfigGroup.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(5, false);
        prefixConfigGroup.setLayout((Layout)layout);
        this.exportTreePrefixButton = new Button((Composite)prefixConfigGroup, 32);
        this.exportTreePrefixButton.setText("Export ascii-art tree");
        this.exportTreePrefixButton.addSelectionListener(this.updatePreviewSelectionListener);
        this.exportTreePrefixButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = STDataViewersExportToCSVDialog.this.exportTreePrefixButton.getSelection();
                STDataViewersExportToCSVDialog.this.enableTreePrefixText(enabled);
            }
        });
        layoutData = new GridData(4, 4, false, false, 2, 1);
        this.exportTreePrefixButton.setLayoutData((Object)layoutData);
        Label blankLabel = new Label((Composite)prefixConfigGroup, 0);
        blankLabel.setText("");
        layoutData = new GridData(16384, 0x1000000, false, false, 3, 1);
        blankLabel.setLayoutData((Object)layoutData);
        this.childLinkLabel = new Label((Composite)prefixConfigGroup, 0);
        this.childLinkLabel.setText("Child Link:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.childLinkLabel.setLayoutData((Object)layoutData);
        this.childLinkText = new Text((Composite)prefixConfigGroup, 2048);
        this.childLinkText.setFont(JFaceResources.getTextFont());
        this.childLinkText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.childLinkText.setLayoutData((Object)layoutData);
        Label separator = new Label((Composite)prefixConfigGroup, 514);
        layoutData = new GridData(0x1000000, 4, false, true, 1, 3);
        separator.setLayoutData((Object)layoutData);
        this.noChildLinkLabel = new Label((Composite)prefixConfigGroup, 0);
        this.noChildLinkLabel.setText("No-child Link:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.noChildLinkLabel.setLayoutData((Object)layoutData);
        this.noChildLinkText = new Text((Composite)prefixConfigGroup, 2048);
        this.noChildLinkText.setFont(JFaceResources.getTextFont());
        this.noChildLinkText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.noChildLinkText.setLayoutData((Object)layoutData);
        this.childMarkerLabel = new Label((Composite)prefixConfigGroup, 0);
        this.childMarkerLabel.setText("Child Marker:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.childMarkerLabel.setLayoutData((Object)layoutData);
        this.childMarkerText = new Text((Composite)prefixConfigGroup, 2048);
        this.childMarkerText.setFont(JFaceResources.getTextFont());
        this.childMarkerText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.childMarkerText.setLayoutData((Object)layoutData);
        this.lastChildMarkerLabel = new Label((Composite)prefixConfigGroup, 0);
        this.lastChildMarkerLabel.setText("Last child Marker:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lastChildMarkerLabel.setLayoutData((Object)layoutData);
        this.lastChildMarkerText = new Text((Composite)prefixConfigGroup, 2048);
        this.lastChildMarkerText.setFont(JFaceResources.getTextFont());
        this.lastChildMarkerText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.lastChildMarkerText.setLayoutData((Object)layoutData);
        this.leafMarkerLabel = new Label((Composite)prefixConfigGroup, 0);
        this.leafMarkerLabel.setText("Leaf Marker:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.leafMarkerLabel.setLayoutData((Object)layoutData);
        this.leafMarkerText = new Text((Composite)prefixConfigGroup, 2048);
        this.leafMarkerText.setFont(JFaceResources.getTextFont());
        this.leafMarkerText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.leafMarkerText.setLayoutData((Object)layoutData);
        this.nodeMarkerLabel = new Label((Composite)prefixConfigGroup, 0);
        this.nodeMarkerLabel.setText("Non-leaf Marker:");
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.nodeMarkerLabel.setLayoutData((Object)layoutData);
        this.nodeMarkerText = new Text((Composite)prefixConfigGroup, 2048);
        this.nodeMarkerText.setFont(JFaceResources.getTextFont());
        this.nodeMarkerText.addModifyListener(this.updatePreviewModifyListener);
        layoutData = new GridData(4, 4, true, false, 1, 1);
        this.nodeMarkerText.setLayoutData((Object)layoutData);
    }

    private void createCSVPreviewArea(Composite composite) {
        Group previewGroup = new Group(composite, 0);
        previewGroup.setText("Preview");
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        previewGroup.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        previewGroup.setLayout((Layout)layout);
        this.previewText = new Text((Composite)previewGroup, 2826);
        this.previewText.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        this.previewText.setFont(JFaceResources.getTextFont());
        layoutData = new GridData(4, 4, true, true, 1, 8);
        this.previewText.setLayoutData((Object)layoutData);
    }

    private void createRestoreDefaultsButton(Composite composite) {
        Button restoreDefaults = new Button(composite, 0);
        restoreDefaults.setText("Restore Defaults");
        restoreDefaults.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                STDataViewersExportToCSVDialog.this.restoreDefaults();
            }
        });
        GridData layoutData = new GridData(131072, 4, false, false, 1, 1);
        restoreDefaults.setLayoutData((Object)layoutData);
    }

    private void restoreDefaults() {
        this.outputFile.setText("./export.csv");
        this.separatorText.setText(";");
        this.showHiddenColumnsButton.setSelection(true);
        if (this.exporter.isTreeViewerExporter()) {
            this.expandAllButton.setSelection(true);
            this.childMarkerText.setText("+-");
            this.lastChildMarkerText.setText("+-");
            this.childLinkText.setText("| ");
            this.noChildLinkText.setText("  ");
            this.leafMarkerText.setText("");
            this.nodeMarkerText.setText("");
            this.exportTreePrefixButton.setSelection(true);
            this.enableTreePrefixText(this.exportTreePrefixButton.getSelection());
        }
        this.updatePreview();
    }

    private void setDefaultWidgetsValues() {
        this.outputFile.setText(this.exporter.getFilePath());
        this.showHiddenColumnsButton.setSelection(this.exporter.getShowHiddenColumns());
        this.separatorText.setText(this.inactivateSpecialChars(this.exporter.getCSVSeparator()));
        if (this.exporter.isTreeViewerExporter()) {
            this.expandAllButton.setSelection(this.exporter.getExpandAll());
            this.exportTreePrefixButton.setSelection(this.exporter.getExportTreePrefix());
            this.childLinkText.setText(this.inactivateSpecialChars(this.exporter.getCSVChildLink()));
            this.childMarkerText.setText(this.inactivateSpecialChars(this.exporter.getCSVChildMarker()));
            this.lastChildMarkerText.setText(this.inactivateSpecialChars(this.exporter.getCSVLastChildMarker()));
            this.noChildLinkText.setText(this.inactivateSpecialChars(this.exporter.getCSVNoChildLink()));
            this.leafMarkerText.setText(this.inactivateSpecialChars(this.exporter.getCSVLeafMarker()));
            this.nodeMarkerText.setText(this.inactivateSpecialChars(this.exporter.getCSVNodeMarker()));
            this.enableTreePrefixText(this.exportTreePrefixButton.getSelection());
        }
        this.updatePreview();
    }

    private void updatePreview() {
        if (this.exporter.isTreeViewerExporter()) {
            this.previewText.setText(this.createPreview(this.separatorText.getText(), this.childMarkerText.getText(), this.lastChildMarkerText.getText(), this.nodeMarkerText.getText(), this.leafMarkerText.getText(), this.childLinkText.getText(), this.noChildLinkText.getText(), this.exportTreePrefixButton.getSelection()));
        } else {
            this.previewText.setText(this.createPreview(this.separatorText.getText(), null, null, null, null, null, null, false));
        }
    }

    public String createPreview(String separator, String childMarker, String lastChildMarker, String nodeMarker, String leafMarker, String childLink, String noChildLink, boolean exportTreePrefix) {
        StringBuilder preview = new StringBuilder();
        if (exportTreePrefix) {
            preview.append("Hierarchy").append(separator);
        }
        preview.append("col_1").append(separator).append("col_2\n");
        if (exportTreePrefix) {
            preview.append(childMarker).append(nodeMarker).append(separator);
        }
        preview.append("A1").append(separator).append("B1\n");
        if (exportTreePrefix) {
            preview.append(childLink).append(lastChildMarker).append(leafMarker).append(separator);
        }
        preview.append("A11").append(separator).append("B11\n");
        if (exportTreePrefix) {
            preview.append(lastChildMarker).append(nodeMarker).append(separator);
        }
        preview.append("A2").append(separator).append("B2\n");
        if (exportTreePrefix) {
            preview.append(noChildLink).append(childMarker).append(leafMarker).append(separator);
        }
        preview.append("A21").append(separator).append("B21\n");
        if (exportTreePrefix) {
            preview.append(noChildLink).append(childMarker).append(nodeMarker).append(separator);
        }
        preview.append("A22").append(separator).append("B22\n");
        if (exportTreePrefix) {
            preview.append(noChildLink).append(childLink).append(lastChildMarker).append(leafMarker).append(separator);
        }
        preview.append("A221").append(separator).append("B221\n");
        if (exportTreePrefix) {
            preview.append(noChildLink).append(lastChildMarker).append(leafMarker).append(separator);
        }
        preview.append("A23").append(separator).append("B23");
        return this.activateSpecialChars(preview.toString());
    }

    private void enableTreePrefixText(boolean enabled) {
        this.childLinkText.setEnabled(enabled);
        this.noChildLinkText.setEnabled(enabled);
        this.childMarkerText.setEnabled(enabled);
        this.lastChildMarkerText.setEnabled(enabled);
        this.leafMarkerText.setEnabled(enabled);
        this.nodeMarkerText.setEnabled(enabled);
        this.childLinkLabel.setEnabled(enabled);
        this.noChildLinkLabel.setEnabled(enabled);
        this.childMarkerLabel.setEnabled(enabled);
        this.lastChildMarkerLabel.setEnabled(enabled);
        this.leafMarkerLabel.setEnabled(enabled);
        this.nodeMarkerLabel.setEnabled(enabled);
    }

    protected void okPressed() {
        MessageDialog dialog;
        File f = new File(this.outputFile.getText());
        if (f.exists() && (dialog = new MessageDialog(this.getShell(), "Warning: file already exists", null, "File \"" + f.getAbsolutePath() + "\" already exists.\n" + "Overwrite it anyway?", 4, new String[]{"OK", "Cancel"}, 1)).open() > 0) {
            return;
        }
        if (this.isDirty()) {
            this.saveExporterSettings();
        }
        super.okPressed();
    }

    private String activateSpecialChars(String text) {
        String result = text.replace("\\t", "\t");
        result = result.replace("\\n", "\n");
        return result;
    }

    private String inactivateSpecialChars(String text) {
        String result = text.replace("\t", "\\t");
        result = result.replace("\n", "\\n");
        return result;
    }

    private void saveExporterSettings() {
        this.exporter.setFilePath(this.outputFile.getText());
        this.exporter.setShowHiddenColumns(this.showHiddenColumnsButton.getSelection());
        this.exporter.setCSVSeparator(this.activateSpecialChars(this.separatorText.getText()));
        if (this.exporter.isTreeViewerExporter()) {
            this.exporter.setExpandAll(this.expandAllButton.getSelection());
            this.exporter.setExportTreePrefix(this.exportTreePrefixButton.getSelection());
            this.exporter.setCSVChildLink(this.activateSpecialChars(this.childLinkText.getText()));
            this.exporter.setCSVChildMarker(this.activateSpecialChars(this.childMarkerText.getText()));
            this.exporter.setCSVLastChildMarker(this.activateSpecialChars(this.lastChildMarkerText.getText()));
            this.exporter.setCSVNoChildLink(this.activateSpecialChars(this.noChildLinkText.getText()));
            this.exporter.setCSVLeafMarker(this.activateSpecialChars(this.leafMarkerText.getText()));
            this.exporter.setCSVNodeMarker(this.activateSpecialChars(this.nodeMarkerText.getText()));
        }
    }

    private boolean isDirty() {
        if (this.exporter.isTreeViewerExporter()) {
            return !this.exporter.getFilePath().equals(this.outputFile.getText()) || !this.exporter.getCSVChildLink().equals(this.childLinkText.getText()) || !this.exporter.getCSVChildMarker().equals(this.childMarkerText.getText()) || !this.exporter.getCSVLastChildMarker().equals(this.lastChildMarkerText.getText()) || !this.exporter.getCSVNoChildLink().equals(this.noChildLinkText.getText()) || !this.exporter.getCSVSeparator().equals(this.separatorText.getText()) || !this.exporter.getCSVLeafMarker().equals(this.leafMarkerText.getText()) || !this.exporter.getCSVNodeMarker().equals(this.nodeMarkerText.getText()) || this.exporter.getExpandAll() != this.expandAllButton.getSelection() || this.exporter.getShowHiddenColumns() != this.showHiddenColumnsButton.getSelection() || this.exporter.getExportTreePrefix() != this.exportTreePrefixButton.getSelection() || this.exporter.getExpandAll() != this.expandAllButton.getSelection();
        }
        return !this.exporter.getFilePath().equals(this.outputFile.getText()) || !this.exporter.getCSVSeparator().equals(this.separatorText.getText()) || this.exporter.getShowHiddenColumns() != this.showHiddenColumnsButton.getSelection();
    }

    private void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(772));
    }

    private void handleBrowseWorkspace() {
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        dialog.setTitle("Output file");
        if (dialog.open() == 0) {
            IPath p = dialog.getResult();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(p);
            this.outputFile.setText(file.getLocation().toOSString());
        }
    }

    private void handleBrowse() {
        FileDialog dialog = new FileDialog(this.getShell(), 12288);
        dialog.setText("Select output file");
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        String t = this.outputFile.getText();
        File f = new File(t);
        t = f.getParent();
        dialog.setFilterPath(t);
        String s = dialog.open();
        if (s != null) {
            this.outputFile.setText(s);
        }
    }
}

