/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import java.util.ArrayList;
import org.eclipse.cdt.internal.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.IFlagConfigureValueOption;

public class FlagConfigureOption
extends AbstractConfigurationOption {
    private String value;
    private ArrayList<String> children = new ArrayList();

    public FlagConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
        this.value = "";
    }

    public FlagConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
        this.value = "";
    }

    private FlagConfigureOption(String name, AutotoolsConfiguration cfg, String value, ArrayList<String> children) {
        super(name, cfg);
        this.value = value;
        this.children = (ArrayList)children.clone();
    }

    @Override
    public String getParameter() {
        StringBuffer parm = new StringBuffer(String.valueOf(this.getName()) + "=\"");
        boolean haveParm = false;
        if (this.isParmSet()) {
            String separator = "";
            int i = 0;
            while (i < this.children.size()) {
                String fvname = this.children.get(i);
                IConfigureOption o = this.cfg.getOption(fvname);
                if (o.isParmSet() && o instanceof IFlagConfigureValueOption) {
                    parm.append(String.valueOf(separator) + ((IFlagConfigureValueOption)((Object)o)).getFlags());
                    separator = " ";
                    haveParm = true;
                }
                ++i;
            }
            if (haveParm) {
                parm.append("\"");
                return parm.toString();
            }
        }
        return "";
    }

    @Override
    public String getParameterName() {
        return this.getName();
    }

    @Override
    public boolean isParmSet() {
        int i = 0;
        while (i < this.children.size()) {
            String s = this.children.get(i);
            IConfigureOption o = this.cfg.getOption(s);
            if (o.isParmSet()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public IConfigureOption copy(AutotoolsConfiguration config) {
        FlagConfigureOption f = new FlagConfigureOption(this.name, config, this.value, this.children);
        return f;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean isFlag() {
        return true;
    }

    public void addChild(String name) {
        this.children.add(name);
    }

    public ArrayList<String> getChildren() {
        return this.children;
    }
}

