/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.commands;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.commands.ExportToTextRequest;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;

public class ExportToTextJob
extends Job {
    private static final int TOTAL_WORK = 100;
    private static final int SLEEPING_INTERVAL = 100;
    public static final Object ExportToCSVJobFamily = new Object();
    private final ITmfTrace fTrace;
    private final ITmfFilter fFilter;
    private final TmfEventsTable fTable;
    private final String fHeader;
    private final String destination;

    public ExportToTextJob(ITmfTrace trace, ITmfFilter filter, TmfEventsTable table, String header, String destination) {
        super(MessageFormat.format(Messages.ExportToTextJob_Export_to, destination));
        this.fTrace = trace;
        this.fFilter = filter;
        this.fTable = table;
        this.fHeader = header;
        this.destination = destination;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.ExportToTextJob_Export_trace_to) + this.destination, 100);
        IStatus ret = this.saveImpl(monitor);
        monitor.done();
        return ret;
    }

    private IStatus saveImpl(IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.destination));){
                if (this.fHeader != null) {
                    bw.write(this.fHeader);
                    bw.append('\n');
                }
                return this.saveImpl(bw, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            Status status = new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(Messages.ExportToTextJob_Unable_to_export_trace, this.destination), (Throwable)ex);
            return status;
        }
    }

    private IStatus saveImpl(Writer bw, IProgressMonitor monitor) {
        ExportToTextRequest request = new ExportToTextRequest(bw, this.fFilter, this.fTable);
        this.fTrace.sendRequest((ITmfEventRequest)request);
        int currentIndex = 0;
        while (!request.isCompleted()) {
            if (monitor.isCanceled()) {
                request.cancel();
                return Status.CANCEL_STATUS;
            }
            int index = (int)((long)(request.getNbRead() * 100) / this.fTrace.getNbEvents());
            if (index > currentIndex) {
                int progress = index - currentIndex;
                monitor.worked(progress);
                currentIndex = index;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (request.isFailed()) {
            Status status = new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(Messages.ExportToTextJob_Unable_to_export_trace, this.destination), (Throwable)request.getIOException());
            return status;
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return ExportToCSVJobFamily.equals(family);
    }
}

