/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.commands;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;

public class ExportToTextRequest
extends TmfEventRequest {
    private final Writer fWriter;
    private final ITmfFilter fFilter;
    private final TmfEventsTable fTable;
    private IOException fIOException;

    public ExportToTextRequest(Writer w, ITmfFilter filter, TmfEventsTable table) {
        super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
        this.fWriter = w;
        this.fFilter = filter;
        this.fTable = table;
    }

    public IOException getIOException() {
        return this.fIOException;
    }

    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (this.isCancelled()) {
            return;
        }
        try {
            if (this.fFilter == null || this.fFilter.matches(event)) {
                if (this.fTable != null) {
                    String[] entries = this.fTable.getItemStrings(event);
                    boolean needTab = false;
                    String[] stringArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        if (needTab) {
                            this.fWriter.write(9);
                        }
                        this.printValue(entry);
                        needTab = true;
                        ++n2;
                    }
                } else {
                    this.fWriter.write(event.getTimestamp().toString());
                    this.fWriter.write(9);
                    this.fWriter.write(event.getSource());
                    this.fWriter.write(9);
                    this.fWriter.write(event.getType().getName());
                    this.fWriter.write(9);
                    this.fWriter.write(event.getReference());
                    this.fWriter.write(9);
                    ITmfEventField content = event.getContent();
                    this.printValue(content.getValue());
                }
                this.fWriter.write(10);
            }
        }
        catch (IOException ex) {
            this.fIOException = ex;
            this.fail();
        }
    }

    private void printValue(Object value) throws IOException {
        if (value != null) {
            this.fWriter.write(value.toString());
        }
    }
}

