/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.commands.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.commands.TmfHandlerUtil;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ISelection menuSelection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell);
        fd.setText(Messages.OpenFileHandler_SelectTraceFile);
        String filePath = fd.open();
        if (filePath == null) {
            return null;
        }
        try {
            TmfTraceFolder destinationFolder;
            if (menuSelection != null && currentSelection instanceof IStructuredSelection) {
                destinationFolder = TmfHandlerUtil.getTraceFolderFromSelection(currentSelection);
            } else {
                IProject project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
                TmfProjectElement projectElement = TmfProjectRegistry.getProject(project, true);
                destinationFolder = projectElement.getTracesFolder();
            }
            TmfOpenTraceHelper.openTraceFromPath(destinationFolder, filePath, shell);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return null;
    }
}

