/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.dialogs;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultiLineInputDialog
extends InputDialog {
    private final String dialogMessage;
    private boolean submitOnCR = true;

    public MultiLineInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, null, initialValue, validator);
        this.dialogMessage = dialogMessage;
    }

    public MultiLineInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        super(parentShell, dialogTitle, null, initialValue, (IInputValidator)new NotEmptyValidator());
        this.dialogMessage = dialogMessage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        final Text text = this.getText();
        if (this.dialogMessage != null) {
            Label label = new Label(composite, 64);
            label.setText(this.dialogMessage);
            GridData data = new GridData(772);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            label.moveAbove((Control)text);
        }
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(250);
        gridData.heightHint = this.convertHeightInCharsToPixels(3);
        text.setLayoutData((Object)gridData);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    if (MultiLineInputDialog.this.submitOnCR) {
                        e.doit = false;
                        MultiLineInputDialog.this.okPressed();
                        return;
                    }
                } else if (e.character == '\t') {
                    e.doit = false;
                    text.traverse(16);
                }
                MultiLineInputDialog.this.submitOnCR = false;
            }
        });
        text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MultiLineInputDialog.this.submitOnCR = false;
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Point clientArea = control.computeSize(-1, -1);
        Rectangle trim = this.getShell().computeTrim(0, 0, clientArea.x, clientArea.y);
        this.getShell().setMinimumSize(trim.width, trim.height);
        return control;
    }

    protected int getInputTextStyle() {
        return 2626;
    }

    protected boolean isResizable() {
        return true;
    }

    private static class NotEmptyValidator
    implements IInputValidator {
        private NotEmptyValidator() {
        }

        public String isValid(String newText) {
            return newText == null || newText.trim().length() == 0 ? " " : null;
        }
    }
}

