/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SelectElementTypeContributionItem
extends CompoundContributionItem {
    private static final ImageDescriptor SELECTED_ICON = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/bullet.gif");
    private static final String BUNDLE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.bundle";
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";
    private static final String ICON_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.icon";
    private static final String SELECT_TRACE_TYPE_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.select_trace_type";
    private static final String CUSTOM_TXT_CATEGORY = "Custom Text";
    private static final String CUSTOM_XML_CATEGORY = "Custom XML";
    private static final String DEFAULT_TRACE_ICON_PATH = "icons/elcl16/trace.gif";

    protected IContributionItem[] getContributionItems() {
        HashSet<String> selectedTraceTypes = new HashSet<String>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        boolean forTraces = false;
        boolean forExperiments = false;
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)element;
                    selectedTraceTypes.add(trace.getTraceType());
                    forTraces = true;
                    continue;
                }
                if (!(element instanceof TmfExperimentElement)) continue;
                TmfExperimentElement exp = (TmfExperimentElement)element;
                selectedTraceTypes.add(exp.getTraceType());
                forExperiments = true;
            }
        }
        if (forTraces && forExperiments) {
            throw new RuntimeException("You must select only experiments or only traces to set the element type");
        }
        return this.getContributionItems(selectedTraceTypes, forExperiments);
    }

    protected IContributionItem[] getContributionItems(Set<String> selectedTraceTypes, boolean forExperiments) {
        MenuManager subMenu;
        String label;
        String traceIcon;
        String traceBundle;
        CustomXmlTraceDefinition[] customXmlTraceDefinitions;
        IConfigurationElement ce;
        IConfigurationElement[] config;
        String ceType = forExperiments ? "experiment" : "type";
        TmfTraceType.TraceElementType elementType = forExperiments ? TmfTraceType.TraceElementType.EXPERIMENT : TmfTraceType.TraceElementType.TRACE;
        LinkedList<IContributionItem> list = new LinkedList<IContributionItem>();
        HashMap<String, MenuManager> categoriesMap = new HashMap<String, MenuManager>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.core.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("category")) {
                String categoryId = ce.getAttribute("id");
                ImageDescriptor icon = SelectElementTypeContributionItem.isSelectedCategory(categoryId, config, selectedTraceTypes) ? SELECTED_ICON : null;
                MenuManager subMenu2 = new MenuManager(ce.getAttribute("name"), icon, null);
                categoriesMap.put(categoryId, subMenu2);
                list.add((IContributionItem)subMenu2);
            }
            ++n2;
        }
        iConfigurationElementArray = config;
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            if (ce.getName().equals(ceType)) {
                String traceBundle2 = ce.getContributor().getName();
                String traceTypeId = ce.getAttribute("id");
                String label2 = ce.getAttribute("name").replaceAll("&", "&&");
                boolean selected = selectedTraceTypes.contains(traceTypeId);
                MenuManager subMenu3 = (MenuManager)categoriesMap.get(ce.getAttribute("category"));
                String traceIcon2 = null;
                IConfigurationElement uiCE = TmfTraceTypeUIUtils.getTraceUIAttributes(traceTypeId, elementType);
                if (uiCE != null) {
                    traceIcon2 = uiCE.getAttribute("icon");
                }
                SelectElementTypeContributionItem.addContributionItem(list, traceBundle2, traceTypeId, traceIcon2, label2, selected, subMenu3);
            }
            ++n2;
        }
        if (forExperiments) {
            return list.toArray(new IContributionItem[list.size()]);
        }
        CustomTxtTraceDefinition[] customTxtTraceDefinitions = CustomTxtTraceDefinition.loadAll();
        if (customTxtTraceDefinitions.length > 0) {
            ImageDescriptor icon = SelectElementTypeContributionItem.isSelectedCategory(customTxtTraceDefinitions, selectedTraceTypes) ? SELECTED_ICON : null;
            MenuManager subMenu4 = new MenuManager(CUSTOM_TXT_CATEGORY, icon, null);
            categoriesMap.put(CUSTOM_TXT_CATEGORY, subMenu4);
            list.add((IContributionItem)subMenu4);
        }
        if ((customXmlTraceDefinitions = CustomXmlTraceDefinition.loadAll()).length > 0) {
            ImageDescriptor icon = SelectElementTypeContributionItem.isSelectedCategory(customXmlTraceDefinitions, selectedTraceTypes) ? SELECTED_ICON : null;
            MenuManager subMenu5 = new MenuManager(CUSTOM_XML_CATEGORY, icon, null);
            categoriesMap.put(CUSTOM_XML_CATEGORY, subMenu5);
            list.add((IContributionItem)subMenu5);
        }
        CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = customTxtTraceDefinitions;
        int n3 = customTxtTraceDefinitions.length;
        int n4 = 0;
        while (n4 < n3) {
            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n4];
            traceBundle = Activator.getDefault().getBundle().getSymbolicName();
            String traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ':' + def.definitionName;
            traceIcon = DEFAULT_TRACE_ICON_PATH;
            label = def.definitionName;
            boolean selected = selectedTraceTypes.contains(traceTypeId);
            subMenu = (MenuManager)categoriesMap.get(CUSTOM_TXT_CATEGORY);
            SelectElementTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            ++n4;
        }
        customTxtTraceDefinitionArray = customXmlTraceDefinitions;
        n3 = customXmlTraceDefinitions.length;
        n4 = 0;
        while (n4 < n3) {
            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n4];
            traceBundle = Activator.getDefault().getBundle().getSymbolicName();
            String traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ':' + def.definitionName;
            traceIcon = DEFAULT_TRACE_ICON_PATH;
            label = def.definitionName;
            boolean selected = selectedTraceTypes.contains(traceTypeId);
            subMenu = (MenuManager)categoriesMap.get(CUSTOM_XML_CATEGORY);
            SelectElementTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            ++n4;
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private static void addContributionItem(List<IContributionItem> list, String traceBundle, String traceTypeId, String traceIcon, String label, boolean selected, MenuManager subMenu) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(BUNDLE_PARAMETER, traceBundle);
        params.put(TYPE_PARAMETER, traceTypeId);
        params.put(ICON_PARAMETER, traceIcon);
        ImageDescriptor icon = null;
        if (selected) {
            icon = SELECTED_ICON;
        }
        CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "my.parameterid", SELECT_TRACE_TYPE_COMMAND_ID, 8);
        param.parameters = params;
        param.icon = icon;
        param.disabledIcon = icon;
        param.hoverIcon = icon;
        param.label = label;
        param.visibleEnabled = true;
        if (subMenu != null) {
            subMenu.add((IContributionItem)new CommandContributionItem(param));
        } else {
            list.add((IContributionItem)new CommandContributionItem(param));
        }
    }

    private static boolean isSelectedCategory(String categoryId, IConfigurationElement[] config, Set<String> selectedTraceTypes) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String traceTypeId;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("type") && selectedTraceTypes.contains(traceTypeId = ce.getAttribute("id")) && categoryId.equals(ce.getAttribute("category"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSelectedCategory(CustomTxtTraceDefinition[] customTxtTraceDefinitions, Set<String> selectedTraceTypes) {
        CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = customTxtTraceDefinitions;
        int n = customTxtTraceDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
            String traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ':' + def.definitionName;
            if (selectedTraceTypes.contains(traceTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSelectedCategory(CustomXmlTraceDefinition[] customXmlTraceDefinitions, Set<String> selectedTraceTypes) {
        CustomXmlTraceDefinition[] customXmlTraceDefinitionArray = customXmlTraceDefinitions;
        int n = customXmlTraceDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            CustomXmlTraceDefinition def = customXmlTraceDefinitionArray[n2];
            String traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ':' + def.definitionName;
            if (selectedTraceTypes.contains(traceTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

