/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SynchronizeTracesHandler
extends AbstractHandler {
    private TreeSelection fSelection = null;
    private static final String CR = System.getProperty("line.separator");

    public boolean isEnabled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return Boolean.FALSE;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return Boolean.FALSE;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        final ArrayList<TmfTraceElement> tl = new ArrayList<TmfTraceElement>();
        final ArrayList<TmfExperimentElement> uiexperiment = new ArrayList<TmfExperimentElement>();
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfTraceElement) {
                    tl.add((TmfTraceElement)element);
                    continue;
                }
                if (!(element instanceof TmfExperimentElement)) continue;
                TmfExperimentElement exp = (TmfExperimentElement)element;
                uiexperiment.add(exp);
                for (TmfTraceElement trace : exp.getTraces()) {
                    tl.add(trace);
                }
            }
        }
        if (uiexperiment.size() != 1 || tl.size() < 2) {
            TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, Messages.SynchronizeTracesHandler_WrongTraceNumber);
            return null;
        }
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                traces = new ITmfTrace[tl.size()];
                exp = (TmfExperimentElement)uiexperiment.get(0);
                i = 0;
                while (i < tl.size()) {
                    block8: {
                        trace = ((TmfTraceElement)tl.get(i)).instantiateTrace();
                        traceEvent = ((TmfTraceElement)tl.get(i)).instantiateEvent();
                        if (trace == null) {
                            TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_WrongType) + ((TmfTraceElement)tl.get(i)).getName());
                            j = 0;
                            while (j < i) {
                                traces[j].dispose();
                                ++j;
                            }
                            return;
                        }
                        try {
                            trace.initTrace(((TmfTraceElement)tl.get(i)).getResource(), ((TmfTraceElement)tl.get(i)).getLocation().getPath(), traceEvent.getClass());
                            TmfTraceManager.refreshSupplementaryFiles((ITmfTrace)trace);
                            break block8;
                        }
                        catch (TmfTraceException e) {
                            TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_InitError) + SynchronizeTracesHandler.access$0() + SynchronizeTracesHandler.access$0() + (Object)e);
                            trace.dispose();
                            j = 0;
                            ** while (j < i)
                        }
lbl-1000:
                        // 1 sources

                        {
                            traces[j].dispose();
                            ++j;
                            continue;
                        }
lbl27:
                        // 1 sources

                        return;
                    }
                    traces[i] = trace;
                    ++i;
                }
                exp.refreshSupplementaryFolder();
                experiment = new TmfExperiment(ITmfEvent.class, exp.getName(), traces, (IResource)exp.getResource());
                try {
                    syncAlgo = experiment.synchronizeTraces(true);
                    TmfTraceManager.refreshSupplementaryFiles((ITmfTrace)experiment);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IResource resource;
                            ArrayList<TmfTraceElement> tracesToAdd = new ArrayList<TmfTraceElement>();
                            ArrayList<TmfTraceElement> tracesToRemove = new ArrayList<TmfTraceElement>();
                            for (TmfTraceElement traceel : tl) {
                                boolean traceexists;
                                ITmfTrace expTrace = null;
                                ITmfTrace[] iTmfTraceArray = experiment.getTraces();
                                int n = iTmfTraceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ITmfTrace t = iTmfTraceArray[n2];
                                    if (t.getResource().equals((Object)traceel.getResource())) {
                                        expTrace = t;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (expTrace == null || !syncAlgo.isTraceSynced(expTrace.getHostId())) continue;
                                TmfTraceElement origtrace = traceel.getElementUnderTraceFolder();
                                String newname = traceel.getName();
                                IContainer parentFolder = origtrace.getResource().getParent();
                                do {
                                    traceexists = false;
                                    if (parentFolder.findMember(newname = String.valueOf(newname) + "_") == null) continue;
                                    traceexists = true;
                                } while (traceexists);
                                TmfTraceElement newtrace = origtrace.copy(newname);
                                if (newtrace == null) {
                                    TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + CR + CR + String.format(Messages.SynchronizeTracesHandler_CopyProblem, origtrace.getName()));
                                    continue;
                                }
                                ITmfTrace trace = newtrace.instantiateTrace();
                                ITmfEvent traceEvent = newtrace.instantiateEvent();
                                try {
                                    trace.initTrace(newtrace.getResource(), newtrace.getLocation().getPath(), traceEvent.getClass());
                                }
                                catch (TmfTraceException e) {
                                    Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingForTrace, exp.getName(), traceel.getName()), e);
                                    TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + CR + CR + e.getMessage());
                                }
                                trace.setTimestampTransform(syncAlgo.getTimestampTransform(trace));
                                TmfTraceManager.refreshSupplementaryFiles((ITmfTrace)trace);
                                trace.dispose();
                                tracesToAdd.add(newtrace);
                                tracesToRemove.add(traceel);
                            }
                            experiment.dispose();
                            IFolder tmpFolder = exp.getTraceSupplementaryFolder(".");
                            IResource syncFile = null;
                            IResource[] iResourceArray = exp.getSupplementaryResources();
                            int newname = iResourceArray.length;
                            int origtrace = 0;
                            while (origtrace < newname) {
                                resource = iResourceArray[origtrace];
                                if (resource.getName().equals("synchronization.bin")) {
                                    try {
                                        resource.move(tmpFolder.getFile(String.valueOf(exp.getName()) + '.' + "synchronization.bin").getFullPath(), false, null);
                                        syncFile = resource;
                                        break;
                                    }
                                    catch (CoreException e) {
                                        Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingExperiment, exp.getName()), e);
                                    }
                                }
                                ++origtrace;
                            }
                            for (TmfTraceElement trace : tracesToRemove) {
                                try {
                                    exp.removeTrace(trace);
                                }
                                catch (CoreException e) {
                                    Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingForTrace, exp.getName(), trace.getName()), e);
                                    TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + CR + CR + e.getMessage());
                                }
                            }
                            for (TmfTraceElement trace : tracesToAdd) {
                                exp.addTrace(trace);
                            }
                            resource = tmpFolder.getFile(String.valueOf(exp.getName()) + '.' + "synchronization.bin");
                            if (resource.exists() && syncFile != null) {
                                try {
                                    resource.move(syncFile.getFullPath(), false, null);
                                }
                                catch (CoreException e) {
                                    Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingExperiment, exp.getName()), e);
                                }
                            }
                        }
                    });
                }
                catch (TmfTraceException e) {
                    Activator.getDefault().logError(String.format(Messages.SynchronizeTracesHandler_ErrorSynchingExperiment, new Object[]{exp.getName()}), e);
                    TraceUtils.displayErrorMsg(Messages.SynchronizeTracesHandler_Title, String.valueOf(Messages.SynchronizeTracesHandler_Error) + SynchronizeTracesHandler.access$0() + SynchronizeTracesHandler.access$0() + e.getMessage());
                }
            }
        };
        thread.start();
        return null;
    }
}

