/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.OpenAction;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class TmfActionProvider
extends CommonActionProvider {
    private OpenAction openAction;
    private IWorkbenchPage page;

    public void init(ICommonActionExtensionSite aSite) {
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            this.page = workbenchSite.getPage();
            this.openAction = new OpenAction(this.page, workbenchSite.getSelectionProvider());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        TmfTraceElement traceElement;
        IStructuredSelection structuredSelection;
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof TmfTraceElement && (traceElement = (TmfTraceElement)structuredSelection.getFirstElement()).getResource() instanceof IFile) {
            MenuManager openWithMenu = new MenuManager(Messages.TmfActionProvider_OpenWith);
            openWithMenu.add((IContributionItem)new OpenWithMenu(this.page, (IAdaptable)traceElement.getResource()));
            menu.insertAfter("group.openWith", (IContributionItem)openWithMenu);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }
}

