/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;

public abstract class AbstractTracePackageOperation {
    private IStatus fStatus;
    private TracePackageElement[] fResultElements;
    private final String fFileName;

    public AbstractTracePackageOperation(String fileName) {
        this.fFileName = fileName;
    }

    public abstract void run(IProgressMonitor var1);

    public IStatus getStatus() {
        return this.fStatus;
    }

    public TracePackageElement[] getResultElements() {
        return this.fResultElements;
    }

    public void setResultElements(TracePackageElement[] elements) {
        this.fResultElements = elements;
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected String getFileName() {
        return this.fFileName;
    }

    public ArchiveFile getSpecifiedArchiveFile() {
        if (this.fFileName.length() == 0) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(this.fFileName);
            return new ZipArchiveFile(zipFile);
        }
        catch (ZipException zipFile) {
        }
        catch (IOException zipFile) {
            // empty catch block
        }
        try {
            TarFile tarFile = new TarFile(this.fFileName);
            return new TarArchiveFile(tarFile);
        }
        catch (TarException tarException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected int getNbCheckedElements(TracePackageElement[] elements) {
        int totalWork = 0;
        TracePackageElement[] tracePackageElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement tracePackageElement = tracePackageElementArray[n2];
            TracePackageElement[] children = tracePackageElement.getChildren();
            if (children != null && children.length > 0) {
                totalWork += this.getNbCheckedElements(children);
            } else if (tracePackageElement.isChecked()) {
                ++totalWork;
            }
            ++n2;
        }
        return totalWork;
    }

    public static boolean isFilesChecked(TracePackageElement tracePackageElement) {
        TracePackageElement[] tracePackageElementArray = tracePackageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageFilesElement) {
                return element.isChecked();
            }
            ++n2;
        }
        return false;
    }

    protected static interface ArchiveEntry {
        public String getName();
    }

    protected static interface ArchiveFile {
        public Enumeration<? extends ArchiveEntry> entries();

        public void close() throws IOException;

        public InputStream getInputStream(ArchiveEntry var1) throws TarException, IOException;
    }

    protected class TarArchiveEntry
    implements ArchiveEntry {
        private TarEntry fTarEntry;

        public TarArchiveEntry(TarEntry tarEntry) {
            this.fTarEntry = tarEntry;
        }

        @Override
        public String getName() {
            return this.fTarEntry.getName();
        }

        public TarEntry getTarEntry() {
            return this.fTarEntry;
        }

        public String toString() {
            return this.getName();
        }
    }

    protected class TarArchiveFile
    implements ArchiveFile {
        private TarFile fTarFile;

        public TarArchiveFile(TarFile tarFile) {
            this.fTarFile = tarFile;
        }

        @Override
        public Enumeration<? extends ArchiveEntry> entries() {
            Vector<TarArchiveEntry> v = new Vector<TarArchiveEntry>();
            Enumeration e = this.fTarFile.entries();
            while (e.hasMoreElements()) {
                v.add(new TarArchiveEntry((TarEntry)e.nextElement()));
            }
            return v.elements();
        }

        @Override
        public void close() throws IOException {
            this.fTarFile.close();
        }

        @Override
        public InputStream getInputStream(ArchiveEntry entry) throws TarException, IOException {
            return this.fTarFile.getInputStream(((TarArchiveEntry)entry).getTarEntry());
        }
    }

    protected class ZipAchiveEntry
    implements ArchiveEntry {
        private ZipEntry fZipEntry;

        public ZipAchiveEntry(ZipEntry zipEntry) {
            this.fZipEntry = zipEntry;
        }

        @Override
        public String getName() {
            return this.fZipEntry.getName();
        }

        public ZipEntry getZipEntry() {
            return this.fZipEntry;
        }

        public String toString() {
            return this.getName();
        }
    }

    protected class ZipArchiveFile
    implements ArchiveFile {
        private ZipFile fZipFile;

        public ZipArchiveFile(ZipFile zipFile) {
            this.fZipFile = zipFile;
        }

        @Override
        public Enumeration<? extends ArchiveEntry> entries() {
            Vector<ZipAchiveEntry> v = new Vector<ZipAchiveEntry>();
            Enumeration<? extends ZipEntry> e = this.fZipFile.entries();
            while (e.hasMoreElements()) {
                v.add(new ZipAchiveEntry(e.nextElement()));
            }
            return v.elements();
        }

        @Override
        public void close() throws IOException {
            this.fZipFile.close();
        }

        @Override
        public InputStream getInputStream(ArchiveEntry entry) throws TarException, IOException {
            return this.fZipFile.getInputStream(((ZipAchiveEntry)entry).getZipEntry());
        }
    }
}

