/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg;

import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorLabelProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.graphics.Image;

public class TracePackageTraceElement
extends TracePackageElement {
    private final TmfTraceElement fTraceElement;
    private final String fImportName;
    private final String fTraceType;

    public TracePackageTraceElement(TracePackageElement parent, TmfTraceElement traceElement) {
        super(parent);
        this.fTraceElement = traceElement;
        this.fImportName = null;
        this.fTraceType = null;
    }

    public TracePackageTraceElement(TracePackageElement parent, String importName, String traceType) {
        super(parent);
        this.fImportName = importName;
        this.fTraceElement = null;
        this.fTraceType = traceType;
    }

    @Override
    public String getText() {
        return this.fTraceElement != null ? this.fTraceElement.getElementPath() : this.getDestinationElementPath();
    }

    public String getDestinationElementPath() {
        String traceName = this.getImportName();
        TracePackageElement[] tracePackageElementArray = this.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageFilesElement) {
                TracePackageFilesElement tracePackageFilesElement = (TracePackageFilesElement)element;
                Path filePath = new Path(tracePackageFilesElement.getFileName());
                return filePath.removeLastSegments(1).append(traceName).toString();
            }
            ++n2;
        }
        return traceName;
    }

    public TmfTraceElement getTraceElement() {
        return this.fTraceElement;
    }

    public String getImportName() {
        return this.fImportName;
    }

    public String getTraceType() {
        return this.fTraceType;
    }

    @Override
    public Image getImage() {
        TmfNavigatorLabelProvider tmfNavigatorLabelProvider = new TmfNavigatorLabelProvider();
        return tmfNavigatorLabelProvider.getImage(this.fTraceElement);
    }
}

