/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class TmfProjectModelElement
implements ITmfProjectModelElement {
    private final String fName;
    protected final IResource fResource;
    protected final URI fLocation;
    protected final IPath fPath;
    private final ITmfProjectModelElement fParent;
    protected final List<ITmfProjectModelElement> fChildren;

    protected TmfProjectModelElement(String name, IResource resource, ITmfProjectModelElement parent) {
        this.fName = name;
        this.fResource = resource;
        this.fPath = resource.getFullPath();
        this.fLocation = new File(resource.getLocationURI()).toURI();
        this.fParent = parent;
        this.fChildren = new CopyOnWriteArrayList<ITmfProjectModelElement>();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public URI getLocation() {
        return this.fLocation;
    }

    @Override
    public TmfProjectElement getProject() {
        return this.fParent.getProject();
    }

    @Override
    public ITmfProjectModelElement getParent() {
        return this.fParent;
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    @Override
    public List<ITmfProjectModelElement> getChildren() {
        return this.fChildren;
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        this.fChildren.add(child);
    }

    @Override
    public void removeChild(ITmfProjectModelElement child) {
        this.fChildren.remove(child);
    }

    @Override
    public void refresh() {
        this.refreshChildren();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow wbWindow = wb.getActiveWorkbenchWindow();
                if (wbWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = wbWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    IViewPart viewPart = viewReference.getView(false);
                    if (viewPart instanceof CommonNavigator) {
                        CommonViewer commonViewer = ((CommonNavigator)viewPart).getCommonViewer();
                        TmfProjectModelElement element = TmfProjectModelElement.this;
                        if (element instanceof TmfProjectElement) {
                            element = TmfProjectModelElement.this.getResource();
                        }
                        commonViewer.refresh((Object)element);
                    }
                    ++n2;
                }
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fPath == null ? 0 : this.fPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TmfProjectModelElement)) {
            return false;
        }
        TmfProjectModelElement element = (TmfProjectModelElement)other;
        return element.fPath.equals((Object)this.fPath);
    }

    void refreshChildren() {
    }

    public IFolder getTraceSupplementaryFolder(String supplFolderPath) {
        TmfProjectElement project = this.getProject();
        IProject projectResource = project.getResource();
        IFolder supplFolderParent = projectResource.getFolder(".tracing");
        IFolder folder = supplFolderParent.getFolder(supplFolderPath);
        return folder;
    }

    public IFolder prepareTraceSupplementaryFolder(String supplFolderPath, boolean createFolder) {
        IFolder folder = this.getTraceSupplementaryFolder(supplFolderPath);
        try {
            if (createFolder) {
                TraceUtils.createFolder(folder, (IProgressMonitor)new NullProgressMonitor());
            } else {
                TraceUtils.createFolder((IFolder)folder.getParent(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating supplementary folder " + folder.getFullPath(), e);
        }
        return folder;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '(' + this.getPath() + ')';
    }
}

