/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfTraceFolder
extends TmfProjectModelElement
implements IPropertySource2 {
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final ReadOnlyTextPropertyDescriptor sfNameDescriptor = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor sfPathDescriptor = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor sfLocationDescriptor = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor};

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
    }

    public TmfTraceFolder(String name, IFolder resource, TmfProjectElement parent) {
        super(name, (IResource)resource, parent);
        parent.addChild(this);
    }

    public TmfTraceFolder(String name, IFolder resource, TmfTraceFolder parent) {
        super(name, (IResource)resource, parent);
        parent.addChild(this);
    }

    public IFolder getResource() {
        return (IFolder)this.fResource;
    }

    @Override
    void refreshChildren() {
        IFolder folder = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : this.getChildren()) {
            childrenMap.put(element.getResource().getName(), element);
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String name = resource.getName();
                boolean isFolder = resource instanceof IFolder && resource.getPersistentProperty(TmfCommonConstants.TRACETYPE) == null;
                ITmfProjectModelElement element = (ITmfProjectModelElement)childrenMap.get(name);
                if (isFolder && !(element instanceof TmfTraceFolder) && !(element instanceof TmfTraceElement)) {
                    element = TmfTraceType.isDirectoryTrace((String)resource.getLocationURI().getPath()) ? new TmfTraceElement(name, resource, this) : new TmfTraceFolder(name, (IFolder)resource, this);
                } else if (!isFolder && !(element instanceof TmfTraceElement)) {
                    element = new TmfTraceElement(name, resource, this);
                } else {
                    childrenMap.remove(name);
                }
                ((TmfProjectModelElement)element).refreshChildren();
                ++n2;
            }
        }
        catch (CoreException members) {
            // empty catch block
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    public List<TmfTraceElement> getTraces() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        for (ITmfProjectModelElement child : children) {
            if (child instanceof TmfTraceElement) {
                traces.add((TmfTraceElement)child);
                continue;
            }
            if (!(child instanceof TmfTraceFolder)) continue;
            traces.addAll(((TmfTraceFolder)child).getTraces());
        }
        return traces;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

