/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceFolderContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceFolderLabelProvider;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SelectTracesWizardPage
extends WizardPage {
    private final TmfProjectElement fProject;
    private final TmfExperimentElement fExperiment;
    private Map<String, TmfTraceElement> fPreviousTraces;
    private CheckboxTableViewer fCheckboxTableViewer;

    protected SelectTracesWizardPage(TmfProjectElement project, TmfExperimentElement experiment) {
        super("");
        this.setTitle(Messages.SelectTracesWizardPage_WindowTitle);
        this.setDescription(Messages.SelectTracesWizardPage_Description);
        this.fProject = project;
        this.fExperiment = experiment;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        this.setControl((Control)container);
        this.fCheckboxTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.fCheckboxTableViewer.setContentProvider((IContentProvider)new TraceFolderContentProvider());
        this.fCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new TraceFolderLabelProvider());
        this.fCheckboxTableViewer.setSorter(new ViewerSorter());
        Table table = this.fCheckboxTableViewer.getTable();
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        table.setLayoutData((Object)formData);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(200);
        tableColumn.setText(Messages.SelectTracesWizardPage_TraceColumnHeader);
        this.fPreviousTraces = new HashMap<String, TmfTraceElement>();
        for (ITmfProjectModelElement child : this.fExperiment.getChildren()) {
            if (!(child instanceof TmfTraceElement)) continue;
            TmfTraceElement trace = (TmfTraceElement)child;
            String name = trace.getElementPath();
            this.fPreviousTraces.put(name, trace);
        }
        Set<String> keys = this.fPreviousTraces.keySet();
        TmfTraceFolder traceFolder = this.fProject.getTracesFolder();
        this.fCheckboxTableViewer.setInput((Object)traceFolder);
        int index = 0;
        Object element = this.fCheckboxTableViewer.getElementAt(index++);
        while (element != null) {
            TmfTraceElement trace;
            if (element instanceof TmfTraceElement && keys.contains((trace = (TmfTraceElement)element).getElementPath())) {
                this.fCheckboxTableViewer.setChecked(element, true);
            }
            element = this.fCheckboxTableViewer.getElementAt(index++);
        }
    }

    public boolean performFinish() {
        TmfTraceElement[] traces;
        IFolder experiment = this.fExperiment.getResource();
        boolean changed = false;
        Set<String> keys = this.fPreviousTraces.keySet();
        TmfTraceElement[] tmfTraceElementArray = traces = this.getSelection();
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTraceElement trace = tmfTraceElementArray[n2];
            String name = trace.getElementPath();
            if (keys.contains(name)) {
                this.fPreviousTraces.remove(name);
            } else {
                this.fExperiment.addTrace(trace);
                changed = true;
            }
            ++n2;
        }
        keys = this.fPreviousTraces.keySet();
        for (String key : keys) {
            try {
                this.fExperiment.removeTrace(this.fPreviousTraces.get(key));
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error selecting traces for experiment " + experiment.getName(), e);
            }
            changed = true;
        }
        if (changed) {
            this.fExperiment.closeEditors();
            this.fExperiment.deleteSupplementaryResources();
        }
        return true;
    }

    private TmfTraceElement[] getSelection() {
        Object[] selection;
        Vector<TmfTraceElement> traces = new Vector<TmfTraceElement>();
        Object[] objectArray = selection = this.fCheckboxTableViewer.getCheckedElements();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (sel instanceof TmfTraceElement) {
                traces.add((TmfTraceElement)sel);
            }
            ++n2;
        }
        TmfTraceElement[] result = new TmfTraceElement[traces.size()];
        traces.toArray(result);
        return result;
    }
}

