/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.statistics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfStatisticsValues;

public class TmfStatisticsTreeNode {
    private final TmfStatisticsTree fTree;
    private final String[] fPath;
    private final TmfStatisticsTreeNode fParent;
    private final Map<String, TmfStatisticsTreeNode> fChildren;
    private final TmfStatisticsValues fValues;
    private final TmfStatisticsTreeNode fTopNode;

    public TmfStatisticsTreeNode(TmfStatisticsTree tree, TmfStatisticsTreeNode parent, String ... path) {
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            if (elem == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        this.fTree = tree;
        this.fPath = path;
        this.fParent = parent;
        this.fChildren = new ConcurrentHashMap<String, TmfStatisticsTreeNode>();
        this.fValues = new TmfStatisticsValues();
        TmfStatisticsTreeNode topNode = this;
        while (topNode.getParent() != null && topNode.getParent().getParent() != null) {
            topNode = topNode.getParent();
        }
        this.fTopNode = topNode;
    }

    public String getName() {
        if (this.fPath.length == 0) {
            return "root";
        }
        return this.fPath[this.fPath.length - 1];
    }

    public boolean containsChild(String childName) {
        return this.fChildren.containsKey(childName);
    }

    public TmfStatisticsTreeNode getChild(String childName) {
        return this.fChildren.get(childName);
    }

    public Collection<TmfStatisticsTreeNode> getChildren() {
        return this.fChildren.values();
    }

    public TmfStatisticsTreeNode addChild(String childName) {
        String[] childPath = new String[this.fPath.length + 1];
        System.arraycopy(this.fPath, 0, childPath, 0, this.fPath.length);
        childPath[this.fPath.length] = childName;
        TmfStatisticsTreeNode child = new TmfStatisticsTreeNode(this.fTree, this, childPath);
        this.fChildren.put(childName, child);
        return child;
    }

    public int getNbChildren() {
        return this.fChildren.size();
    }

    public TmfStatisticsTreeNode getParent() {
        return this.fParent;
    }

    public TmfStatisticsTreeNode getTop() {
        return this.fTopNode;
    }

    public String[] getPath() {
        return this.fPath;
    }

    public TmfStatisticsValues getValues() {
        return this.fValues;
    }

    public boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    public void reset() {
        this.fValues.resetTotalCount();
        this.fValues.resetPartialCount();
        this.fChildren.clear();
    }

    public void resetGlobalValue() {
        for (TmfStatisticsTreeNode child : this.fChildren.values()) {
            child.resetGlobalValue();
        }
        this.fValues.resetTotalCount();
    }

    public void resetTimeRangeValue() {
        for (TmfStatisticsTreeNode child : this.fChildren.values()) {
            child.resetTimeRangeValue();
        }
        this.fValues.resetPartialCount();
    }

    public String toString() {
        return "Stats node, path = " + Arrays.toString(this.fPath) + ", values = " + this.fValues.toString();
    }
}

