/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.tabsview;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.linuxtools.tmf.ui.viewers.ITmfViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TmfViewerFolder
extends Composite {
    private final HashMap<String, ITmfViewer> fViewers;
    private CTabFolder fFolder;

    public TmfViewerFolder(Composite parent) {
        this(parent, 0);
    }

    public TmfViewerFolder(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.fViewers = new HashMap();
        this.initFolder();
    }

    public void dispose() {
        super.dispose();
        for (ITmfViewer viewer : this.fViewers.values()) {
            viewer.dispose();
        }
        if (this.fFolder != null) {
            this.fFolder.dispose();
        }
    }

    public void clear() {
        for (ITmfViewer viewer : this.fViewers.values()) {
            viewer.dispose();
        }
        this.fViewers.clear();
        this.fFolder.dispose();
        this.initFolder();
    }

    public boolean addTab(ITmfViewer viewer, String viewerID, int style) {
        if (this.fFolder == null || viewer.getControl().getParent() != this.fFolder || this.fViewers.containsKey(viewerID)) {
            return false;
        }
        CTabItem item = new CTabItem(this.fFolder, style);
        item.setText(viewer.getName());
        item.setControl(viewer.getControl());
        this.fViewers.put(viewerID, viewer);
        return true;
    }

    public Composite getParentFolder() {
        return this.fFolder;
    }

    public ITmfViewer getViewer(String viewerName) {
        return this.fViewers.get(viewerName);
    }

    public Collection<ITmfViewer> getViewers() {
        return this.fViewers.values();
    }

    public void setSelection(int index) throws SWTException {
        this.fFolder.setSelection(index);
    }

    private void initFolder() {
        if (this.fFolder != null) {
            this.fFolder.dispose();
        }
        this.fFolder = new CTabFolder((Composite)this, 18432);
        this.fFolder.setSimple(false);
    }
}

