/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import org.eclipse.mylyn.internal.tasks.core.data.ElementHandler;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TaskDataStateReader
extends DefaultHandler {
    private TaskStateHandler handler;
    private final IRepositoryManager repositoryManager;
    private TaskDataState result;

    public TaskDataStateReader(IRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.handler != null) {
            this.handler.characters(ch, start, length);
        }
    }

    private TaskAttribute createAttribute(TaskAttribute parent, String id) {
        TaskAttribute attribute = parent.createAttribute(id);
        attribute.getMetaData().defaults();
        return attribute;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.handler != null) {
            this.handler.endElement(uri, localName, name);
            if ("TaskState".equals(name)) {
                this.result = this.handler.getState();
                this.handler = null;
            }
        }
    }

    private TaskAttributeMapper getAttributeMapper(String connectorKind, String repositoryUrl) throws SAXException {
        AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(connectorKind);
        if (connector == null) {
            throw new SAXException("No repository connector for kind \"" + connectorKind + "\" found");
        }
        TaskRepository taskRepository = this.repositoryManager.getRepository(connectorKind, repositoryUrl);
        if (taskRepository == null) {
            throw new SAXException("Repository \"" + repositoryUrl + "\" not found for kind \"" + connectorKind + "\"");
        }
        AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        TaskAttributeMapper attributeMapper = taskDataHandler != null ? taskDataHandler.getAttributeMapper(taskRepository) : new TaskAttributeMapper(taskRepository);
        return attributeMapper;
    }

    public TaskDataState getTaskDataState() {
        return this.result;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.handler != null) {
            this.handler.startElement(uri, localName, name, attributes);
        }
        if ("TaskState".equals(name)) {
            String version = attributes.getValue("version");
            this.handler = new TaskStateHandler(version);
            this.handler.start(uri, localName, name, attributes);
        }
    }

    private class AttachmentHandler10
    extends ElementHandler {
        private int id;
        private TaskAttribute attribute;
        private final TaskAttribute parentAttribute;

        public AttachmentHandler10(ElementHandler parent, TaskAttribute parentAttribute) {
            super(parent, "Attachment");
            this.parentAttribute = parentAttribute;
        }

        @Override
        protected void end(String uri, String localName, String name) {
            TaskAttribute child = this.attribute.getAttribute("task.common.attachment.id");
            if (child != null) {
                this.attribute.setValue(child.getValue());
            }
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.attribute = TaskDataStateReader.this.createAttribute(this.parentAttribute, "task.common.attachment-" + ++this.id);
            this.attribute.getMetaData().defaults().setReadOnly(true).setType("attachment");
            this.attribute.setValue(String.valueOf(this.id));
            TaskAttribute child = TaskDataStateReader.this.createAttribute(this.attribute, "task.common.attachment.author");
            child.setValue(this.getValue(attributes, "creator"));
            child.getMetaData().putValue("task.meta.type", "person");
            child = TaskDataStateReader.this.createAttribute(this.attribute, "task.common.attachment.deprecated");
            child.setValue(this.getValue(attributes, "isObsolete"));
            child.getMetaData().putValue("task.meta.type", "boolean");
            child = TaskDataStateReader.this.createAttribute(this.attribute, "task.common.attachment.patch");
            child.setValue(this.getValue(attributes, "isPatch"));
            child.getMetaData().putValue("task.meta.type", "boolean");
            this.addElementHandler(new AttributeHandler10(TaskDataStateReader.this, this, this.attribute){

                @Override
                protected String mapId(String value) {
                    if ("task.common.description".equals(value)) {
                        return "task.common.attachment.description";
                    }
                    return super.mapId(value);
                }
            });
        }
    }

    private class AttributeHandler10
    extends ElementHandler {
        private TaskAttribute attribute;
        private final TaskAttribute parentAttribute;

        public AttributeHandler10(ElementHandler parent, TaskAttribute parentAttribute) {
            super(parent, "Attribute");
            this.parentAttribute = parentAttribute;
        }

        @Override
        protected void end(String uri, String localName, String name) {
            if (this.attribute.getOptions().size() > 0) {
                if (this.attribute.getValues().size() > 1) {
                    this.attribute.getMetaData().putValue("task.meta.type", "multiSelect");
                } else {
                    this.attribute.getMetaData().putValue("task.meta.type", "singleSelect");
                }
            }
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String id = this.mapId(this.getValue(attributes, "id"));
            String label = this.getValue(attributes, "name");
            boolean hidden = Boolean.parseBoolean(this.getValue(attributes, "hidden"));
            boolean readOnly = Boolean.parseBoolean(this.getValue(attributes, "readonly"));
            this.attribute = this.parentAttribute.createAttribute(id);
            String kind = hidden ? null : "task.common.kind.default";
            this.attribute.getMetaData().defaults().setLabel(label).setReadOnly(readOnly).setKind(kind);
            this.addElementHandler(new OptionHandler10(this, this.attribute));
            this.addElementHandler(new ValueHandler10(this, this.attribute));
            this.addElementHandler(new MetaDataHandler10(this, this.attribute));
        }

        protected String mapId(String value) {
            return value;
        }
    }

    private class AttributeHandler20
    extends ElementHandler {
        private TaskAttribute attribute;
        private final TaskAttribute parentAttribute;

        public AttributeHandler20(ElementHandler parent, TaskAttribute parentAttribute) {
            super(parent, "Attribute");
            this.parentAttribute = parentAttribute;
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String id = this.getValue(attributes, "id");
            this.attribute = this.parentAttribute.createAttribute(id);
            this.addElementHandler(new ValueHandler20(this, this.attribute));
            this.addElementHandler(new MapHandler20(this, this.attribute, "option"));
            this.addElementHandler(new MapHandler20(this, this.attribute, "meta"));
            this.addElementHandler(new AttributeHandler20(this, this.attribute));
        }
    }

    private class CommentHandler10
    extends ElementHandler {
        private int id;
        private TaskAttribute attribute;
        private final TaskAttribute parentAttribute;

        public CommentHandler10(ElementHandler parent, TaskAttribute parentAttribute) {
            super(parent, "Comment");
            this.parentAttribute = parentAttribute;
        }

        @Override
        protected void end(String uri, String localName, String name) {
            TaskAttribute child = this.attribute.getMappedAttribute("task.common.comment.text");
            if (child != null) {
                child.getMetaData().putValue("task.meta.readOnly", Boolean.toString(true));
                child.getMetaData().putValue("task.meta.type", "longRichText");
            }
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.attribute = TaskDataStateReader.this.createAttribute(this.parentAttribute, "task.common.comment-" + ++this.id);
            this.attribute.getMetaData().defaults().setReadOnly(true).setType("comment");
            this.attribute.getMetaData().putValue("task.meta.associated.attribute", "task.common.comment.text");
            this.attribute.setValue(this.getValue(attributes, "number"));
            TaskAttribute child = TaskDataStateReader.this.createAttribute(this.attribute, "task.common.comment.attachment.id");
            child.setValue(this.getValue(attributes, "attachmentId"));
            child = TaskDataStateReader.this.createAttribute(this.attribute, "task.common.comment.attachment");
            child.setValue(this.getValue(attributes, "hasAttachment"));
            child.getMetaData().putValue("task.meta.type", "boolean");
            child = TaskDataStateReader.this.createAttribute(this.attribute, "task.common.comment.number");
            child.setValue(this.getValue(attributes, "number"));
            child.getMetaData().putValue("task.meta.type", "integer");
            this.addElementHandler(new AttributeHandler10(this, this.attribute));
        }
    }

    private class MapHandler20
    extends ElementHandler {
        private final TaskAttribute attribute;
        private String key;
        private String value;

        public MapHandler20(ElementHandler parent, TaskAttribute attribute, String elementName) {
            super(parent, elementName);
            this.key = "";
            this.value = "";
            this.attribute = attribute;
        }

        @Override
        public void end(String uri, String localName, String name) {
            if ("option".equals(this.getElementName())) {
                this.attribute.putOption(this.key, this.value);
            } else if ("meta".equals(this.getElementName())) {
                this.attribute.getMetaData().putValue(this.key, this.value);
            }
            this.key = "";
            this.value = "";
        }

        @Override
        protected void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.addElementHandler(new TextHandler20(this, "key"));
            this.addElementHandler(new TextHandler20(this, "value"));
        }

        @Override
        protected void done(ElementHandler handler) {
            if ("key".equals(handler.getElementName())) {
                this.key = handler.getCurrentElementText();
            } else if ("value".equals(handler.getElementName())) {
                this.value = handler.getCurrentElementText();
            }
            super.done(handler);
        }
    }

    private class MetaDataHandler10
    extends ElementHandler {
        private final TaskAttribute attribute;
        private String key;

        public MetaDataHandler10(ElementHandler parent, TaskAttribute attribute) {
            super(parent, "meta");
            this.attribute = attribute;
        }

        @Override
        public void end(String uri, String localName, String name) {
            this.attribute.getMetaData().putValue(this.key, this.getCurrentElementText());
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.key = this.getValue(attributes, "key");
            this.clearCurrentElementText();
        }
    }

    private class NameHandler
    extends ElementHandler {
        private final TaskAttribute attribute;
        private String value;

        public NameHandler(ElementHandler parent, TaskAttribute attribute) {
            super(parent, "name");
            this.attribute = attribute;
        }

        @Override
        public void end(String uri, String localName, String name) {
            this.attribute.putOption(this.value, this.getCurrentElementText());
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.value = this.getValue(attributes, "value");
            this.clearCurrentElementText();
        }
    }

    private class OperationHandler10
    extends ElementHandler {
        private TaskAttribute attribute;
        private final TaskAttribute operationAttribute;
        private final TaskAttribute parentAttribute;
        private int id;

        public OperationHandler10(ElementHandler parent, TaskAttribute parentAttribute) {
            super(parent, "Operation");
            this.parentAttribute = parentAttribute;
            this.operationAttribute = TaskDataStateReader.this.createAttribute(parentAttribute, "task.common.operation");
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String value;
            this.attribute = TaskDataStateReader.this.createAttribute(this.parentAttribute, "task.common.operation-" + ++this.id);
            this.attribute.getMetaData().putValue("task.meta.type", "operation");
            this.attribute.getMetaData().putValue("task.meta.label", this.getValue(attributes, "operationName"));
            String operationId = this.getValue(attributes, "knob_name");
            this.attribute.setValue(operationId);
            if (Boolean.parseBoolean(this.getValue(attributes, "isChecked"))) {
                this.operationAttribute.setValue(operationId);
            }
            if ((value = this.getOptionalValue(attributes, "optionName")).length() > 0) {
                this.attribute.getMetaData().putValue("task.meta.associated.attribute", value);
                TaskAttribute child = TaskDataStateReader.this.createAttribute(this.attribute, value);
                child.setValue(this.getOptionalValue(attributes, "optionSelection"));
                child.getMetaData().defaults().setReadOnly(false).setType("singleSelect");
                this.addElementHandler(new NameHandler(this, child));
            } else {
                value = this.getOptionalValue(attributes, "inputName");
                if (value.length() > 0) {
                    this.attribute.getMetaData().putValue("task.meta.associated.attribute", value);
                    TaskAttribute child = TaskDataStateReader.this.createAttribute(this.attribute, value);
                    child.setValue(this.getOptionalValue(attributes, "inputValue"));
                    child.getMetaData().defaults().setReadOnly(false).setType("shortText");
                }
            }
        }
    }

    private class OptionHandler10
    extends ElementHandler {
        private final TaskAttribute attribute;
        private String parameter;

        public OptionHandler10(ElementHandler parent, TaskAttribute attribute) {
            super(parent, "option");
            this.attribute = attribute;
        }

        @Override
        public void end(String uri, String localName, String name) {
            this.attribute.putOption(this.parameter, this.getCurrentElementText());
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.parameter = this.getValue(attributes, "parameter");
            this.clearCurrentElementText();
        }
    }

    private class TaskDataHandler10
    extends ElementHandler {
        private TaskData taskData;

        public TaskDataHandler10(TaskStateHandler parent, String elementName) {
            super(parent, elementName);
        }

        public TaskData getTaskData() {
            return this.taskData;
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.taskData = ((TaskStateHandler)this.getParent()).createTaskData(attributes);
            String taskKind = this.getOptionalValue(attributes, "taskKind");
            if (taskKind != null) {
                TaskDataStateReader.this.createAttribute(this.taskData.getRoot(), "task.common.kind").setValue(taskKind);
            }
            this.addElementHandler(new AttributeHandler10(this, this.taskData.getRoot()));
            this.addElementHandler(new CommentHandler10(this, this.taskData.getRoot()));
            this.addElementHandler(new AttachmentHandler10(this, this.taskData.getRoot()));
            this.addElementHandler(new OperationHandler10(this, this.taskData.getRoot()));
        }
    }

    private class TaskDataHandler20
    extends ElementHandler {
        private TaskData taskData;

        public TaskDataHandler20(TaskStateHandler parent, String elementName) {
            super(parent, elementName);
        }

        public TaskData getTaskData() {
            return this.taskData;
        }

        @Override
        public void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.taskData = ((TaskStateHandler)this.getParent()).createTaskData(attributes);
            ElementHandler handler = new ElementHandler(this, "Attribute");
            handler.addElementHandler(new AttributeHandler20(handler, this.taskData.getRoot()));
            this.addElementHandler(handler);
        }
    }

    private class TaskStateHandler
    extends ElementHandler {
        private TaskAttributeMapper attributeMapper;
        private TaskDataState state;
        private final String version;

        public TaskStateHandler(String version) {
            super(null, "TaskState");
            this.version = version;
            if ("1.0".equals(version)) {
                this.addElementHandler(new TaskDataHandler10(this, "NewData"));
                this.addElementHandler(new TaskDataHandler10(this, "OldData"));
                this.addElementHandler(new TaskDataHandler10(this, "EditsData"));
            } else if ("2.0".equals(version)) {
                this.addElementHandler(new TaskDataHandler20(this, "NewData"));
                this.addElementHandler(new TaskDataHandler20(this, "OldData"));
                this.addElementHandler(new TaskDataHandler20(this, "EditsData"));
            }
        }

        public TaskData createTaskData(Attributes attributes) throws SAXException {
            TaskData taskData;
            if (this.state == null) {
                String connectorKind = this.getValue(attributes, "repositoryKind");
                String repositoryUrl = this.getValue(attributes, "repositoryUrl");
                String taskId = this.getValue(attributes, "id");
                this.attributeMapper = TaskDataStateReader.this.getAttributeMapper(connectorKind, repositoryUrl);
                taskData = new TaskData(this.attributeMapper, connectorKind, repositoryUrl, taskId);
            } else {
                taskData = new TaskData(this.attributeMapper, this.state.getConnectorKind(), this.state.getRepositoryUrl(), this.state.getTaskId());
            }
            String taskDataVersion = this.getOptionalValue(attributes, "version");
            if (taskDataVersion.length() > 0) {
                taskData.setVersion(taskDataVersion);
            }
            return taskData;
        }

        @Override
        public void done(ElementHandler elementHandler) {
            TaskData taskData;
            if (elementHandler instanceof TaskDataHandler10) {
                TaskDataHandler10 taskDataHandler = (TaskDataHandler10)elementHandler;
                TaskData data = taskDataHandler.getTaskData();
                if (this.state == null) {
                    this.state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
                }
                taskData = taskDataHandler.getTaskData();
            } else {
                TaskDataHandler20 taskDataHandler = (TaskDataHandler20)elementHandler;
                taskData = taskDataHandler.getTaskData();
            }
            if ("NewData".equals(elementHandler.getElementName())) {
                this.state.setRepositoryData(taskData);
            } else if ("OldData".equals(elementHandler.getElementName())) {
                this.state.setLastReadData(taskData);
            } else if ("EditsData".equals(elementHandler.getElementName())) {
                this.state.setEditsData(taskData);
            }
            super.done(elementHandler);
        }

        public TaskDataState getState() {
            return this.state;
        }

        @Override
        protected void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("2.0".equals(this.version)) {
                String connectorKind = this.getValue(attributes, "connectorKind");
                String repositoryUrl = this.getValue(attributes, "repositoryUrl");
                String taskId = this.getValue(attributes, "taskId");
                this.attributeMapper = TaskDataStateReader.this.getAttributeMapper(connectorKind, repositoryUrl);
                this.state = new TaskDataState(connectorKind, repositoryUrl, taskId);
            }
        }
    }

    private class TextHandler20
    extends ElementHandler {
        public TextHandler20(ElementHandler parent, String elementName) {
            super(parent, elementName);
        }

        @Override
        protected void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.clearCurrentElementText();
        }
    }

    private class ValueHandler10
    extends ElementHandler {
        private final TaskAttribute attribute;

        public ValueHandler10(ElementHandler parent, TaskAttribute attribute) {
            super(parent, "value");
            this.attribute = attribute;
        }

        @Override
        public void end(String uri, String localName, String name) {
            this.attribute.addValue(this.getCurrentElementText());
        }

        @Override
        protected void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.clearCurrentElementText();
        }
    }

    private class ValueHandler20
    extends ElementHandler {
        private final TaskAttribute attribute;

        public ValueHandler20(ElementHandler parent, TaskAttribute attribute) {
            super(parent, "value");
            this.attribute = attribute;
        }

        @Override
        public void end(String uri, String localName, String name) {
            this.attribute.addValue(this.getCurrentElementText());
        }

        @Override
        protected void start(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.clearCurrentElementText();
        }
    }
}

