/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.w3c.dom.Element;

public class XmlEntry
extends TimeGraphEntry
implements IXmlStateSystemContainer {
    private static final String EMPTY_STRING = "";
    private final ITmfTrace fTrace;
    private final EntryDisplayType fType;
    private final int fBaseQuark;
    private final int fDisplayQuark;
    private final String fParentId;
    private final String fId;
    @NonNull
    private final ITmfStateSystem fSs;
    private final Element fElement;

    public XmlEntry(int baseQuark, int displayQuark, ITmfTrace trace, String name, long startTime, long endTime, EntryDisplayType type, @NonNull ITmfStateSystem ss, Element entryElement) {
        super(name, startTime, endTime);
        String nameFromSs;
        this.fTrace = trace;
        this.fType = type;
        this.fBaseQuark = baseQuark;
        this.fDisplayQuark = displayQuark;
        this.fSs = ss;
        this.fElement = entryElement;
        List elements = XmlUtils.getChildElements((Element)this.fElement, (String)"parent");
        this.fParentId = elements.size() > 0 ? this.getFirstValue((Element)elements.get(0)) : EMPTY_STRING;
        elements = XmlUtils.getChildElements((Element)this.fElement, (String)"name");
        if (elements.size() > 0 && !(nameFromSs = this.getFirstValue((Element)elements.get(0))).isEmpty()) {
            this.setName(nameFromSs);
        }
        this.fId = (elements = XmlUtils.getChildElements((Element)this.fElement, (String)"id")).size() > 0 ? this.getFirstValue((Element)elements.get(0)) : name;
    }

    public XmlEntry(int baseQuark, ITmfTrace trace, String name, @NonNull ITmfStateSystem ss) {
        super(name, ss.getStartTime(), ss.getCurrentEndTime());
        this.fTrace = trace;
        this.fType = EntryDisplayType.NULL;
        this.fBaseQuark = baseQuark;
        this.fDisplayQuark = baseQuark;
        this.fSs = ss;
        this.fElement = null;
        this.fParentId = EMPTY_STRING;
        this.fId = name;
    }

    private String getFirstValue(Element stateAttribute) {
        ITmfXmlModelFactory factory = TmfXmlReadOnlyModelFactory.getInstance();
        ITmfXmlStateAttribute display = factory.createStateAttribute(stateAttribute, (IXmlStateSystemContainer)this);
        int quark = display.getAttributeQuark(this.fBaseQuark);
        if (quark != -1) {
            try {
                List execNameIntervals = this.fSs.queryHistoryRange(quark, this.getStartTime(), this.getEndTime());
                for (ITmfStateInterval execNameInterval : execNameIntervals) {
                    if (execNameInterval.getStateValue().isNull()) continue;
                    return execNameInterval.getStateValue().toString();
                }
            }
            catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
                // empty catch block
            }
        }
        return EMPTY_STRING;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public EntryDisplayType getType() {
        return this.fType;
    }

    public int getDisplayQuark() {
        return this.fDisplayQuark;
    }

    public String getId() {
        return this.fId;
    }

    public String getParentId() {
        return this.fParentId;
    }

    public boolean hasTimeEvents() {
        return this.fType != EntryDisplayType.NULL;
    }

    public void addChild(XmlEntry entry) {
        int index = 0;
        while (index < this.getChildren().size()) {
            XmlEntry other = (XmlEntry)((Object)this.getChildren().get(index));
            if (entry.getType().compareTo(other.getType()) < 0 || entry.getType().equals((Object)other.getType()) && entry.getName().compareTo(other.getName()) < 0) break;
            ++index;
        }
        entry.setParent(this);
        this.getChildren().add(index, entry);
    }

    @NonNull
    public ITmfStateSystem getStateSystem() {
        return this.fSs;
    }

    public String getAttributeValue(String name) {
        return name;
    }

    public Iterable<TmfXmlLocation> getLocations() {
        return Collections.EMPTY_SET;
    }

    public static enum EntryDisplayType {
        NULL,
        DISPLAY;

    }
}

