/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.statesystem.core;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.linuxtools.internal.statesystem.core.Attribute;
import org.eclipse.linuxtools.internal.statesystem.core.StateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

public final class AttributeTree {
    private static final int ATTRIB_TREE_MAGIC_NUMBER = 116143729;
    private final StateSystem ss;
    private final List<Attribute> attributeList;
    private final Attribute attributeTreeRoot;

    public AttributeTree(StateSystem ss) {
        this.ss = ss;
        this.attributeList = Collections.synchronizedList(new ArrayList());
        this.attributeTreeRoot = new Attribute(null, "root", -1);
    }

    public AttributeTree(StateSystem ss, FileInputStream fis) throws IOException {
        this(ss);
        DataInputStream in = new DataInputStream(new BufferedInputStream(fis));
        String errorMessage = "The attribute tree file section is either invalid or corrupted.";
        ArrayList<String[]> list = new ArrayList<String[]>();
        int expectedSize = 0;
        int total = 0;
        int res = in.readInt();
        if (res != 116143729) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        expectedSize = in.readInt();
        if (expectedSize < 12) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        int remain = in.readInt();
        total += 12;
        while (remain > 0) {
            byte size = in.readByte();
            byte[] curByteArray = new byte[size];
            res = in.read(curByteArray);
            if (res != size) {
                throw new IOException("The attribute tree file section is either invalid or corrupted.");
            }
            String curFullString = new String(curByteArray);
            String[] curStringArray = curFullString.split("/");
            list.add(curStringArray);
            res = in.readByte();
            if (res != 0) {
                throw new IOException("The attribute tree file section is either invalid or corrupted.");
            }
            total += curByteArray.length + 2;
            --remain;
        }
        if (total != expectedSize) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        for (String[] attrib : list) {
            this.getQuarkAndAdd(-1, attrib);
        }
    }

    public int writeSelf(File file, long pos) {
        int total = 0;
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.seek(pos);
                raf.writeInt(116143729);
                raf.writeInt(-8000);
                raf.writeInt(this.attributeList.size());
                total += 12;
                for (Attribute entry : this.attributeList) {
                    byte[] curByteArray = entry.getFullAttributeName().getBytes();
                    if (curByteArray.length > 127) {
                        throw new IOException("Attribute with name \"" + Arrays.toString(curByteArray) + "\" is too long.");
                    }
                    raf.writeByte((byte)curByteArray.length);
                    raf.write(curByteArray);
                    raf.writeByte(0);
                    total += curByteArray.length + 2;
                }
                raf.seek(pos + 4L);
                raf.writeInt(total);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return total;
    }

    public int getNbAttributes() {
        return this.attributeList.size();
    }

    public int getQuarkDontAdd(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        assert (startingNodeQuark >= -1);
        if (subPath == null || subPath.length == 0) {
            return startingNodeQuark;
        }
        Attribute prevNode = startingNodeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(startingNodeQuark);
        int knownQuark = prevNode.getSubAttributeQuark(subPath);
        if (knownQuark == -1) {
            throw new AttributeNotFoundException();
        }
        return knownQuark;
    }

    public synchronized int getQuarkAndAdd(int startingNodeQuark, String ... subPath) {
        assert (subPath != null && subPath.length > 0);
        assert (startingNodeQuark >= -1);
        Attribute nextNode = null;
        Attribute prevNode = startingNodeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(startingNodeQuark);
        int knownQuark = prevNode.getSubAttributeQuark(subPath);
        if (knownQuark == -1) {
            String[] stringArray = subPath;
            int n = subPath.length;
            int n2 = 0;
            while (n2 < n) {
                String curDirectory = stringArray[n2];
                nextNode = prevNode.getSubAttributeNode(curDirectory);
                if (nextNode == null) {
                    nextNode = new Attribute(prevNode, curDirectory, this.attributeList.size());
                    prevNode.addSubAttribute(nextNode);
                    this.attributeList.add(nextNode);
                    this.ss.addEmptyAttribute();
                }
                prevNode = nextNode;
                ++n2;
            }
            int newAttrib = this.attributeList.size() - 1;
            try {
                this.ss.modifyAttribute(this.ss.getStartTime(), TmfStateValue.nullValue(), newAttrib);
            }
            catch (TimeRangeException e) {
                throw new IllegalStateException(e);
            }
            catch (AttributeNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (StateValueTypeException e) {
                throw new IllegalStateException(e);
            }
            return newAttrib;
        }
        return knownQuark;
    }

    public List<Integer> getSubAttributes(int attributeQuark, boolean recursive) throws AttributeNotFoundException {
        ArrayList<Integer> listOfChildren = new ArrayList<Integer>();
        if (attributeQuark < -1 || attributeQuark >= this.attributeList.size()) {
            throw new AttributeNotFoundException();
        }
        Attribute startingAttribute = attributeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(attributeQuark);
        this.addSubAttributes(listOfChildren, startingAttribute, recursive);
        return listOfChildren;
    }

    public int getParentAttributeQuark(int quark) {
        if (quark == -1) {
            return quark;
        }
        return this.attributeList.get(quark).getParentAttributeQuark();
    }

    private void addSubAttributes(List<Integer> list, Attribute curAttribute, boolean recursive) {
        for (Attribute childNode : curAttribute.getSubAttributes()) {
            list.add(childNode.getQuark());
            if (!recursive) continue;
            this.addSubAttributes(list, childNode, true);
        }
    }

    public String getAttributeName(int quark) {
        return this.attributeList.get(quark).getName();
    }

    public String getFullAttributeName(int quark) {
        if (quark >= this.attributeList.size() || quark < 0) {
            return null;
        }
        return this.attributeList.get(quark).getFullAttributeName();
    }

    public void debugPrint(PrintWriter writer) {
        this.attributeTreeRoot.debugPrint(writer);
    }
}

