/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.scope;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class LexicalScope
implements Comparable<LexicalScope> {
    public static final LexicalScope ROOT = new LexicalScope(null, "");
    public static final LexicalScope TRACE = new LexicalScope(ROOT, "trace");
    public static final LexicalScope ENV = new LexicalScope(ROOT, "env");
    public static final LexicalScope STREAM = new LexicalScope(ROOT, "stream");
    public static final LexicalScope EVENT = new LexicalScope(ROOT, "event");
    public static final LexicalScope VARIANT = new LexicalScope(ROOT, "variant");
    public static final LexicalScope PACKET = new LexicalScope(ROOT, "packet");
    public static final LexicalScope PACKET_HEADER = new LexicalScope(PACKET, "header");
    public static final LexicalScope STREAM_PACKET = new LexicalScope(STREAM, "packet");
    public static final LexicalScope STREAM_PACKET_CONTEXT = new LexicalScope(STREAM_PACKET, "context");
    public static final LexicalScope TRACE_PACKET = new LexicalScope(TRACE, "packet");
    public static final LexicalScope STREAM_EVENT = new LexicalScope(STREAM, "event");
    public static final LexicalScope TRACE_PACKET_HEADER = new LexicalScope(TRACE_PACKET, "header");
    public static final LexicalScope STREAM_EVENT_CONTEXT = new LexicalScope(STREAM_EVENT, "context");
    public static final LexicalScope STREAM_EVENT_HEADER = new LexicalScope(STREAM_EVENT, "header");
    public static final LexicalScope FIELDS = new LexicalScope(ROOT, "fields");
    public static final LexicalScope CONTEXT = new LexicalScope(ROOT, "context");
    public static final LexicalScope[] PARENT_PATHS = new LexicalScope[]{ROOT, CONTEXT, FIELDS, PACKET_HEADER, STREAM_EVENT_CONTEXT, STREAM_EVENT_HEADER, STREAM_PACKET_CONTEXT, TRACE_PACKET_HEADER};
    private int hash = 0;
    private final String fName;
    private final String fPath;
    private final Map<String, LexicalScope> fChildren;

    public LexicalScope(@Nullable LexicalScope parent, String name) {
        this.fName = name;
        if (parent != null) {
            String pathString = Joiner.on((char)'.').skipNulls().join((Object)parent.fPath, (Object)parent.getName(), new Object[0]);
            if (pathString.startsWith(".")) {
                pathString = pathString.substring(1);
            }
            if (pathString == null) {
                throw new IllegalStateException("Lexical scope constructor had null pathstring for " + parent.toString() + " and " + name);
            }
            this.fPath = pathString;
            parent.addChild(this.fName, this);
        } else {
            this.fPath = "";
        }
        Map children = Collections.synchronizedMap(new HashMap());
        this.fChildren = children;
    }

    private void addChild(String name, LexicalScope child) {
        this.fChildren.put(name, child);
    }

    public String getName() {
        return this.fName;
    }

    @Nullable
    public LexicalScope getChild(String name) {
        return this.fChildren.get(name);
    }

    public String toString() {
        return String.valueOf(this.fPath) + '.' + this.fName;
    }

    @Override
    public int compareTo(@Nullable LexicalScope other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        int comp = this.fPath.compareTo(other.fPath);
        if (comp == 0) {
            return this.fName.compareTo(other.fName);
        }
        return comp;
    }

    public synchronized int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            this.hash = 31 * (31 + this.fName.hashCode()) + this.fPath.hashCode();
        }
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LexicalScope other = (LexicalScope)obj;
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        return this.fPath.equals(other.fPath);
    }
}

