/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.Encoding;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public class StringDeclaration
extends Declaration {
    private final Encoding fEncoding;

    public StringDeclaration() {
        this.fEncoding = Encoding.UTF8;
    }

    public StringDeclaration(Encoding encoding) {
        this.fEncoding = encoding;
    }

    public Encoding getEncoding() {
        return this.fEncoding;
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public StringDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        String value = this.read(input);
        return new StringDefinition(this, definitionScope, fieldName, value);
    }

    private String read(BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        StringBuilder sb = new StringBuilder();
        char c = (char)input.get(8, false);
        while (c != '\u0000') {
            sb.append(c);
            c = (char)input.get(8, false);
        }
        return sb.toString();
    }

    public String toString() {
        return "[declaration] string[" + Integer.toHexString(this.hashCode()) + ']';
    }
}

