/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public class StructDeclaration
extends Declaration {
    private final Map<String, IDeclaration> fFieldMap = new LinkedHashMap<String, IDeclaration>();
    @NonNull
    private ImmutableList<String> fFieldNames;
    private List<IDeclaration> fFieldDeclarations;
    private long fMaxAlign;

    public StructDeclaration(long align) {
        this.fMaxAlign = Math.max(align, 1L);
        this.fFieldNames = ImmutableList.of();
    }

    public StructDeclaration(String[] names, Declaration[] declarations) {
        this.fMaxAlign = 1L;
        this.fFieldNames = ImmutableList.of();
        int i = 0;
        while (i < names.length) {
            this.addField(names[i], declarations[i]);
            ++i;
        }
    }

    public long getMaxAlign() {
        return this.fMaxAlign;
    }

    public boolean hasField(String name) {
        return this.fFieldMap.containsKey(name);
    }

    public Map<String, IDeclaration> getFields() {
        return this.fFieldMap;
    }

    public Iterable<String> getFieldsList() {
        return this.fFieldMap.keySet();
    }

    @Override
    public long getAlignment() {
        return this.fMaxAlign;
    }

    @Override
    public int getMaximumSize() {
        int maxSize = 0;
        if (this.fFieldDeclarations != null) {
            for (IDeclaration field : this.fFieldDeclarations) {
                maxSize += field.getMaximumSize();
            }
        }
        return Math.min(maxSize, Integer.MAX_VALUE);
    }

    @Override
    public StructDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        Definition[] myFields = new Definition[this.fFieldNames.size()];
        StructDefinition structDefinition = new StructDefinition(this, definitionScope, fieldName, (List<String>)this.fFieldNames, myFields);
        int i = 0;
        while (i < this.fFieldNames.size()) {
            myFields[i] = this.fFieldDeclarations.get(i).createDefinition(structDefinition, (String)this.fFieldNames.get(i), input);
            ++i;
        }
        return structDefinition;
    }

    public void addField(String name, IDeclaration declaration) {
        this.fFieldMap.put(name, declaration);
        this.fMaxAlign = Math.max(this.fMaxAlign, declaration.getAlignment());
        this.fFieldNames = ImmutableList.copyOf(this.fFieldMap.keySet());
        this.fFieldDeclarations = ImmutableList.copyOf(this.fFieldMap.values());
    }

    public String toString() {
        return "[declaration] struct[" + Integer.toHexString(this.hashCode()) + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFieldMap.entrySet().hashCode();
        result = 31 * result + (int)(this.fMaxAlign ^ this.fMaxAlign >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)obj;
        if (!this.fFieldMap.entrySet().equals(other.fFieldMap.entrySet())) {
            return false;
        }
        return this.fMaxAlign == other.fMaxAlign;
    }
}

