/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public class VariantDeclaration
extends Declaration {
    private String fTag = null;
    private static final long ALIGNMENT = 1L;
    private final Map<String, IDeclaration> fFields = Collections.synchronizedMap(new HashMap());
    private EnumDefinition fTagDef;
    private IDeclaration fDeclarationToPopulate;
    private IDefinitionScope fPrevDefinitionScope;

    public boolean isTagged() {
        return this.fTag != null;
    }

    public boolean hasField(String fieldTag) {
        return this.fFields.containsKey(fieldTag);
    }

    public void setTag(String tag) {
        this.fTag = tag;
        this.fTagDef = null;
    }

    public String getTag() {
        return this.fTag;
    }

    public Map<String, IDeclaration> getFields() {
        return this.fFields;
    }

    @Override
    public long getAlignment() {
        return 1L;
    }

    @Override
    public VariantDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        EnumDefinition tagDef;
        this.alignRead(input);
        if (this.fPrevDefinitionScope != definitionScope) {
            this.fTagDef = null;
            this.fPrevDefinitionScope = definitionScope;
        }
        if ((tagDef = this.fTagDef) == null) {
            Definition def = definitionScope.lookupDefinition(this.fTag);
            tagDef = (EnumDefinition)(def instanceof EnumDefinition ? def : null);
        }
        if (tagDef == null) {
            throw new CTFReaderException("Tag is not defined " + this.fTag);
        }
        String varFieldName = tagDef.getStringValue();
        this.fDeclarationToPopulate = this.fFields.get(varFieldName);
        if (this.fDeclarationToPopulate == null) {
            throw new CTFReaderException("Unknown enum selector for variant " + definitionScope.getScopePath().toString());
        }
        Definition fieldValue = this.fDeclarationToPopulate.createDefinition(definitionScope, fieldName, input);
        return new VariantDefinition(this, definitionScope, varFieldName, fieldName, fieldValue);
    }

    public void addField(String fieldTag, IDeclaration declaration) {
        this.fFields.put(fieldTag, declaration);
    }

    public EnumDefinition getTagDef() {
        return this.fTagDef;
    }

    @Override
    public int getMaximumSize() {
        Collection<IDeclaration> values = this.fFields.values();
        int maxSize = 0;
        for (IDeclaration field : values) {
            maxSize = Math.max(maxSize, field.getMaximumSize());
        }
        return maxSize;
    }

    public String toString() {
        return "[declaration] variant[" + Integer.toHexString(this.hashCode()) + ']';
    }
}

