/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.ptp.internal.remote.terminal.MachineManager;
import org.eclipse.ptp.internal.remote.terminal.RemoteConnector;
import org.eclipse.ptp.internal.remote.terminal.Util;
import org.eclipse.ptp.internal.remote.terminal.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class RemoteConnection
extends Thread {
    private static int fgNo;
    private final ITerminalControl fControl;
    private final RemoteConnector fConn;
    private IRemoteConnection fRemoteConnection;
    private IRemoteProcess fProcess;
    private IProject fProject = null;

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected RemoteConnection(RemoteConnector conn, ITerminalControl control) {
        super("RemoteConnection-" + fgNo++);
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    @Override
    public void run() {
        try {
            try {
                this.fProject = this.fConn.getProject();
                if (this.fProject == null) {
                    IRemoteConnectionManager connMgr;
                    String remoteServices = this.fConn.getSshSettings().getRemoteServices();
                    IRemoteServices services = RemoteServices.getRemoteServices((String)remoteServices);
                    if (services != null && (connMgr = services.getConnectionManager()) != null) {
                        this.fRemoteConnection = connMgr.getConnection(this.fConn.getSshSettings().getConnectionName());
                    }
                } else {
                    this.fRemoteConnection = Util.getRemoteConnection(this.fProject);
                }
                if (this.fRemoteConnection != null && !this.fRemoteConnection.isOpen()) {
                    try {
                        this.fRemoteConnection.open(null);
                    }
                    catch (RemoteConnectionException e) {
                        Activator.log(e);
                    }
                }
                if (this.fRemoteConnection != null && this.fRemoteConnection.isOpen()) {
                    TerminalPlugin plugin = TerminalPlugin.getDefault();
                    IPreferenceStore preferenceStore = plugin.getPreferenceStore();
                    this.setupHistoryMonitoring(this.fConn, preferenceStore);
                    try {
                        this.readDataForever(this.fConn.getInputStream());
                    }
                    catch (InterruptedIOException interruptedIOException) {}
                }
            }
            catch (IOException iOException) {
                this.fControl.setState(TerminalState.CLOSED);
                try {
                    this.disconnect();
                }
                finally {
                    this.fControl.setState(TerminalState.CLOSED);
                }
            }
        }
        finally {
            try {
                this.disconnect();
            }
            finally {
                this.fControl.setState(TerminalState.CLOSED);
            }
        }
    }

    private String getDefault(String val, String defaultVal) {
        if (val == null || val.trim().equals("")) {
            return defaultVal;
        }
        return val;
    }

    public void shutdown() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this.interrupt();
        RemoteConnection remoteConnection = this;
        synchronized (remoteConnection) {
            if (this.fProcess != null && !this.fProcess.isCompleted()) {
                this.fProcess.destroy();
            }
        }
    }

    private void readDataForever(InputStream in) throws IOException {
        int n;
        byte[] buf = new byte[32768];
        while ((n = in.read(buf, 0, buf.length)) >= 0) {
            String str = new String(buf, 0, n);
            boolean print = this.parse(str);
            if (!print) continue;
            this.fControl.getRemoteToTerminalOutputStream().write(buf, 0, n);
        }
    }

    private boolean parse(String str) {
        Pattern pattern = Pattern.compile("~~EPTP:(\\w*)~~(.*)");
        Matcher match = pattern.matcher(str);
        if (match.find()) {
            String type = match.group(1);
            String location = match.group(2);
            this.doAction(type, location);
            return false;
        }
        return true;
    }

    private void doAction(String type, String str) {
        if (type.equals("Radio")) {
            this.doRadioAction(str);
        } else if (type.equals("Choice")) {
            this.doChoiceAction(str);
        } else if (type.equals("OpenFile")) {
            this.openFile(str);
        }
    }

    private void doChoiceAction(String str) {
        final String[] choices = str.split("\\s*~~\\s*");
        RemoteConnection.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Dialog dialog = new Dialog(RemoteConnection.getStandardDisplay().getActiveShell()){
                        Combo combo;
                        String[] comboChoices;

                        protected void configureShell(Shell shell) {
                            shell.setText(Messages.CHOOSE_FILE);
                            super.configureShell(shell);
                        }

                        protected Control createDialogArea(Composite parent) {
                            Composite container = (Composite)super.createDialogArea(parent);
                            this.combo = new Combo(container, 0);
                            this.combo.setItems(choices);
                            this.comboChoices = choices;
                            Point pt = this.combo.computeSize(-1, -1);
                            this.combo.setSize(pt.x, 5 * pt.y);
                            return container;
                        }

                        public void buttonPressed(int buttonId) {
                            int n = this.combo.getSelectionIndex();
                            if (buttonId == 0 && n >= 0 && n < this.comboChoices.length) {
                                RemoteConnection.this.openFile(this.comboChoices[n]);
                            }
                            this.close();
                        }
                    };
                    dialog.open();
                }
                catch (Exception t) {
                    Activator.log(t);
                }
            }
        });
    }

    private void doRadioAction(String str) {
        final String[] choices = str.split("\\s*~~\\s*");
        RemoteConnection.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Dialog dialog = new Dialog(RemoteConnection.getStandardDisplay().getActiveShell()){
                        private final Map<String, String> smap;
                        private final List<Button> buttons;
                        {
                            super($anonymous0);
                            this.smap = new HashMap<String, String>();
                            this.buttons = new ArrayList<Button>();
                        }

                        protected void configureShell(Shell shell) {
                            shell.setText(Messages.CHOOSE_FILE);
                            super.configureShell(shell);
                        }

                        protected Control createDialogArea(Composite parent) {
                            Composite container = (Composite)super.createDialogArea(parent);
                            String[] stringArray = choices;
                            int n = choices.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String choice = stringArray[n2];
                                String[] keyvalue = choice.split("::~");
                                if (keyvalue.length == 2) {
                                    Button b = new Button(container, 16);
                                    b.setText(keyvalue[0]);
                                    this.smap.put(keyvalue[0], keyvalue[1]);
                                    this.buttons.add(b);
                                }
                                ++n2;
                            }
                            return container;
                        }

                        public void buttonPressed(int buttonId) {
                            if (buttonId == 0) {
                                for (Button b : this.buttons) {
                                    if (!b.getSelection()) continue;
                                    String value = this.smap.get(b.getText());
                                    try {
                                        OutputStream out = RemoteConnection.this.fProcess.getOutputStream();
                                        out.write((String.valueOf(value) + "\n").getBytes());
                                        out.flush();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            this.close();
                        }
                    };
                    dialog.open();
                }
                catch (Exception t) {
                    Activator.log(t);
                }
            }
        });
    }

    public void openFile(final String file) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject prj = iProjectArray[n2];
            final URI remoteURI = Util.getLocationURI(prj);
            if (remoteURI != null && file.startsWith(remoteURI.getPath())) {
                RemoteConnection.getStandardDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            String loc = file.substring(remoteURI.getPath().length() + 1);
                            IFile file2 = prj.getFile(loc);
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file2);
                        }
                        catch (PartInitException e) {
                            Activator.log(e);
                        }
                    }
                });
                return;
            }
            ++n2;
        }
        RemoteConnection.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorDescriptor editorDesc = IDE.getEditorDescriptor((String)file);
                    IRemoteFileManager irfm = RemoteConnection.this.fRemoteConnection.getFileManager();
                    URI uri = irfm.toURI(file);
                    String editorId = editorDesc.getId();
                    IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)editorId, (boolean)true);
                }
                catch (PartInitException e) {
                    Activator.log(e);
                }
            }
        });
    }

    void setupHistoryMonitoring(RemoteConnector remoteConnector, IPreferenceStore preferenceStore) throws IOException {
        MachineManager.MachineInfo minfo = null;
        if ((this.fRemoteConnection.getRemoteServices().getCapabilities() & 0x20) != 0) {
            this.fProcess = this.fRemoteConnection.getCommandShell(1);
        } else {
            minfo = MachineManager.initializeMachine(this.fRemoteConnection);
            ArrayList<String> shellCommand = new ArrayList<String>();
            shellCommand.add(minfo.shell);
            shellCommand.add("-l");
            IRemoteProcessBuilder processBuilder = this.fRemoteConnection.getProcessBuilder(shellCommand);
            this.fProcess = processBuilder.start(1);
        }
        remoteConnector.setInputStream(this.fProcess.getInputStream());
        this.fControl.setState(TerminalState.CONNECTED);
        this.fControl.setTerminalTitle(this.fRemoteConnection.getName());
        OutputStream outputStream = this.fProcess.getOutputStream();
        remoteConnector.setOutputStream(outputStream);
        MachineManager.setOutputStream(this.fRemoteConnection.getAddress(), outputStream);
        String startup = this.getDefault(preferenceStore.getString(Messages.SHELL_STARTUP_COMMAND), "export PTP_TERM=1");
        if (minfo != null) {
            if (minfo.isCsh) {
                startup = startup.replaceFirst("export\\s+(\\w+)=", "setenv $1 ");
            } else if (minfo.isBash) {
                startup = startup.replaceFirst("setenv\\s+(\\w+)\\s+", "export $1=");
            }
        }
        outputStream.write((String.valueOf(startup) + "\n").getBytes());
        outputStream.flush();
    }
}

