/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.factory;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.profiling.launch.RemoteEnvProxyManager;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;

public abstract class LinuxtoolsProcessFactory {
    private static final String PATH = "PATH";
    private static final String PATH_EQUAL = "PATH=";
    private static final String SEPARATOR = ":";

    private String getEnvpPath(String[] envp) {
        if (envp == null) {
            return null;
        }
        String[] stringArray = envp;
        int n = envp.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            if (env.startsWith(PATH_EQUAL)) {
                return env.substring(PATH_EQUAL.length());
            }
            ++n2;
        }
        return null;
    }

    protected String[] updateEnvironment(String[] envp, IProject project) {
        String systemPath;
        String ltPath = LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project);
        String envpPath = this.getEnvpPath(envp);
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (project != null) {
            try {
                envMap.putAll(((RemoteEnvProxyManager)RemoteEnvProxyManager.class.newInstance()).getEnv(project));
            }
            catch (IllegalAccessException | InstantiationException | CoreException e) {
                e.printStackTrace();
            }
        }
        if (!envMap.isEmpty()) {
            systemPath = (String)envMap.get(PATH);
            if (systemPath == null && (systemPath = System.getenv(PATH)) != null) {
                envMap.put(PATH, systemPath);
            }
        } else {
            envMap.putAll(System.getenv());
            systemPath = (String)envMap.get(PATH);
        }
        StringBuffer newPath = new StringBuffer();
        newPath.append(PATH_EQUAL);
        if (ltPath != null && !ltPath.isEmpty()) {
            newPath.append(ltPath);
            newPath.append(SEPARATOR);
        }
        if (envpPath != null && !envpPath.isEmpty()) {
            newPath.append(envpPath);
            newPath.append(SEPARATOR);
        }
        if (systemPath != null && !systemPath.isEmpty()) {
            newPath.append(systemPath);
        }
        if (newPath.length() > PATH_EQUAL.length()) {
            envMap.put(PATH, newPath.substring(PATH_EQUAL.length()));
        }
        if (envp != null) {
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (!var.startsWith(PATH_EQUAL)) {
                    int splitIndex = var.indexOf(61);
                    envMap.put(var.substring(0, splitIndex), var.substring(splitIndex + 1));
                }
                ++n2;
            }
        }
        Set keySet = envMap.keySet();
        String[] newEnvp = new String[keySet.size()];
        int i = 0;
        for (String key : keySet) {
            if (!key.startsWith(PATH_EQUAL)) {
                newEnvp[i] = String.valueOf(key) + "=" + (String)envMap.get(key);
            }
            ++i;
        }
        return newEnvp;
    }
}

