/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.internal.ui.DeferredFileStore;
import org.eclipse.remote.internal.ui.DeferredFileStoreComparer;
import org.eclipse.remote.internal.ui.PendingUpdateAdapter;
import org.eclipse.remote.internal.ui.RemoteContentProvider;
import org.eclipse.remote.internal.ui.RemoteResourceComparator;
import org.eclipse.remote.internal.ui.RemoteTreeViewer;
import org.eclipse.remote.internal.ui.RemoteUIImages;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RemoteResourceBrowserWidget
extends Composite {
    public static final int FILE_BROWSER = 1;
    public static final int DIRECTORY_BROWSER = 2;
    public static final int SHOW_LOCAL_SELECTION = 4;
    public static final int SHOW_HIDDEN_CHECKBOX = 16;
    public static final int SHOW_NEW_FOLDER_BUTTON = 32;
    public static final int SHOW_CONNECTIONS = 64;
    private static final int minimumWidth = 200;
    private static final int heightHint = 300;
    private RemoteTreeViewer fTreeViewer;
    private Text fRemotePathText;
    private Button fUpButton;
    private Button fNewFolderButton;
    private Button fShowHiddenButton;
    private RemoteConnectionWidget fRemoteConnectionWidget;
    private String fDialogTitle;
    private String fDialogLabel;
    private boolean fShowHidden;
    private final List<IFileStore> fResources = new ArrayList<IFileStore>();
    private String fInitialPath;
    private IPath fRootPath;
    private IRemoteFileManager fFileMgr;
    private IRemoteConnection fConnection;
    private final ListenerList fSelectionListeners = new ListenerList();
    private int fOptionFlags = 49;
    private IRunnableContext fRunnableContext;

    public RemoteResourceBrowserWidget(Composite parent, int style, int flags) {
        super(parent, style);
        this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        if (flags != 0) {
            this.fOptionFlags = flags;
        }
        this.setType();
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Composite mainComp = new Composite((Composite)this, 0);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setLayout((Layout)new GridLayout(1, false));
        if ((this.fOptionFlags & 0x40) != 0) {
            this.fRemoteConnectionWidget = new RemoteConnectionWidget(mainComp, 0, "", (this.fOptionFlags & 4) == 0 ? RemoteConnectionWidget.FLAG_NO_LOCAL_SELECTION : 0);
            this.fRemoteConnectionWidget.setLayoutData(new GridData(4, 4, true, false));
            this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RemoteResourceBrowserWidget.this.connectionSelected();
                    RemoteResourceBrowserWidget.this.updateEnablement();
                    RemoteResourceBrowserWidget.this.notifySelectionChangedListeners(new SelectionChangedEvent((ISelectionProvider)RemoteResourceBrowserWidget.this.fTreeViewer, new ISelection(){

                        public boolean isEmpty() {
                            return true;
                        }
                    }));
                }
            });
        }
        Composite textComp = new Composite(mainComp, 0);
        layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        textComp.setLayout((Layout)layout);
        textComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(textComp, 0);
        label.setText(this.fDialogLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fRemotePathText = new Text(textComp, 2052);
        this.fRemotePathText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RemoteResourceBrowserWidget.this.fRemotePathText.setSelection(RemoteResourceBrowserWidget.this.fRemotePathText.getText().length());
                RemoteResourceBrowserWidget.this.setRoot(RemoteResourceBrowserWidget.this.fRemotePathText.getText());
            }
        });
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.fRemotePathText.setLayoutData((Object)gd);
        this.fUpButton = new Button(textComp, 0x800008);
        this.fUpButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fUpButton.setImage(RemoteUIImages.get("org.eclipse.remote.ui.elcl16.up_nav.gif"));
        this.fUpButton.setToolTipText(Messages.RemoteResourceBrowser_UpOneLevel);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RemoteResourceBrowserWidget.this.fRootPath.isRoot()) {
                    RemoteResourceBrowserWidget.this.setRoot(RemoteResourceBrowserWidget.this.fRootPath.removeLastSegments(1).toOSString());
                }
            }
        });
        if ((this.fOptionFlags & 0x20) != 0) {
            this.fNewFolderButton = new Button(textComp, 0x800008);
            this.fNewFolderButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fNewFolderButton.setImage(RemoteUIImages.get("org.eclipse.remote.ui.elcl16.new_folder.gif"));
            this.fNewFolderButton.setToolTipText(Messages.RemoteResourceBrowser_NewFolder);
            this.fNewFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    block6: {
                        block5: {
                            Object[] children;
                            DeferredFileStore element;
                            String path;
                            String newPath;
                            TreePath treePath;
                            TreePath[] treePaths;
                            ISelection selection = RemoteResourceBrowserWidget.this.fTreeViewer.getSelection();
                            if (selection.isEmpty()) break block5;
                            if (!(selection instanceof TreeSelection) || (treePaths = ((TreeSelection)selection).getPaths()).length <= 0 || !((treePath = treePaths[0]).getLastSegment() instanceof DeferredFileStore) || (newPath = RemoteResourceBrowserWidget.this.createNewFolder(path = (element = (DeferredFileStore)treePath.getLastSegment()).getFileStore().toURI().getPath())) == null) break block6;
                            RemoteResourceBrowserWidget.this.fTreeViewer.expandToLevel(element, 1);
                            RemoteResourceBrowserWidget.this.fTreeViewer.refresh(element);
                            Object[] objectArray = children = element.getChildren(null);
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object child = objectArray[n2];
                                if (child instanceof DeferredFileStore && newPath.equals(((DeferredFileStore)child).getFileStore().getName())) {
                                    RemoteResourceBrowserWidget.this.fTreeViewer.deferSelection((IStructuredSelection)new StructuredSelection(child));
                                }
                                ++n2;
                            }
                            break block6;
                        }
                        DeferredFileStore root = (DeferredFileStore)RemoteResourceBrowserWidget.this.fTreeViewer.getInput();
                        String path = root.getFileStore().toURI().getPath();
                        String newPath = RemoteResourceBrowserWidget.this.createNewFolder(path);
                        if (newPath != null) {
                            Object[] children;
                            RemoteResourceBrowserWidget.this.fTreeViewer.refresh();
                            RemoteResourceBrowserWidget.this.fTreeViewer.getTree().setFocus();
                            Object[] objectArray = children = root.getChildren(null);
                            int n = children.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Object child = objectArray[n3];
                                if (child instanceof DeferredFileStore && newPath.equals(((DeferredFileStore)child).getFileStore().getName())) {
                                    RemoteResourceBrowserWidget.this.fTreeViewer.deferSelection((IStructuredSelection)new StructuredSelection(child));
                                }
                                ++n3;
                            }
                        }
                    }
                }
            });
        } else {
            gd = new GridData(16384, 0x1000000, false, false);
            gd.horizontalSpan = 2;
            this.fUpButton.setLayoutData((Object)gd);
        }
        this.fTreeViewer = (style & 2) == 2 ? new RemoteTreeViewer(mainComp, 2050) : new RemoteTreeViewer(mainComp, 2052);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = Math.max(parent.getSize().y, 300);
        this.fTreeViewer.getTree().setLayoutData((Object)gd);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setComparer(new DeferredFileStoreComparer());
        this.fTreeViewer.setComparator(new RemoteResourceComparator());
        this.fTreeViewer.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    RemoteResourceBrowserWidget.this.fResources.clear();
                    Object[] objectArray = ss.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object currentSelection = objectArray[n2];
                        if (currentSelection instanceof DeferredFileStore) {
                            IFileStore store = ((DeferredFileStore)currentSelection).getFileStore();
                            RemoteResourceBrowserWidget.this.fResources.add(store);
                        }
                        ++n2;
                    }
                    if (RemoteResourceBrowserWidget.this.fResources.size() > 0) {
                        RemoteResourceBrowserWidget.this.fRemotePathText.setText(((IFileStore)RemoteResourceBrowserWidget.this.fResources.get(0)).toURI().getPath());
                    }
                    RemoteResourceBrowserWidget.this.updateEnablement();
                    RemoteResourceBrowserWidget.this.notifySelectionChangedListeners(event);
                }
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object o = s.getFirstElement();
                if (RemoteResourceBrowserWidget.this.fTreeViewer.isExpandable(o)) {
                    RemoteResourceBrowserWidget.this.fTreeViewer.setExpandedState(o, !RemoteResourceBrowserWidget.this.fTreeViewer.getExpandedState(o));
                }
            }
        });
        if (this.fOptionFlags == 2) {
            this.fTreeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof DeferredFileStore) {
                        return ((DeferredFileStore)element).isContainer();
                    }
                    return element instanceof PendingUpdateAdapter;
                }
            });
        }
        if ((this.fOptionFlags & 0x10) != 0) {
            this.fShowHiddenButton = new Button(mainComp, 32);
            this.fShowHiddenButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fShowHiddenButton.setText(Messages.RemoteResourceBrowser_Show_hidden_files);
            this.fShowHiddenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteResourceBrowserWidget.this.fShowHidden = RemoteResourceBrowserWidget.this.fShowHiddenButton.getSelection();
                    RemoteResourceBrowserWidget.this.setRoot(RemoteResourceBrowserWidget.this.fRootPath.toString());
                }
            });
        }
        this.updateEnablement();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    private boolean changeInput(IRemoteConnection conn) {
        if (conn == null) {
            this.setRoot(null);
            return true;
        }
        IRemoteUIConnectionManager uiMgr = RemoteUIServices.getRemoteUIServices(conn.getRemoteServices()).getUIConnectionManager();
        if (uiMgr != null) {
            uiMgr.openConnectionWithProgress(this.getShell(), this.getRunnableContext(), conn);
        }
        if (!conn.isOpen()) {
            return false;
        }
        this.fFileMgr = conn.getFileManager();
        if (this.fFileMgr != null) {
            String cwd = conn.getWorkingDirectory();
            IPath initial = this.findInitialPath(cwd, this.fInitialPath);
            this.setRoot(initial.toString());
            this.fConnection = conn;
            return true;
        }
        return false;
    }

    private void connectionSelected() {
        IRemoteConnection conn = this.fRemoteConnectionWidget.getConnection();
        if (!this.changeInput(conn)) {
            this.fRemoteConnectionWidget.setConnection(this.fConnection);
        }
    }

    private String createNewFolder(final String parent) {
        final String[] name = new String[]{null};
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                    String baseName = "newfolder";
                    IFileStore path = RemoteResourceBrowserWidget.this.fConnection.getFileManager().getResource(parent);
                    IFileStore child = path.getChild(baseName);
                    int count = 1;
                    try {
                        while (!progress.isCanceled() && child.fetchInfo(0, (IProgressMonitor)progress.newChild(1)).exists()) {
                            progress.setWorkRemaining(10);
                            child = path.getChild(String.valueOf(baseName) + " (" + count++ + ")");
                        }
                        if (!progress.isCanceled()) {
                            child.mkdir(4, (IProgressMonitor)progress.newChild(10));
                            name[0] = child.getName();
                        }
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)RemoteResourceBrowserWidget.this.getShell(), (String)Messages.RemoteResourceBrowserWidget_New_Folder, (String)Messages.RemoteResourceBrowserWidget_Unable_to_create_new_folder, (IStatus)e.getStatus());
                    }
                }
            };
            this.getRunnableContext().run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return name[0];
    }

    private IPath findInitialPath(String cwd, String initialPath) {
        if (initialPath != null) {
            Path path = new Path(initialPath);
            if (!path.isAbsolute()) {
                path = new Path(cwd).append((IPath)path);
            }
            if (this.fFileMgr.getResource(path.toString()).fetchInfo().exists()) {
                return path;
            }
        }
        return new Path(cwd);
    }

    public IRemoteConnection getConnection() {
        return this.fConnection;
    }

    public List<IFileStore> getResources() {
        return this.fResources;
    }

    public IRunnableContext getRunnableContext() {
        if (this.fRunnableContext == null) {
            return new ProgressMonitorDialog(this.getShell());
        }
        return this.fRunnableContext;
    }

    private void notifySelectionChangedListeners(SelectionChangedEvent e) {
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(e);
            ++n2;
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteConnection connection) {
        this.changeInput(connection);
        if (this.fRemoteConnectionWidget != null) {
            this.fRemoteConnectionWidget.setConnection(connection);
        }
        this.updateEnablement();
    }

    public void setInitialPath(String path) {
        this.fInitialPath = path;
        this.updateEnablement();
    }

    private void setRoot(String path) {
        this.fResources.clear();
        this.fRootPath = null;
        if (path == null) {
            this.fTreeViewer.setInput(null);
        } else if (this.fFileMgr != null) {
            IFileStore root = this.fFileMgr.getResource(path);
            this.fTreeViewer.setInput(new DeferredFileStore(root, !this.fShowHidden));
            this.fRemotePathText.setText(path);
            this.fRemotePathText.setSelection(this.fRemotePathText.getText().length());
            this.fResources.add(root);
            this.fRootPath = new Path(path);
        }
    }

    public void setRunnableContext(IRunnableContext context) {
        this.fRunnableContext = context;
    }

    public void setTitle(String title) {
        Shell shell;
        this.fDialogTitle = title;
        if (this.fDialogTitle == null) {
            this.fDialogTitle = "";
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setText(this.fDialogTitle);
        }
    }

    public void setType() {
        if ((this.fOptionFlags & 2) == 0) {
            this.fDialogLabel = Messages.RemoteResourceBrowser_fileLabel;
            this.setTitle(Messages.RemoteResourceBrowser_fileTitle);
        } else if ((this.fOptionFlags & 1) == 0) {
            this.fDialogLabel = Messages.RemoteResourceBrowser_directoryLabel;
            this.setTitle(Messages.RemoteResourceBrowser_directoryTitle);
        } else {
            this.fDialogLabel = Messages.RemoteResourceBrowser_resourceLabel;
            this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        }
    }

    private void updateEnablement() {
        boolean connectionOpen;
        boolean upEnabled = false;
        boolean newFolderEnabled = false;
        boolean bl = connectionOpen = this.fConnection != null && this.fConnection.isOpen();
        if (connectionOpen && this.fResources.size() == 1) {
            IFileStore store = this.fResources.get(0);
            if (store.fetchInfo().isDirectory()) {
                newFolderEnabled = true;
            }
            if (store.getParent() != null) {
                upEnabled = true;
            }
        }
        if (this.fUpButton != null) {
            this.fUpButton.setEnabled(upEnabled);
        }
        if (this.fNewFolderButton != null) {
            this.fNewFolderButton.setEnabled(newFolderEnabled);
        }
        if (this.fRemotePathText != null) {
            this.fRemotePathText.setEnabled(connectionOpen);
        }
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getTree().setEnabled(connectionOpen);
        }
        if (this.fShowHiddenButton != null) {
            this.fShowHiddenButton.setEnabled(connectionOpen);
        }
    }
}

