/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.editor.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.ptp.internal.rdt.editor.preferences.PreferenceMessages;

public class HeaderFooterProposalProvider
implements IContentProposalProvider {
    public static final String DATE = "<date>";
    public static final String TIME = "<time>";
    public static final String FILE = "<file>";
    private List<HeaderFooterProposalPair> _list;

    public IContentProposal[] getProposals(String text, int position) {
        this.init();
        ArrayList<ContentProposal> result = new ArrayList<ContentProposal>();
        String prefix = text.substring(0, position).trim();
        for (HeaderFooterProposalPair pair : this._list) {
            if (!pair._var.startsWith(prefix)) continue;
            result.add(new ContentProposal(pair._var, pair._var, pair._description, position + pair._var.length() - prefix.length()));
        }
        return result.toArray(new IContentProposal[result.size()]);
    }

    private void init() {
        if (this._list == null) {
            this._list = new ArrayList<HeaderFooterProposalPair>();
            this._list.add(new HeaderFooterProposalPair("<page>", PreferenceMessages.PageNumber));
            this._list.add(new HeaderFooterProposalPair(DATE, PreferenceMessages.CurrentDate));
            this._list.add(new HeaderFooterProposalPair(TIME, PreferenceMessages.CurrentTime));
            this._list.add(new HeaderFooterProposalPair(FILE, PreferenceMessages.FileName));
            Collections.sort(this._list);
        }
    }

    class HeaderFooterProposalPair
    implements Comparable<HeaderFooterProposalPair> {
        String _var;
        String _description;

        public HeaderFooterProposalPair(String var, String description) {
            this._var = var;
            this._description = description;
        }

        @Override
        public int compareTo(HeaderFooterProposalPair o) {
            return this._var.compareTo(o._var);
        }
    }
}

