/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumeration
extends PDOMCPPBinding
implements IPDOMCPPEnumType,
IPDOMMemberOwner {
    private static final int OFFSET_ENUMERATOR_LIST = 32;
    private static final int OFFSET_MIN_VALUE = 36;
    private static final int OFFSET_MAX_VALUE = 44;
    private static final int OFFSET_FIXED_TYPE = 52;
    private static final int OFFSET_FLAGS = 58;
    protected static final int RECORD_SIZE = 59;
    private Long fMinValue;
    private Long fMaxValue;
    private volatile IType fFixedType = ProblemBinding.NOT_INITIALIZED;
    private PDOMCPPEnumScope fScope;

    public PDOMCPPEnumeration(PDOMLinkage linkage, PDOMNode parent, ICPPEnumeration enumeration) throws CoreException {
        super(linkage, parent, enumeration.getNameCharArray());
        this.storeProperties(enumeration);
    }

    public PDOMCPPEnumeration(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        this.storeProperties((ICPPEnumeration)newBinding);
    }

    private void storeProperties(ICPPEnumeration enumeration) throws CoreException {
        Database db = this.getDB();
        db.putByte(this.record + 58L, enumeration.isScoped() ? (byte)1 : 0);
        ((PDOMLinkage)this.getLinkage()).storeType(this.record + 52L, enumeration.getFixedType());
        if (enumeration instanceof ICPPInternalBinding && ((ICPPInternalBinding)((Object)enumeration)).getDefinition() != null) {
            long minValue = enumeration.getMinValue();
            long maxValue = enumeration.getMaxValue();
            db.putLong(this.record + 36L, minValue);
            db.putLong(this.record + 44L, maxValue);
            this.fMinValue = minValue;
            this.fMaxValue = maxValue;
        }
    }

    @Override
    protected int getRecordSize() {
        return 59;
    }

    @Override
    public int getNodeType() {
        return 15;
    }

    @Override
    public IEnumerator[] getEnumerators() {
        return PDOMCPPEnumScope.getEnumerators(this);
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPEnumScope.acceptViaCache(this, visitor);
    }

    @Override
    public void addChild(PDOMNode node) throws CoreException {
        if (node instanceof PDOMCPPEnumerator) {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L);
            list.addMember(node);
            PDOMCPPEnumScope.updateCache(this, (IPDOMCPPEnumerator)((Object)node));
        }
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof IEnumeration) {
            IEnumeration etype = (IEnumeration)type;
            char[] nchars = etype.getNameCharArray();
            if (nchars.length == 0) {
                nchars = ASTTypeUtil.createNameForAnonymous(etype);
            }
            if (nchars == null || !CharArrayUtils.equals(nchars, this.getNameCharArray())) {
                return false;
            }
            return SemanticUtil.isSameOwner(this.getOwner(), etype.getOwner());
        }
        return false;
    }

    @Override
    public long getMinValue() {
        if (this.fMinValue != null) {
            return this.fMinValue;
        }
        long minValue = 0L;
        try {
            minValue = this.getDB().getLong(this.record + 36L);
        }
        catch (CoreException coreException) {}
        this.fMinValue = minValue;
        return minValue;
    }

    @Override
    public long getMaxValue() {
        if (this.fMaxValue != null) {
            return this.fMaxValue;
        }
        long maxValue = 0L;
        try {
            maxValue = this.getDB().getLong(this.record + 44L);
        }
        catch (CoreException coreException) {}
        this.fMaxValue = maxValue;
        return maxValue;
    }

    @Override
    public Object clone() {
        throw new IllegalArgumentException("Enums must not be cloned");
    }

    @Override
    public boolean isScoped() {
        try {
            return this.getDB().getByte(this.record + 58L) != 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public IType getFixedType() {
        if (this.fFixedType == ProblemBinding.NOT_INITIALIZED) {
            this.fFixedType = this.loadFixedType();
        }
        return this.fFixedType;
    }

    private IType loadFixedType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 52L);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    @Override
    public ICPPScope asScope() {
        if (this.fScope == null) {
            this.fScope = new PDOMCPPEnumScope(this);
        }
        return this.fScope;
    }

    @Override
    public void loadEnumerators(final CharArrayMap<IPDOMCPPEnumerator> map) {
        try {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L);
            list.accept(new IPDOMVisitor(){

                @Override
                public boolean visit(IPDOMNode node) throws CoreException {
                    if (node instanceof IPDOMCPPEnumerator) {
                        IPDOMCPPEnumerator item = (IPDOMCPPEnumerator)node;
                        map.put(item.getNameCharArray(), item);
                    }
                    return true;
                }

                @Override
                public void leave(IPDOMNode node) {
                }
            });
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
    }
}

