/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;

public class CPPASTUnaryExpression
extends ASTNode
implements ICPPASTUnaryExpression,
IASTAmbiguityParent {
    private int fOperator;
    private ICPPASTExpression fOperand;
    private IASTImplicitName[] fImplicitNames = null;
    private ICPPEvaluation fEvaluation;

    public CPPASTUnaryExpression() {
    }

    public CPPASTUnaryExpression(int operator, IASTExpression operand) {
        this.fOperator = operator;
        this.setOperand(operand);
    }

    @Override
    public CPPASTUnaryExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTUnaryExpression copy(IASTNode.CopyStyle style) {
        CPPASTUnaryExpression copy = new CPPASTUnaryExpression(this.fOperator, this.fOperand == null ? null : this.fOperand.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public int getOperator() {
        return this.fOperator;
    }

    @Override
    public void setOperator(int operator) {
        this.assertNotFrozen();
        this.fOperator = operator;
    }

    @Override
    public IASTExpression getOperand() {
        return this.fOperand;
    }

    @Override
    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.fOperand = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    public boolean isPostfixOperator() {
        return this.fOperator == 10 || this.fOperator == 9;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null || overload instanceof CPPImplicitFunction) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                operatorName.setOperator(true);
                operatorName.setBinding(overload);
                operatorName.computeOperatorOffsets(this.fOperand, this.isPostfixOperator());
                this.fImplicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.fImplicitNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTImplicitName name;
        int n;
        int n2;
        IASTImplicitName[] iASTImplicitNameArray;
        boolean isPostfix;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!(isPostfix = this.isPostfixOperator()) && action.shouldVisitImplicitNames) {
            iASTImplicitNameArray = this.getImplicitNames();
            n2 = iASTImplicitNameArray.length;
            n = 0;
            while (n < n2) {
                name = iASTImplicitNameArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.fOperand != null && !this.fOperand.accept(action)) {
            return false;
        }
        if (isPostfix && action.shouldVisitImplicitNames) {
            iASTImplicitNameArray = this.getImplicitNames();
            n2 = iASTImplicitNameArray.length;
            n = 0;
            while (n < n2) {
                name = iASTImplicitNameArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fOperand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fOperand = (ICPPASTExpression)other;
        }
    }

    @Override
    public ICPPFunction getOverload() {
        ICPPEvaluation eval = this.getEvaluation();
        if (eval instanceof EvalUnary) {
            return ((EvalUnary)eval).getOverload(this);
        }
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        IASTName name;
        if (this.fOperand == null) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation nestedEval = this.fOperand.getEvaluation();
        if (this.fOperator == 11) {
            return nestedEval;
        }
        if (nestedEval.isFunctionSet() && this.fOperator == 5) {
            return nestedEval;
        }
        IBinding addressOfQualifiedNameBinding = null;
        if (this.fOperator == 5 && this.fOperand instanceof IASTIdExpression && (name = ((IASTIdExpression)((Object)this.fOperand)).getName()) instanceof ICPPASTQualifiedName && (addressOfQualifiedNameBinding = name.resolveBinding()) instanceof IProblemBinding) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalUnary(this.fOperator, nestedEval, addressOfQualifiedNameBinding, this);
    }

    @Override
    public IType getExpressionType() {
        IType type = this.getEvaluation().getTypeOrFunctionSet(this);
        if (type instanceof FunctionSetType) {
            type = this.fOperand.getExpressionType();
            if (this.fOperator == 5) {
                ICPPMethod method;
                IBinding binding;
                IASTIdExpression idExpr;
                IASTName name;
                if (this.fOperand instanceof IASTIdExpression && (name = (idExpr = (IASTIdExpression)((Object)this.fOperand)).getName()) instanceof ICPPASTQualifiedName && (binding = name.resolveBinding()) instanceof ICPPMethod && !(method = (ICPPMethod)binding).isStatic()) {
                    return new CPPPointerToMemberType(method.getType(), method.getClassOwner(), false, false, false);
                }
                return new CPPPointerType(type);
            }
        }
        return type;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

