/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;

public class LongString
implements IString {
    private final Database db;
    private final long record;
    private int hash;
    private static final int LENGTH = 0;
    private static final int NEXT1 = 4;
    private static final int CHARS1 = 8;
    private static final int NUM_CHARS1 = 2043;
    private static final int NEXTN = 0;
    private static final int CHARSN = 4;
    private static final int NUM_CHARSN = 2045;

    public LongString(Database db, long record) {
        this.db = db;
        this.record = record;
    }

    public LongString(Database db, char[] chars, boolean useBytes) throws CoreException {
        int numChars1 = useBytes ? 4086 : 2043;
        int numCharsn = useBytes ? 4090 : 2045;
        this.db = db;
        this.record = db.malloc(4094);
        int length = chars.length;
        db.putInt(this.record, useBytes ? -length : length);
        Chunk chunk = db.getChunk(this.record);
        if (useBytes) {
            chunk.putCharsAsBytes(this.record + 8L, chars, 0, numChars1);
        } else {
            chunk.putChars(this.record + 8L, chars, 0, numChars1);
        }
        long lastNext = this.record + 4L;
        int start = numChars1;
        while (length - start > numCharsn) {
            long nextRecord = db.malloc(4094);
            db.putRecPtr(lastNext, nextRecord);
            chunk = db.getChunk(nextRecord);
            if (useBytes) {
                chunk.putCharsAsBytes(nextRecord + 4L, chars, start, numCharsn);
            } else {
                chunk.putChars(nextRecord + 4L, chars, start, numCharsn);
            }
            start += numCharsn;
            lastNext = nextRecord + 0L;
        }
        int remaining = length - start;
        long nextRecord = db.malloc(4 + (useBytes ? remaining : remaining * 2));
        db.putRecPtr(lastNext, nextRecord);
        chunk = db.getChunk(nextRecord);
        if (useBytes) {
            chunk.putCharsAsBytes(nextRecord + 4L, chars, start, remaining);
        } else {
            chunk.putChars(nextRecord + 4L, chars, start, remaining);
        }
    }

    @Override
    public long getRecord() {
        return this.record;
    }

    @Override
    public char[] getChars() throws CoreException {
        int length = this.db.getInt(this.record + 0L);
        boolean useBytes = length < 0;
        int numChars1 = 2043;
        int numCharsn = 2045;
        if (useBytes) {
            length = -length;
            numChars1 *= 2;
            numCharsn *= 2;
        }
        char[] chars = new char[length];
        long p = this.record;
        Chunk chunk = this.db.getChunk(p);
        if (useBytes) {
            chunk.getCharsFromBytes(p + 8L, chars, 0, numChars1);
        } else {
            chunk.getChars(p + 8L, chars, 0, numChars1);
        }
        int start = numChars1;
        p = this.record + 4L;
        while (start < length) {
            p = this.db.getRecPtr(p);
            int partLen = Math.min(length - start, numCharsn);
            chunk = this.db.getChunk(p);
            if (useBytes) {
                chunk.getCharsFromBytes(p + 4L, chars, start, partLen);
            } else {
                chunk.getChars(p + 4L, chars, start, partLen);
            }
            start += partLen;
            p += 0L;
        }
        return chars;
    }

    @Override
    public void delete() throws CoreException {
        int length = this.db.getInt(this.record + 0L);
        boolean useBytes = length < 0;
        int numChars1 = 2043;
        int numCharsn = 2045;
        if (useBytes) {
            length = -length;
            numChars1 *= 2;
            numCharsn *= 2;
        }
        long nextRecord = this.db.getRecPtr(this.record + 4L);
        this.db.free(this.record);
        length -= numChars1;
        while (length > numCharsn) {
            length -= numCharsn;
            long nextnext = this.db.getRecPtr(nextRecord + 0L);
            this.db.free(nextRecord);
            nextRecord = nextnext;
        }
        this.db.free(nextRecord);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof LongString) {
                LongString lstr = (LongString)obj;
                if (this.db == lstr.db && this.record == lstr.record) {
                    return true;
                }
                if (this.compare(lstr, true) != 0) return false;
                return true;
            }
            if (obj instanceof char[]) {
                if (this.compare((char[])obj, true) != 0) return false;
                return true;
            }
            if (!(obj instanceof String)) return false;
            if (this.compare((String)obj, true) != 0) return false;
            return true;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            try {
                char[] chars = this.getChars();
                int len = chars.length;
                int i = 0;
                while (i < len) {
                    h = 31 * h + chars[i];
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            this.hash = h;
        }
        return h;
    }

    @Override
    public int compare(IString string, boolean caseSensitive) throws CoreException {
        return ShortString.compare(this.getChars(), string.getChars(), caseSensitive);
    }

    @Override
    public int compare(String other, boolean caseSensitive) throws CoreException {
        return ShortString.compare(this.getChars(), other.toCharArray(), caseSensitive);
    }

    @Override
    public int compare(char[] other, boolean caseSensitive) throws CoreException {
        return ShortString.compare(this.getChars(), other, caseSensitive);
    }

    @Override
    public int compareCompatibleWithIgnoreCase(IString string) throws CoreException {
        return ShortString.compareCompatibleWithIgnoreCase(this.getChars(), string.getChars());
    }

    @Override
    public int comparePrefix(char[] other, boolean caseSensitive) throws CoreException {
        return ShortString.comparePrefix(this.getChars(), other, caseSensitive);
    }

    @Override
    public String getString() throws CoreException {
        return new String(this.getChars());
    }

    @Override
    public int compareCompatibleWithIgnoreCase(char[] other) throws CoreException {
        return ShortString.compareCompatibleWithIgnoreCase(this.getChars(), other);
    }
}

