/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.internal.core.messages.Messages;
import org.osgi.framework.BundleContext;

public class PTPCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.core";
    private static PTPCorePlugin fPlugin;
    private ResourceBundle resourceBundle;

    public static PTPCorePlugin getDefault() {
        return fPlugin;
    }

    public static String getUniqueIdentifier() {
        if (PTPCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, Messages.PTPCorePlugin_0, e));
    }

    public PTPCorePlugin() {
        fPlugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setDefaultLaunchDelegates();
        ResourcesPlugin.getWorkspace().addSaveParticipant(PTPCorePlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void saving(ISaveContext saveContext) throws CoreException {
                Preferences.savePreferences(PTPCorePlugin.getUniqueIdentifier());
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext saveContext) {
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Preferences.savePreferences(PTPCorePlugin.getUniqueIdentifier());
            ResourcesPlugin.getWorkspace().removeSaveParticipant(PTPCorePlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
            fPlugin = null;
        }
    }

    private void setDefaultLaunchDelegates() {
        block10: {
            ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
            HashSet<String> debugSet = new HashSet<String>();
            debugSet.add("debug");
            ILaunchConfigurationType localCfg = launchMgr.getLaunchConfigurationType("org.eclipse.ptp.launch.parallelLaunch");
            if (localCfg != null) {
                int n;
                block9: {
                    try {
                        ILaunchDelegate[] delegates;
                        if (localCfg.getPreferredDelegate(debugSet) != null) break block9;
                        ILaunchDelegate[] iLaunchDelegateArray = delegates = localCfg.getDelegates(debugSet);
                        n = delegates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                            if ("org.eclipse.ptp.rm.launch.parallelLaunch".equals(delegate.getId())) {
                                localCfg.setPreferredDelegate(debugSet, delegate);
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                HashSet<String> runSet = new HashSet<String>();
                runSet.add("run");
                try {
                    ILaunchDelegate[] delegates;
                    if (localCfg.getPreferredDelegate(runSet) != null) break block10;
                    ILaunchDelegate[] iLaunchDelegateArray = delegates = localCfg.getDelegates(runSet);
                    int n3 = delegates.length;
                    n = 0;
                    while (n < n3) {
                        ILaunchDelegate delegate = iLaunchDelegateArray[n];
                        if ("org.eclipse.ptp.rm.launch.parallelLaunch".equals(delegate.getId())) {
                            localCfg.setPreferredDelegate(runSet, delegate);
                            break;
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

