/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.core.exception.UnableToForwardPortException;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.messages.Messages;
import org.eclipse.remote.internal.core.services.local.LocalConnectionWorkingCopy;
import org.eclipse.remote.internal.core.services.local.LocalFileManager;
import org.eclipse.remote.internal.core.services.local.LocalProcessBuilder;

public class LocalConnection
implements IRemoteConnection {
    private final String fName = "Local";
    private final String fAddress = Messages.LocalConnection_1;
    private final String fUsername = System.getProperty("user.name");
    private boolean fConnected = true;
    private IPath fWorkingDir = null;
    private final IRemoteFileManager fFileMgr = new LocalFileManager();
    private final IRemoteConnection fConnection = this;
    private final IRemoteServices fRemoteServices;
    private final ListenerList fListeners = new ListenerList();

    public LocalConnection(IRemoteServices services) {
        this.fRemoteServices = services;
    }

    @Override
    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void close() {
        if (this.fConnected) {
            this.fConnected = false;
            this.fireConnectionChangeEvent(1);
        }
    }

    @Override
    public int compareTo(IRemoteConnection connection) {
        return this.getName().compareTo(connection.getName());
    }

    @Override
    public void fireConnectionChangeEvent(final int type) {
        IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

            @Override
            public IRemoteConnection getConnection() {
                return LocalConnection.this.fConnection;
            }

            @Override
            public int getType() {
                return type;
            }
        };
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }

    @Override
    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public String getAddress() {
        return this.fAddress;
    }

    @Override
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>();
    }

    @Override
    public IRemoteProcess getCommandShell(int flags) throws IOException {
        throw new IOException("Not currently implemented");
    }

    @Override
    public Map<String, String> getEnv() {
        return System.getenv();
    }

    @Override
    public String getEnv(String name) {
        return System.getenv(name);
    }

    @Override
    public IRemoteFileManager getFileManager() {
        return this.fFileMgr;
    }

    @Override
    public String getName() {
        return "Local";
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new LocalProcessBuilder(command);
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new LocalProcessBuilder(command);
    }

    @Override
    public String getProperty(String key) {
        switch (key) {
            case "os.name": {
                return RemoteCorePlugin.getDefault().getBundle().getBundleContext().getProperty("osgi.os");
            }
            case "os.arch": {
                return RemoteCorePlugin.getDefault().getBundle().getBundleContext().getProperty("osgi.arch");
            }
        }
        return System.getProperty(key);
    }

    @Override
    public IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    @Override
    public String getUsername() {
        return this.fUsername;
    }

    @Override
    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return new LocalConnectionWorkingCopy(this);
    }

    @Override
    public String getWorkingDirectory() {
        if (this.fWorkingDir == null) {
            String cwd = System.getProperty("user.home");
            if (cwd == null) {
                cwd = System.getProperty("user.dir");
            }
            this.fWorkingDir = cwd == null ? Path.ROOT : new Path(cwd);
        }
        return this.fWorkingDir.toString();
    }

    @Override
    public boolean isOpen() {
        return this.fConnected;
    }

    @Override
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.fConnected) {
            this.fConnected = true;
            this.fireConnectionChangeEvent(2);
        }
    }

    @Override
    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void removeLocalPortForwarding(int port) throws RemoteConnectionException {
    }

    @Override
    public void removeRemotePortForwarding(int port) throws RemoteConnectionException {
    }

    @Override
    public void setWorkingDirectory(String pathStr) {
        Path path = new Path(pathStr);
        if (path.isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    @Override
    public boolean supportsTCPPortForwarding() {
        return false;
    }
}

