/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITranslationUnitHolder;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.AddBlockCommentAction;
import org.eclipse.cdt.internal.ui.actions.FindWordAction;
import org.eclipse.cdt.internal.ui.actions.FoldingActionGroup;
import org.eclipse.cdt.internal.ui.actions.GoToNextPreviousMemberAction;
import org.eclipse.cdt.internal.ui.actions.GotoNextBookmarkAction;
import org.eclipse.cdt.internal.ui.actions.IndentAction;
import org.eclipse.cdt.internal.ui.actions.RemoveBlockCommentAction;
import org.eclipse.cdt.internal.ui.actions.StructureSelectEnclosingAction;
import org.eclipse.cdt.internal.ui.actions.StructureSelectHistoryAction;
import org.eclipse.cdt.internal.ui.actions.StructureSelectNextAction;
import org.eclipse.cdt.internal.ui.actions.StructureSelectPreviousAction;
import org.eclipse.cdt.internal.ui.actions.SurroundWithActionGroup;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CAnnotationIterator;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CDocumentSetupParticipant;
import org.eclipse.cdt.internal.ui.editor.CEditorErrorTickUpdater;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.CSourceViewerDecorationSupport;
import org.eclipse.cdt.internal.ui.editor.CTemplatesPage;
import org.eclipse.cdt.internal.ui.editor.ConstructedCEditorMessages;
import org.eclipse.cdt.internal.ui.editor.EclipsePreferencesAdapter;
import org.eclipse.cdt.internal.ui.editor.GotoMatchingBracketAction;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.IPostSaveListener;
import org.eclipse.cdt.internal.ui.editor.IndexUpdateRequestor;
import org.eclipse.cdt.internal.ui.editor.OverrideIndicatorManager;
import org.eclipse.cdt.internal.ui.editor.SelectionHistory;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.internal.ui.editor.SortLinesAction;
import org.eclipse.cdt.internal.ui.editor.ToggleCommentAction;
import org.eclipse.cdt.internal.ui.editor.ToggleSourceAndHeaderAction;
import org.eclipse.cdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.cdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.CPairMatcher;
import org.eclipse.cdt.internal.ui.text.CSourceViewerScalableConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.CWordIterator;
import org.eclipse.cdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.internal.ui.text.TabsToSpacesConverter;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.internal.ui.util.CUIHelp;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.cdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICEditor;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.actions.GenerateActionGroup;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.refactoring.actions.CRefactoringActionGroup;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.actions.TextSearchGroup;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CEditor
extends TextEditor
implements ICEditor,
ISelectionChangedListener,
ICReconcilingListener,
ITranslationUnitHolder {
    private IMarker fSyncProblemsViewMarker;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private long fErrorMessageTime;
    private static final long ERROR_MESSAGE_TIMEOUT = 1000L;
    protected CContentOutlinePage fOutlinePage;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fTextSearchGroup;
    private CRefactoringActionGroup fRefactoringActionGroup;
    private ActionGroup fOpenInViewGroup;
    private GenerateActionGroup fGenerateActionGroup;
    private SurroundWithActionGroup fSurroundWithActionGroup;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected CPairMatcher fBracketMatcher = new CPairMatcher(BRACKETS);
    private BracketInserter fBracketInserter = new BracketInserter();
    private CEditorErrorTickUpdater fCEditorErrorTickUpdater;
    public static final String SUB_WORD_NAVIGATION = "subWordNavigation";
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String INACTIVE_CODE_ENABLE = "inactiveCodeEnable";
    public static final String INACTIVE_CODE_COLOR = "inactiveCodeColor";
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    private static final String CLOSE_ANGULAR_BRACKETS = "closeAngularBrackets";
    private static final String CLOSE_BRACES = "closeBraces";
    private static final String TODO_TASK_TAGS = "org.eclipse.cdt.core.taskTags";
    protected ProjectionSupport fProjectionSupport;
    private ICFoldingStructureProvider fProjectionModelUpdater;
    private FoldingActionGroup fFoldingGroup;
    private ListenerList fReconcilingListeners = new ListenerList(1);
    private SemanticHighlightingManager fSemanticManager;
    private boolean fEnableScalablilityMode;
    private volatile boolean fIsReconciling;
    private CTemplatesPage fTemplatesPage;
    private SelectionHistory fSelectionHistory;
    private final IndexUpdateRequestor fIndexUpdateRequestor = new IndexUpdateRequestor();
    private final ListenerList fPostSaveListeners;
    private static final Set<String> angularIntroducers = new HashSet<String>();
    protected String fOutlinerContextMenuId;
    private Annotation[] fOccurrenceAnnotations = null;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkOverloadedOperatorOccurrences;
    private ISelection fForcedMarkOccurrencesSelection;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private OccurrencesAnnotationUpdaterJob fOccurrencesAnnotationUpdaterJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private OverrideIndicatorManager fOverrideIndicatorManager;

    static {
        angularIntroducers.add("template");
        angularIntroducers.add("vector");
        angularIntroducers.add("deque");
        angularIntroducers.add("list");
        angularIntroducers.add("slist");
        angularIntroducers.add("map");
        angularIntroducers.add("set");
        angularIntroducers.add("multimap");
        angularIntroducers.add("multiset");
        angularIntroducers.add("hash_map");
        angularIntroducers.add("hash_set");
        angularIntroducers.add("hash_multimap");
        angularIntroducers.add("hash_multiset");
        angularIntroducers.add("unordered_map");
        angularIntroducers.add("unordered_set");
        angularIntroducers.add("unordered_multimap");
        angularIntroducers.add("unordered_multiset");
        angularIntroducers.add("pair");
        angularIntroducers.add("tuple");
        angularIntroducers.add("include");
    }

    public CEditor() {
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setEditorContextMenuId("#CEditorContext");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.setOutlinerContextMenuId("#CEditorOutlinerContext");
        this.fCEditorErrorTickUpdater = new CEditorErrorTickUpdater(this);
        this.fPostSaveListeners = new ListenerList();
    }

    protected void initializeEditor() {
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (!(sourceViewer instanceof ISourceViewerExtension2)) {
            this.setPreferenceStore(this.createCombinedPreferenceStore(input));
            this.internalDoSetInput(input);
            this.updateScalabilityMode(input);
            return;
        }
        this.getDocumentProvider().connect((Object)input);
        try {
            this.getSourceViewerDecorationSupport(sourceViewer).uninstall();
            ((ISourceViewerExtension2)sourceViewer).unconfigure();
            this.setPreferenceStore(this.createCombinedPreferenceStore(input));
            this.updateScalabilityMode(input);
            sourceViewer.configure(this.getSourceViewerConfiguration());
            this.getSourceViewerDecorationSupport(sourceViewer).install(this.getPreferenceStore());
            this.internalDoSetInput(input);
        }
        finally {
            this.getDocumentProvider().disconnect((Object)input);
        }
    }

    private void internalDoSetInput(IEditorInput input) throws CoreException {
        IWorkingCopy element;
        ISourceViewer sourceViewer = this.getSourceViewer();
        CSourceViewer cSourceViewer = null;
        if (sourceViewer instanceof CSourceViewer) {
            cSourceViewer = (CSourceViewer)sourceViewer;
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (cSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.cdt.ui.editor.showSegments"))) {
            cSourceViewer.prepareDelayedProjection();
        }
        super.doSetInput(input);
        CEditor.setOutlinePageInput(this.fOutlinePage, input);
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.updateEditorImage((ICElement)this.getInputCElement());
        }
        if ((element = this.getInputCElement()) instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)element;
            this.fIndexUpdateRequestor.updateIndexInclusion(tu);
            this.fBracketMatcher.configure(tu.getLanguage());
        } else {
            this.fIndexUpdateRequestor.updateIndexInclusion(null);
            this.fBracketMatcher.configure(null);
        }
    }

    private void updateScalabilityMode(IEditorInput input) {
        int lines = this.getDocumentProvider().getDocument((Object)input).getNumberOfLines();
        boolean wasEnabled = this.fEnableScalablilityMode;
        boolean bl = this.fEnableScalablilityMode = lines > this.getPreferenceStore().getInt("scalability.numberOfLines");
        if (this.fEnableScalablilityMode && !wasEnabled && this.getPreferenceStore().getBoolean("scalability.detect")) {
            MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getSite().getShell(), CEditorMessages.Scalability_info, null, CEditorMessages.Scalability_message, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, CEditorMessages.Scalability_reappear, false){
                {
                    this.setShellStyle(0x4860 | 1.getDefaultOrientation());
                }

                protected void buttonPressed(int buttonId) {
                    PreferenceConstants.getPreferenceStore().setValue("scalability.detect", !this.getToggleState());
                    super.buttonPressed(buttonId);
                    if (buttonId == 2) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)CEditor.this.getSite().getShell(), (String)"org.eclipse.cdt.ui.preferences.CScalabilityPreferences", null, null);
                        dialog.open();
                    }
                }
            };
            dialog.setBlockOnOpen(false);
            dialog.open();
        }
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (!(sourceViewerConfiguration instanceof CSourceViewerConfiguration)) {
            CTextTools textTools = CUIPlugin.getDefault().getTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new CSourceViewerScalableConfiguration(textTools.getColorManager(), store, this, "___c_partitioning"));
        }
        if (this.getSourceViewer() instanceof CSourceViewer) {
            ((CSourceViewer)this.getSourceViewer()).setPreferenceStore(store);
        }
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fMarkOverloadedOperatorOccurrences = store.getBoolean("markOverloadedOperatorsOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public IWorkingCopy getInputCElement() {
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
    }

    public ITranslationUnit getTranslationUnit() {
        return this.getInputCElement();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        CEditor.setOutlinePageInputIfNotSame(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public Object getAdapter(Class adapterClass) {
        if (adapterClass.isAssignableFrom(IContentOutlinePage.class)) {
            return this.getOutlinePage();
        }
        if (adapterClass.isAssignableFrom(IShowInTargetList.class)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (adapterClass.isAssignableFrom(IShowInSource.class)) {
            ICElement ce = this.getElementAt(this.getSourceViewer().getSelectedRange().x, false);
            if (ce instanceof ITranslationUnit) {
                ce = null;
            }
            StructuredSelection selection = ce != null ? new StructuredSelection((Object)ce) : null;
            return new IShowInSource((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)CEditor.this.getEditorInput(), this.val$selection);
                }
            };
        }
        if (adapterClass.isAssignableFrom(ProjectionAnnotationModel.class)) {
            Object adapter;
            if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), adapterClass)) != null) {
                return adapter;
            }
        } else {
            if (adapterClass.isAssignableFrom(IContextProvider.class)) {
                return new CUIHelp.CUIHelpContextProvider(this);
            }
            if (adapterClass.isAssignableFrom(IGotoMarker.class)) {
                return new GotoMarkerAdapter();
            }
            if (adapterClass.isAssignableFrom(ITemplatesPage.class)) {
                if (this.fTemplatesPage == null) {
                    this.fTemplatesPage = new CTemplatesPage(this);
                }
                return this.fTemplatesPage;
            }
            if (adapterClass.isAssignableFrom(ITranslationUnitHolder.class)) {
                return this;
            }
        }
        return super.getAdapter(adapterClass);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            return;
        }
        if ("spacesForTabs".equals(property)) {
            return;
        }
        try {
            final AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            if (asv != null) {
                boolean newBooleanValue = false;
                Object newValue = event.getNewValue();
                if (newValue != null) {
                    newBooleanValue = Boolean.valueOf(newValue.toString());
                }
                if (CLOSE_BRACKETS.equals(property)) {
                    this.fBracketInserter.setCloseBracketsEnabled(newBooleanValue);
                    return;
                }
                if (CLOSE_ANGULAR_BRACKETS.equals(property)) {
                    this.fBracketInserter.setCloseAngularBracketsEnabled(newBooleanValue);
                    return;
                }
                if (CLOSE_BRACES.equals(property)) {
                    this.fBracketInserter.setCloseBracesEnabled(newBooleanValue);
                    return;
                }
                if (CLOSE_STRINGS.equals(property)) {
                    this.fBracketInserter.setCloseStringsEnabled(newBooleanValue);
                    return;
                }
                if ("hoverModifiers".equals(property)) {
                    this.updateHoverBehavior();
                }
                ((CSourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePropertyChangeEvent(event);
                if ("smart_tab".equals(property)) {
                    if (newBooleanValue) {
                        this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
                    } else {
                        this.removeActionActivationCode("IndentOnTab");
                    }
                    return;
                }
                if (TODO_TASK_TAGS.equals(event.getProperty())) {
                    ISourceViewer sourceViewer = this.getSourceViewer();
                    if (sourceViewer != null && this.affectsTextPresentation(event)) {
                        sourceViewer.invalidateTextPresentation();
                    }
                    return;
                }
                if (this.affectsOverrideIndicatorAnnotations(event)) {
                    if (this.isShowingOverrideIndicators()) {
                        if (this.fOverrideIndicatorManager == null) {
                            this.installOverrideIndicator(true);
                        }
                    } else if (this.fOverrideIndicatorManager != null) {
                        this.uninstallOverrideIndicator();
                    }
                    return;
                }
                if ("editor_folding_provider".equals(property)) {
                    if (this.fProjectionModelUpdater != null) {
                        this.fProjectionModelUpdater.uninstall();
                    }
                    this.fProjectionModelUpdater = CUIPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                    if (this.fProjectionModelUpdater != null) {
                        this.fProjectionModelUpdater.install(this, asv);
                    }
                    return;
                }
                if ("org.eclipse.cdt.core.formatter.tabulation.size".equals(property) || "org.eclipse.cdt.core.formatter.indentation.size".equals(property) || "org.eclipse.cdt.core.formatter.tabulation.char".equals(property)) {
                    StyledText textWidget = asv.getTextWidget();
                    int tabWidth = this.getSourceViewerConfiguration().getTabWidth((ISourceViewer)asv);
                    if (textWidget.getTabs() != tabWidth) {
                        textWidget.setTabs(tabWidth);
                    }
                    this.uninstallTabsToSpacesConverter();
                    if (this.isTabsToSpacesConversionEnabled()) {
                        this.installTabsToSpacesConverter();
                    } else {
                        this.updateIndentationMode();
                    }
                    return;
                }
                if ("markOccurrences".equals(property)) {
                    if (newBooleanValue != this.fMarkOccurrenceAnnotations) {
                        this.fMarkOccurrenceAnnotations = newBooleanValue;
                        if (!this.fMarkOccurrenceAnnotations) {
                            this.uninstallOccurrencesFinder();
                        } else {
                            this.installOccurrencesFinder(true);
                        }
                    }
                    return;
                }
                if ("stickyOccurrences".equals(property)) {
                    this.fStickyOccurrenceAnnotations = newBooleanValue;
                    return;
                }
                if ("markOverloadedOperatorsOccurrences".equals(property)) {
                    this.fMarkOverloadedOperatorOccurrences = newBooleanValue;
                    return;
                }
                if (SemanticHighlightings.affectsEnablement(this.getPreferenceStore(), event) || this.isEnableScalablilityMode() && "scalability.semanticHighlight".equals(property)) {
                    if (this.isSemanticHighlightingEnabled()) {
                        this.installSemanticHighlighting();
                        this.fSemanticManager.refresh();
                    } else {
                        this.uninstallSemanticHighlighting();
                    }
                    return;
                }
                if (this.isEnableScalablilityMode() && ("scalability.reconciler".equals(property) || "scalability.syntaxColor".equals(property))) {
                    BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CEditor.setOutlinePageInput(CEditor.this.fOutlinePage, CEditor.this.getEditorInput());
                            asv.unconfigure();
                            asv.configure(CEditor.this.getSourceViewerConfiguration());
                        }
                    });
                    return;
                }
                IContentAssistant c = asv.getContentAssistant();
                if (c instanceof ContentAssistant) {
                    ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                }
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
    }

    private void updateHoverBehavior() {
        String[] types;
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] stringArray = types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int[] nArray = stateMasks;
                    int n3 = stateMasks.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int stateMask = nArray[n4];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++n4;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++n2;
        }
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        ISourceReference element = this.computeHighlightRangeSourceReference();
        this.updateStatusLine();
        this.synchronizeOutlinePage();
        this.setSelection(element, false);
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getSelection().x);
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getSelection().x;
        }
        ICElement element = this.getElementAt(caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        return (ISourceReference)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICElement getElementAt(int offset, boolean reconcile) {
        IWorkingCopy unit = this.getInputCElement();
        if (unit != null) {
            try {
                if (reconcile) {
                    IWorkingCopy iWorkingCopy = unit;
                    synchronized (iWorkingCopy) {
                        unit.reconcile();
                    }
                    return unit.getElementAtOffset(offset);
                }
                if (unit.isStructureKnown() && unit.isConsistent() && !this.fIsReconciling) {
                    return unit.getElementAtOffset(offset);
                }
            }
            catch (CModelException x) {
                CUIPlugin.log(x.getStatus());
            }
        }
        return null;
    }

    protected void synchronizeOutlinePage() {
        if (this.fOutlinePage != null && this.fOutlinePage.isLinkingEnabled()) {
            this.fOutlinePage.removeSelectionChangedListener(this);
            this.fOutlinePage.synchronizeSelectionWithEditor();
            this.fOutlinePage.addSelectionChangedListener(this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ICElement element) {
        if (element instanceof ISourceReference && !(element instanceof ITranslationUnit)) {
            ISourceReference reference = (ISourceReference)element;
            this.setSelection(reference, true);
        }
    }

    public void setSelection(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            StyledText textWidget = null;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer != null) {
                textWidget = sourceViewer.getTextWidget();
            }
            if (textWidget == null) {
                return;
            }
            try {
                this.setSelection(element.getSourceRange(), moveCursor);
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        block19: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (element != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer == null) {
                    return;
                }
                textWidget = sourceViewer.getTextWidget();
                if (textWidget == null) {
                    return;
                }
                try {
                    IRegion alternateRegion = null;
                    int start = element.getStartPos();
                    int length = element.getLength();
                    if (start < 0 || length < 0) {
                        start = 0;
                        length = 0;
                    }
                    if (length == 0 && start == 0 && element.getStartLine() > 0) {
                        start = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getStartLine() - 1);
                        length = element.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getEndLine()) - start : start;
                        alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine() - 1);
                        if ((start == length || length < 0) && alternateRegion != null) {
                            start = alternateRegion.getOffset();
                            length = alternateRegion.getLength();
                        }
                    }
                    this.setHighlightRange(start, length, moveCursor);
                    if (!moveCursor) break block19;
                    start = element.getIdStartPos();
                    length = element.getIdLength();
                    if (start == 0 && length == 0 && alternateRegion != null) {
                        start = alternateRegion.getOffset();
                        length = alternateRegion.getLength();
                    }
                    if (start > -1 && length > 0) {
                        try {
                            textWidget.setRedraw(false);
                            sourceViewer.revealRange(start, length);
                            sourceViewer.setSelectedRange(start, length);
                        }
                        finally {
                            textWidget.setRedraw(true);
                        }
                        this.markInNavigationHistory();
                    }
                    this.updateStatusField("InputPosition");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (BadLocationException badLocationException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    protected void installTabsToSpacesConverter() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config != null && sourceViewer instanceof ITextViewerExtension7) {
            int tabWidth = config.getTabWidth(sourceViewer);
            TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
            tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider instanceof CDocumentProvider) {
                CDocumentProvider cProvider = (CDocumentProvider)provider;
                tabToSpacesConverter.setLineTracker(cProvider.createLineTracker(this.getEditorInput()));
            } else {
                tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            }
            ((ITextViewerExtension7)sourceViewer).setTabsToSpacesConverter((IAutoEditStrategy)tabToSpacesConverter);
            this.updateIndentationMode();
        }
    }

    private void updateIndentationMode() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof CSourceViewer) {
            CSourceViewer cSourceVieer = (CSourceViewer)sourceViewer;
            IWorkingCopy element = this.getInputCElement();
            ICProject project = element == null ? null : element.getCProject();
            int indentWidth = CodeFormatterUtil.getIndentWidth(project);
            boolean useSpaces = this.isTabsToSpacesConversionEnabled();
            cSourceVieer.configureIndentation(indentWidth, useSpaces);
        }
        super.updateIndentPrefixes();
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        IWorkingCopy element = this.getInputCElement();
        ICProject project = element == null ? null : element.getCProject();
        String option = project == null ? CCorePlugin.getOption((String)"org.eclipse.cdt.core.formatter.tabulation.char") : project.getOption("org.eclipse.cdt.core.formatter.tabulation.char", true);
        return "space".equals(option);
    }

    protected void uninstallProjectionModelUpdater() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
    }

    public void dispose() {
        this.fIndexUpdateRequestor.updateIndexInclusion(null);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        this.uninstallProjectionModelUpdater();
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        this.uninstallOverrideIndicator();
        this.uninstallSemanticHighlighting();
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.dispose();
            this.fCEditorErrorTickUpdater = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.fTextSearchGroup != null) {
            this.fTextSearchGroup.dispose();
            this.fTextSearchGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fOpenInViewGroup != null) {
            this.fOpenInViewGroup.dispose();
            this.fOpenInViewGroup = null;
        }
        if (this.fGenerateActionGroup != null) {
            this.fGenerateActionGroup.dispose();
            this.fGenerateActionGroup = null;
        }
        if (this.fSurroundWithActionGroup != null) {
            this.fSurroundWithActionGroup.dispose();
            this.fSurroundWithActionGroup = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fSelectionHistory != null) {
            this.fSelectionHistory.dispose();
            this.fSelectionHistory = null;
        }
        super.dispose();
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        String oldLanguage = "";
        IFile originalFile = this.getEditorInputFile(originalElement);
        if (originalFile != null) {
            if (originalFile.getProject() != null && !originalFile.getProject().isAccessible()) {
                return true;
            }
            IContentType type = CCorePlugin.getContentType((IProject)originalFile.getProject(), (String)originalFile.getName());
            if (type != null) {
                oldLanguage = type.getId();
            }
            if (oldLanguage == null) {
                return false;
            }
        }
        String newLanguage = "";
        IFile movedFile = this.getEditorInputFile(movedElement);
        if (movedFile != null) {
            IContentType type = CCorePlugin.getContentType((IProject)movedFile.getProject(), (String)movedFile.getName());
            if (type != null) {
                newLanguage = type.getId();
            }
            if (newLanguage == null) {
                return false;
            }
        }
        return oldLanguage.equals(newLanguage);
    }

    private IFile getEditorInputFile(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    protected void createActions() {
        super.createActions();
        this.fFoldingGroup = new FoldingActionGroup(this, (ITextViewer)this.getSourceViewer());
        Object action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        ResourceBundle bundle = ConstructedCEditorMessages.getResourceBundle();
        action = new GotoNextBookmarkAction(bundle, "GotoNextBookmark.", this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.next.bookmark");
        this.setAction("GotoNextBookmark", (IAction)action);
        action = new FindWordAction(bundle, "FindWord.", this, (ITextViewer)this.getSourceViewer());
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.find.word");
        this.setAction("FindWord", (IAction)action);
        this.markAsStateDependentAction("FindWord", true);
        this.markAsSelectionDependentAction("FindWord", true);
        action = new ToggleCommentAction(bundle, "ToggleComment.", this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        action = new AddBlockCommentAction(bundle, "AddBlockComment.", this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.add.block.comment");
        this.setAction("AddBlockComment", (IAction)action);
        this.markAsStateDependentAction("AddBlockComment", true);
        this.markAsSelectionDependentAction("AddBlockComment", true);
        action = new RemoveBlockCommentAction(bundle, "RemoveBlockComment.", this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.remove.block.comment");
        this.setAction("RemoveBlockComment", (IAction)action);
        this.markAsStateDependentAction("RemoveBlockComment", true);
        this.markAsSelectionDependentAction("RemoveBlockComment", true);
        action = new IndentAction(bundle, "Indent.", this, false);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.indent");
        this.setAction("Indent", (IAction)action);
        this.markAsStateDependentAction("Indent", true);
        this.markAsSelectionDependentAction("Indent", true);
        action = new IndentAction(bundle, "Indent.", this, true);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        if (this.getPreferenceStore().getBoolean("smart_tab")) {
            this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        }
        action = new TextOperationAction(bundle, "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        action = new SortLinesAction(this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.sort.lines");
        this.setAction("SortLines", (IAction)action);
        this.markAsStateDependentAction("SortLines", true);
        this.markAsSelectionDependentAction("SortLines", true);
        action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(bundle, "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        action = new TextOperationAction(bundle, "OpenOutline.", (ITextEditor)this, 101, true);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.outline");
        this.setAction("OpenOutline", (IAction)action);
        action = new TextOperationAction(bundle, "OpenHierarchy.", (ITextEditor)this, 102, true);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.quick.type.hierarchy");
        this.setAction("OpenHierarchy", (IAction)action);
        action = new GoToNextPreviousMemberAction(bundle, "GotoNextMember.", this, true);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.next.member");
        this.setAction("GotoPrevMember", (IAction)action);
        action = new GoToNextPreviousMemberAction(bundle, "GotoPreviousMember.", this, false);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.prev.member");
        this.setAction("GotoNextMember", (IAction)action);
        action = new ToggleSourceAndHeaderAction(bundle, "ToggleSourceHeader.", this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.toggle.source.header");
        this.setAction("ToggleSourceHeader", (IAction)action);
        action = new TextOperationAction(bundle, "OpenMacroExplorer.", (ITextEditor)this, 103, true);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.quick.macro.explorer");
        this.setAction("OpenMacroExplorer", (IAction)action);
        this.fSelectionHistory = new SelectionHistory(this);
        action = new StructureSelectEnclosingAction(bundle, this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.enclosing");
        this.setAction("StructureSelectEnclosing", (IAction)action);
        action = new StructureSelectNextAction(bundle, this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.next");
        this.setAction("StructureSelectNext", (IAction)action);
        action = new StructureSelectPreviousAction(bundle, this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.previous");
        this.setAction("StructureSelectPrevious", (IAction)action);
        action = new StructureSelectHistoryAction(bundle, this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.select.last");
        this.setAction("StructureSelectHistory", (IAction)action);
        this.fSelectionSearchGroup = this.createSelectionSearchGroup();
        this.fTextSearchGroup = new TextSearchGroup((IEditorPart)this);
        this.fRefactoringActionGroup = new CRefactoringActionGroup((IWorkbenchPart)this, "group.edit");
        this.fOpenInViewGroup = this.createOpenViewActionGroup();
        this.fGenerateActionGroup = new GenerateActionGroup(this, "group.edit");
        this.fSurroundWithActionGroup = new SurroundWithActionGroup(this, "group.edit");
        action = this.getAction("ShiftRight");
        if (action != null) {
            action.setId("ShiftRight");
            CPluginImages.setImageDescriptors((IAction)action, "lcl16/", "org.eclipse.cdt.ui.shift_r_edit.gif");
        }
        if ((action = this.getAction("ShiftLeft")) != null) {
            action.setId("ShiftLeft");
            CPluginImages.setImageDescriptors((IAction)action, "lcl16/", "org.eclipse.cdt.ui.shift_l_edit.gif");
        }
    }

    protected ActionGroup createSelectionSearchGroup() {
        return new SelectionSearchGroup(this);
    }

    protected ActionGroup createOpenViewActionGroup() {
        return new OpenViewActionGroup(this);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        boolean hasCElement;
        menu.add((IContributionItem)new GroupMarker("group.top"));
        menu.add((IContributionItem)new Separator("group.debug"));
        menu.add((IContributionItem)new GroupMarker("group.debug.end"));
        super.editorContextMenuAboutToShow(menu);
        menu.remove("ShiftLeft");
        menu.remove("ShiftRight");
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        boolean bl = hasCElement = this.getInputCElement() != null;
        if (hasCElement) {
            this.addAction(menu, "group.open", "OpenDeclarations");
            this.addAction(menu, "group.open", "OpenDefinition");
            this.addAction(menu, "group.open", "OpenTypeHierarchy");
            this.addAction(menu, "group.open", "OpenCallHierarchy");
            this.addAction(menu, "group.open", "OpenOutline");
            this.addAction(menu, "group.open", "OpenHierarchy");
            this.addAction(menu, "group.open", "OpenMacroExplorer");
            this.addAction(menu, "group.open", "ToggleSourceHeader");
        }
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fGenerateActionGroup.setContext(context);
        this.fGenerateActionGroup.fillContextMenu(menu);
        this.fGenerateActionGroup.setContext(null);
        this.fSurroundWithActionGroup.setContext(context);
        this.fSurroundWithActionGroup.fillContextMenu(menu);
        this.fSurroundWithActionGroup.setContext(null);
        if (hasCElement) {
            this.fSelectionSearchGroup.fillContextMenu(menu);
        }
        this.fTextSearchGroup.fillContextMenu(menu);
        if (hasCElement) {
            this.fRefactoringActionGroup.fillContextMenu(menu);
            this.fOpenInViewGroup.fillContextMenu(menu);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(CEditorMessages.CEditor_menu_folding, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
    }

    public static void setOutlinePageInput(CContentOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            page.setInput((ITranslationUnit)manager.getWorkingCopy(input));
        }
    }

    private static void setOutlinePageInputIfNotSame(CContentOutlinePage page, IEditorInput input) {
        IWorkingCopyManager manager;
        IWorkingCopy workingCopy;
        if (page != null && (workingCopy = (manager = CUIPlugin.getDefault().getWorkingCopyManager()).getWorkingCopy(input)) != page.getRoot()) {
            page.setInput((ITranslationUnit)workingCopy);
        }
    }

    protected boolean isFoldingEnabled() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        final IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        parent.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                IContext context;
                IContextProvider provider = (IContextProvider)CEditor.this.getAdapter(IContextProvider.class);
                if (provider != null && (context = provider.getContext((Object)CEditor.this)) != null) {
                    helpSystem.displayHelp(context);
                    return;
                }
                helpSystem.displayHelp("org.eclipse.cdt.ui.editor_view");
            }
        });
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        if (this.isSemanticHighlightingEnabled()) {
            this.installSemanticHighlighting();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeAngularBrackets = preferenceStore.getBoolean(CLOSE_ANGULAR_BRACKETS);
        boolean closeBraces = preferenceStore.getBoolean(CLOSE_BRACES);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
        this.fBracketInserter.setCloseAngularBracketsEnabled(closeBraces);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.isMarkingOccurrences()) {
            this.installOccurrencesFinder(false);
        }
        if (this.isShowingOverrideIndicators()) {
            this.installOverrideIndicator(false);
        }
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new CSourceViewerDecorationSupport(this, viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        ((CSourceViewerDecorationSupport)support).setInactiveCodePainterPreferenceKeys(INACTIVE_CODE_ENABLE, INACTIVE_CODE_COLOR);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(CEditorMessages.GotoMatchingBracket_error_invalidSelection);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (CEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(CEditorMessages.GotoMatchingBracket_error_noMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(CEditorMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() > 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength(), this.fSyncProblemsViewMarker);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            if (this.fSyncProblemsViewMarker == null) {
                this.updateMarkerViews(annotation);
            }
            if (annotation instanceof ICAnnotation && ((ICAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
        this.fSyncProblemsViewMarker = null;
    }

    private Annotation getAnnotation(int offset, int length, IMarker marker) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator parent = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        CAnnotationIterator e = new CAnnotationIterator(parent, false);
        Annotation annotation = null;
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null || !p.overlapsWith(offset, length)) continue;
            if (annotation == null) {
                annotation = a;
                if (marker == null) break;
            }
            if (!(a instanceof MarkerAnnotation) || !((MarkerAnnotation)a).getMarker().equals((Object)marker)) continue;
            annotation = a;
            break;
        }
        return annotation;
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        TextNavigationAction action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
        action = new DeletePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(262152, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deletePreviousWord", true);
        action = new DeleteNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(262271, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deleteNextWord", true);
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        IPreferenceStore store = this.getPreferenceStore();
        AdaptedSourceViewer sourceViewer = new AdaptedSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
        CSourceViewer cSourceViewer = null;
        if (sourceViewer instanceof CSourceViewer) {
            cSourceViewer = sourceViewer;
        }
        if (cSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.cdt.ui.editor.showSegments"))) {
            cSourceViewer.prepareDelayedProjection();
        }
        ProjectionViewer projectionViewer = sourceViewer;
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.search.results");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new SourceViewerInformationControl(shell, false, CEditor.this.getOrientation(), null);
            }
        });
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = CUIPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install(this, projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.cdt.ui.cEditorScope"});
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof CSourceViewerConfiguration) {
            return ((CSourceViewerConfiguration)configuration).affectsTextPresentation(event);
        }
        return false;
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install(this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    public void setStatusLineErrorMessage(String message) {
        long now = System.currentTimeMillis();
        if (message != null || now - this.fErrorMessageTime > 1000L) {
            super.setStatusLineErrorMessage(message);
            this.fErrorMessageTime = message != null ? now : 0L;
        }
    }

    protected void setStatusLineMessage(String message) {
        if (System.currentTimeMillis() - this.fErrorMessageTime > 1000L) {
            super.setStatusLineMessage(message);
        }
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = CEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return CEditor.isBracket(document.getChar(offset - 1)) && CEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] parentPrefPageIds = super.collectContextMenuPreferencePages();
        String[] prefPageIds = new String[parentPrefPageIds.length + 13];
        int nIds = 0;
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CEditorPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeAssistPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeAssistPreferenceAdvanced";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.HoverPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.FoldingPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.MarkOccurrencesPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeColoringPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.TemplatePreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.SmartTypingPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeFormatterPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CScalabilityPreferences";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.SaveActionsPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.codan.ui.preferences.CodanPreferencePage";
        System.arraycopy(parentPrefPageIds, 0, prefPageIds, nIds, parentPrefPageIds.length);
        return prefPageIds;
    }

    @Override
    public void aboutToBeReconciled() {
        this.fIsReconciling = true;
        CUIPlugin.getDefault().getASTProvider().aboutToBeReconciled((ICElement)this.getInputCElement());
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((ICReconcilingListener)listeners[i]).aboutToBeReconciled();
            ++i;
        }
    }

    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        this.fIsReconciling = false;
        CUIPlugin cuiPlugin = CUIPlugin.getDefault();
        if (cuiPlugin == null) {
            return;
        }
        cuiPlugin.getASTProvider().reconciled(ast, (ICElement)this.getInputCElement(), progressMonitor);
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((ICReconcilingListener)listeners[i]).reconciled(ast, force, progressMonitor);
            ++i;
        }
    }

    public final void addReconcileListener(ICReconcilingListener listener) {
        this.fReconcilingListeners.add((Object)listener);
    }

    public final void removeReconcileListener(ICReconcilingListener listener) {
        this.fReconcilingListeners.remove((Object)listener);
    }

    protected boolean isSemanticHighlightingEnabled() {
        return SemanticHighlightings.isEnabled(this.getPreferenceStore()) && (!this.isEnableScalablilityMode() || !this.getPreferenceStore().getBoolean("scalability.semanticHighlight"));
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticManager == null) {
            this.fSemanticManager = new SemanticHighlightingManager();
            this.fSemanticManager.install(this, (CSourceViewer)this.getSourceViewer(), CUIPlugin.getDefault().getTextTools().getColorManager(), this.getPreferenceStore());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticManager != null) {
            this.fSemanticManager.uninstall();
            this.fSemanticManager = null;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fOpenInViewGroup.fillActionBars(actionBars);
        this.fRefactoringActionGroup.fillActionBars(actionBars);
        this.fGenerateActionGroup.fillActionBars(actionBars);
        this.fFoldingGroup.updateActionBars();
        this.fSurroundWithActionGroup.fillActionBars(actionBars);
    }

    protected void updateStateDependentActions() {
        super.updateStateDependentActions();
        this.fGenerateActionGroup.editorStateChanged();
    }

    public void resetProjection() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, IASTTranslationUnit astRoot) {
        OccurrencesFinder occurrencesFinder;
        IBinding binding;
        if (this.fOccurrencesAnnotationUpdaterJob != null) {
            this.fOccurrencesAnnotationUpdaterJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        ISelectionValidator validator = null;
        if (this.fForcedMarkOccurrencesSelection != selection && this.getSelectionProvider() instanceof ISelectionValidator && !(validator = (ISelectionValidator)this.getSelectionProvider()).isValid((ISelection)selection)) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = CWordFinder.findWord(document, offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        IASTNodeSelector selector = astRoot.getNodeSelector(null);
        IASTName name = selector.findEnclosingName(selection.getOffset(), selection.getLength());
        if (name == null) {
            name = selector.findEnclosingImplicitName(selection.getOffset(), selection.getLength());
        }
        if (validator != null && !validator.isValid((ISelection)selection)) {
            return;
        }
        if (name != null && (binding = name.resolveBinding()) != null && (occurrencesFinder = new OccurrencesFinder()).initialize(astRoot, (IASTNode)name) == null) {
            if (!this.fMarkOverloadedOperatorOccurrences) {
                occurrencesFinder.setOptions(1);
            }
            locations = occurrencesFinder.getOccurrences();
        }
        if (locations == null || locations.length == 0) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            } else if (hasChanged) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesAnnotationUpdaterJob = new OccurrencesAnnotationUpdaterJob(document, locations, (ISelection)selection, validator);
        this.fOccurrencesAnnotationUpdaterJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        IWorkingCopy inputCElement;
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            @Override
            public void selectionChanged(IEditorPart part, ITextSelection selection, IASTTranslationUnit astRoot) {
                CEditor.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener(this, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null && (inputCElement = this.getInputCElement()) instanceof ITranslationUnit) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            ASTProvider.getASTProvider().runOnAST((ICElement)inputCElement, ASTProvider.WAIT_NO, this.getProgressMonitor(), new ASTCache.ASTRunnable(){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                    CEditor.this.updateOccurrenceAnnotations((ITextSelection)CEditor.this.fForcedMarkOccurrencesSelection, ast);
                    return Status.OK_STATUS;
                }
            });
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesAnnotationUpdaterJob != null) {
            this.fOccurrencesAnnotationUpdaterJob.cancel();
            this.fOccurrencesAnnotationUpdaterJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener(this, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected boolean isMarkingOccurrences() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null && store.getBoolean("markOccurrences");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                Annotation[] annotationArray = this.fOccurrenceAnnotations;
                int n = this.fOccurrenceAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation occurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(occurrenceAnnotation);
                    ++n2;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        ICProject project = EditorUtility.getCProject(input);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.cdt.core"));
        }
        stores.add(CUIPlugin.getDefault().getPreferenceStore());
        stores.add(CUIPlugin.getDefault().getCorePreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public boolean isParserBasedContentAssistDisabled() {
        return this.getPreferenceStore().getBoolean("scalability.parserBasedContentAssist");
    }

    public boolean isContentAssistAutoActivartionDisabled() {
        return this.getPreferenceStore().getBoolean("scalability.contentAssistAutoActivation");
    }

    public boolean isEnableScalablilityMode() {
        return this.fEnableScalablilityMode;
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        return super.isPrefQuickDiffAlwaysOn() && !this.isEnableScalablilityMode();
    }

    public boolean shouldProcessLocalParsingCompletions() {
        return true;
    }

    protected void uninstallOverrideIndicator() {
        if (this.fOverrideIndicatorManager != null) {
            this.fOverrideIndicatorManager.removeAnnotations();
            this.removeReconcileListener(this.fOverrideIndicatorManager);
            this.fOverrideIndicatorManager = null;
        }
    }

    protected boolean affectsOverrideIndicatorAnnotations(PropertyChangeEvent event) {
        String key = event.getProperty();
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.cdt.ui.overrideIndicator");
        if (key == null || preference == null) {
            return false;
        }
        return key.equals(preference.getHighlightPreferenceKey()) || key.equals(preference.getVerticalRulerPreferenceKey()) || key.equals(preference.getOverviewRulerPreferenceKey()) || key.equals(preference.getTextPreferenceKey());
    }

    private boolean getBoolean(IPreferenceStore store, String key) {
        return key != null && store.getBoolean(key);
    }

    protected boolean isShowingOverrideIndicators() {
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.cdt.ui.overrideIndicator");
        IPreferenceStore store = this.getPreferenceStore();
        return this.getBoolean(store, preference.getHighlightPreferenceKey()) || this.getBoolean(store, preference.getVerticalRulerPreferenceKey()) || this.getBoolean(store, preference.getOverviewRulerPreferenceKey()) || this.getBoolean(store, preference.getTextPreferenceKey());
    }

    protected void installOverrideIndicator(boolean provideAST) {
        this.uninstallOverrideIndicator();
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return;
        }
        this.fOverrideIndicatorManager = new OverrideIndicatorManager(model);
        this.addReconcileListener(this.fOverrideIndicatorManager);
        IWorkingCopy inputCElement = this.getInputCElement();
        if (provideAST && inputCElement instanceof ITranslationUnit) {
            ASTProvider.getASTProvider().runOnAST((ICElement)inputCElement, ASTProvider.WAIT_ACTIVE_ONLY, this.getProgressMonitor(), new ASTCache.ASTRunnable(){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                    if (ast != null) {
                        CEditor.this.fOverrideIndicatorManager.reconciled(ast, true, CEditor.this.getProgressMonitor());
                    }
                    return Status.OK_STATUS;
                }
            });
        }
    }

    protected void editorSaved() {
        ITranslationUnit translationUnit;
        super.editorSaved();
        IWorkingCopy inputCElement = this.getInputCElement();
        if (inputCElement != null && (translationUnit = inputCElement.getOriginalElement()) != null) {
            Object[] objectArray = this.fPostSaveListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPostSaveListener)listener).saved(translationUnit, this.getProgressMonitor());
                ++n2;
            }
        }
    }

    public void addPostSaveListener(IPostSaveListener listener) {
        this.fPostSaveListeners.add((Object)listener);
    }

    public void removePostSaveListener(IPostSaveListener listener) {
        this.fPostSaveListeners.remove((Object)listener);
    }

    class AdaptedSourceViewer
    extends CSourceViewer {
        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
        }

        @Override
        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        @Override
        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    CEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 22: {
                    String msg = this.fQuickAssistAssistant.showPossibleQuickAssists();
                    CEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
            }
            super.doOperation(operation);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester, priority);
        }

        public IFormattingContext createFormattingContext() {
            String customFormatterId;
            FormattingContext context = new FormattingContext();
            IWorkingCopy inputCElement = CEditor.this.getInputCElement();
            ICProject cProject = inputCElement != null ? inputCElement.getCProject() : null;
            HashMap<String, Object> preferences = cProject == null ? new HashMap<String, Object>(CCorePlugin.getOptions()) : new HashMap(cProject.getOptions(true));
            if (inputCElement instanceof ITranslationUnit) {
                ITranslationUnit tu = (ITranslationUnit)inputCElement;
                ILanguage language = null;
                try {
                    language = tu.getLanguage();
                }
                catch (CoreException coreException) {
                    language = GPPLanguage.getDefault();
                }
                preferences.put("org.eclipse.cdt.core.formatter.current_translation_unit", tu);
                preferences.put("org.eclipse.cdt.core.formatter.language", language);
                preferences.put("org.eclipse.cdt.core.formatter.current_file", tu.getResource());
            }
            if (cProject == null && (customFormatterId = CEditor.this.getPreferenceStore().getString("org.eclipse.cdt.core.code_formatter")) != null) {
                preferences.put("org.eclipse.cdt.core.code_formatter", customFormatterId);
            }
            context.setProperty((Object)"formatting.context.preferences", preferences);
            return context;
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private boolean fCloseAngularBrackets = true;
        private boolean fCloseBraces = true;
        private final String CATEGORY = this.toString();
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
        private Deque<BracketLevel> fBracketLevelStack = new ArrayDeque<BracketLevel>();

        private BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void setCloseAngularBracketsEnabled(boolean enabled) {
            this.fCloseAngularBrackets = enabled;
        }

        public void setCloseBracesEnabled(boolean enabled) {
            this.fCloseBraces = enabled;
        }

        private boolean isAngularIntroducer(String identifier) {
            return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || angularIntroducers.contains(identifier) || identifier.endsWith("_ptr") || identifier.endsWith("_cast"));
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || CEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '<': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = CEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                IRegion startLine = document.getLineInformationOfOffset(offset);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                if (startLine != endLine && CEditor.this.isBlockSelectionModeEnabled()) {
                    return;
                }
                ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)true);
                if (!"__dftl_partition_content_type".equals(partition.getType()) && !"__c_preprocessor".equals(partition.getType())) {
                    return;
                }
                CHeuristicScanner scanner = new CHeuristicScanner(document, "___c_partitioning", partition.getType());
                int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
                String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
                int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                int prevTokenOffset = scanner.getPosition() + 1;
                String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '<': {
                        if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && prevToken == 2000 && this.isAngularIntroducer(previous)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '{': {
                        if (this.fCloseBraces && nextToken != 2000 && (next == null || next.length() <= 1) && this.isInsideParentheses(scanner, offset - 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        if (this.fCloseStrings && nextToken != 2000 && (next == null || next.length() <= 1 && next.charAt(0) != event.character) && !this.isInsideStringInPreprocessorDirective(partition, document, offset)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!CEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = CEditor.getPeerCharacter(character);
                StringBuilder buffer = new StringBuilder(3);
                buffer.append(character);
                buffer.append(closingCharacter);
                document.replace(offset, length, buffer.toString());
                BracketLevel level = new BracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + 1, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, CEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
            catch (BadPositionCategoryException e) {
                CUIPlugin.log(e);
            }
        }

        private boolean isInsideParentheses(CHeuristicScanner scanner, int offset) {
            int depth = 0;
            int i = 0;
            while (i < 100) {
                int token = scanner.previousToken(offset, 0);
                if (token == 5) {
                    if (--depth < 0) {
                        return true;
                    }
                } else if (token == 6) {
                    ++depth;
                } else if (token == -1) {
                    return false;
                }
                offset = scanner.getPosition();
                ++i;
            }
            return false;
        }

        private boolean isInsideStringInPreprocessorDirective(ITypedRegion partition, IDocument document, int offset) throws BadLocationException {
            String directive;
            int hashIdx;
            if ("__c_preprocessor".equals(partition.getType()) && offset < document.getLength() && (hashIdx = (directive = document.get(partition.getOffset(), offset - partition.getOffset() + 1)).indexOf(35)) >= 0) {
                Document tmp = new Document(directive.substring(hashIdx + 1));
                new CDocumentSetupParticipant().setup((IDocument)tmp);
                String type = TextUtilities.getContentType((IDocument)tmp, (String)"___c_partitioning", (int)(offset - (partition.getOffset() + hashIdx + 1)), (boolean)true);
                if (!type.equals("__dftl_partition_content_type")) {
                    return true;
                }
            }
            return false;
        }

        public void left(LinkedModeModel environment, int flags) {
            final BracketLevel level = this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = CEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException e) {
                                CUIPlugin.log(e);
                            }
                        }
                        if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(BracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(BracketInserter.this.CATEGORY);
                            }
                            catch (BadPositionCategoryException e) {
                                CUIPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class BracketLevel {
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!CEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (CEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = CEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(127);
            } else {
                int length;
                int caret;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    caret = selection.x;
                    length = selection.y;
                } else {
                    caret = CEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset());
                    length = position - caret;
                }
                try {
                    viewer.getDocument().replace(caret, length, "");
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        @Override
        protected int findNextPosition(int position) {
            return this.fIterator.following(position);
        }

        public void update() {
            this.setEnabled(CEditor.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!CEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (CEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = CEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(8);
            } else {
                int length;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    position = selection.x;
                    length = selection.y;
                } else {
                    length = CEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset()) - position;
                }
                try {
                    viewer.getDocument().replace(position, length, "");
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        @Override
        protected int findPreviousPosition(int position) {
            return this.fIterator.preceding(position);
        }

        public void update() {
            this.setEnabled(CEditor.this.isEditorInputModifiable());
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)CEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            CEditor.this.selectionChanged();
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Deque<BracketLevel> fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Deque<BracketLevel> stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = CEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = CEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    private final class GotoMarkerAdapter
    implements IGotoMarker {
        private GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker marker) {
            int length;
            if (CEditor.this.fIsUpdatingMarkerViews) {
                return;
            }
            if (CEditor.this.getSourceViewer() == null) {
                return;
            }
            int start = MarkerUtilities.getCharStart((IMarker)marker);
            int end = MarkerUtilities.getCharEnd((IMarker)marker);
            boolean selectLine = start < 0 || end < 0;
            IAnnotationModel model = CEditor.this.getDocumentProvider().getAnnotationModel((Object)CEditor.this.getEditorInput());
            if (model instanceof AbstractMarkerAnnotationModel) {
                AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
                Position pos = markerModel.getMarkerPosition(marker);
                if (pos != null && !pos.isDeleted()) {
                    start = pos.getOffset();
                    end = pos.getOffset() + pos.getLength();
                    selectLine = false;
                }
                if (pos != null && pos.isDeleted()) {
                    return;
                }
            }
            IDocument document = CEditor.this.getDocumentProvider().getDocument((Object)CEditor.this.getEditorInput());
            if (selectLine) {
                try {
                    if (start >= 0) {
                        IRegion lineInfo = document.getLineInformationOfOffset(start);
                        start = lineInfo.getOffset();
                        end = start + lineInfo.getLength();
                    } else {
                        int line = MarkerUtilities.getLineNumber((IMarker)marker);
                        IRegion lineInfo = document.getLineInformation(--line);
                        start = lineInfo.getOffset();
                        end = start + lineInfo.getLength();
                    }
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
            if (end - 1 < (length = document.getLength()) && start < length) {
                CEditor.this.fSyncProblemsViewMarker = marker;
                CEditor.this.selectAndReveal(start, end - start);
            }
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(CEditor.modelOffset2WidgetOffset((ISourceViewer)CEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(CEditor.modelOffset2WidgetOffset((ISourceViewer)CEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected CWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(CEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CWordIterator();
        }

        public void run() {
            IPreferenceStore store = CEditor.this.getPreferenceStore();
            if (!store.getBoolean(CEditor.SUB_WORD_NAVIGATION)) {
                super.run();
                return;
            }
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = CEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(position);
            try {
                if (CEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.following(position)) == -1) continue;
                widget = CEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    class OccurrencesAnnotationUpdaterJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesAnnotationUpdaterJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection, ISelectionValidator validator) {
            super(CEditorMessages.CEditor_markOccurrences_job_name);
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = validator;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && CEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = CEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = CEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)CEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.cdt.ui.occurrences.write" : "org.eclipse.cdt.ui.occurrences";
                annotationMap.put(new Annotation(annotationType, false, description), position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = CEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(CEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    CEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                CEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = CEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = CEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = CEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)CEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (CEditor.this.fOccurrencesAnnotationUpdaterJob != null) {
                CEditor.this.fOccurrencesAnnotationUpdaterJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected CWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(CEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CWordIterator();
        }

        public void run() {
            IPreferenceStore store = CEditor.this.getPreferenceStore();
            if (!store.getBoolean(CEditor.SUB_WORD_NAVIGATION)) {
                super.run();
                return;
            }
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = CEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(position);
            try {
                if (CEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.preceding(position)) == -1) continue;
                widget = CEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = CEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = CEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = CEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }
}

