/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsch.internal.core.JSchProvider;
import org.eclipse.jsch.internal.core.PreferenceInitializer;
import org.eclipse.jsch.internal.core.Utils;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class JSchCorePlugin
extends Plugin {
    public static String ID = "org.eclipse.jsch.core";
    public static final int DEFAULT_TIMEOUT = 60;
    private int communicationsTimeout = 60;
    private boolean needToLoadKnownHosts = true;
    private boolean needToLoadKeys = true;
    private JSch jsch;
    private String current_pkeys = "";
    public static final String PT_AUTHENTICATOR = "authenticator";
    private static JSchCorePlugin plugin;
    private ServiceTracker tracker;
    private ServiceRegistration jschService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JSchCorePlugin() {
        plugin = this;
    }

    public static JSchCorePlugin getPlugin() {
        return plugin;
    }

    public static void log(CoreException e) {
        JSchCorePlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
    }

    public static void log(IStatus status) {
        JSchCorePlugin.getPlugin().getLog().log(status);
    }

    public static void log(int severity, String message, Throwable e) {
        JSchCorePlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public int getTimeout() {
        return this.communicationsTimeout;
    }

    public void setTimeout(int timeout) {
        this.communicationsTimeout = Math.max(0, timeout);
    }

    public synchronized JSch getJSch() {
        if (this.jsch == null) {
            this.jsch = new JSch();
        }
        return this.jsch;
    }

    public void loadKnownHosts() {
        Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        String ssh_home = preferences.getString("SSH2HOME");
        if (ssh_home.length() == 0) {
            ssh_home = PreferenceInitializer.SSH_HOME_DEFAULT;
        }
        File file = new File(ssh_home, "known_hosts");
        try {
            this.getJSch().setKnownHosts(file.getPath());
        }
        catch (JSchException e) {
            JSchCorePlugin.log(4, NLS.bind((String)"An error occurred while loading the know hosts file {0}", (Object)file.getAbsolutePath()), e);
        }
        this.needToLoadKnownHosts = false;
    }

    public boolean isNeedToLoadKnownHosts() {
        return this.needToLoadKnownHosts;
    }

    public void setNeedToLoadKnownHosts(boolean needToLoadKnownHosts) {
        this.needToLoadKnownHosts = needToLoadKnownHosts;
    }

    public boolean isNeedToLoadKeys() {
        return this.needToLoadKeys;
    }

    public void setNeedToLoadKeys(boolean needToLoadKeys) {
        this.needToLoadKeys = needToLoadKeys;
    }

    public void loadPrivateKeys() {
        this.current_pkeys = Utils.loadPrivateKeys(this.getJSch(), this.current_pkeys);
        this.setNeedToLoadKeys(false);
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        BundleContext bundleContext = this.getBundle().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.net.proxy.IProxyService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.tracker.open();
        BundleContext bundleContext2 = this.getBundle().getBundleContext();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jsch.core.IJSchService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jschService = bundleContext2.registerService(clazz2.getName(), (Object)JSchProvider.getInstance(), new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.tracker.close();
        this.jschService.unregister();
    }
}

