/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.model.IPRegister;
import org.eclipse.ptp.debug.core.model.IPRegisterDescriptor;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIMemoryBlockInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegister;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegisterDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeRange;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.model.AbstractPValue;
import org.eclipse.ptp.internal.debug.core.model.PRegisterDescriptor;
import org.eclipse.ptp.internal.debug.core.model.PRegisterGroup;
import org.eclipse.ptp.internal.debug.core.model.PValueFactory;
import org.eclipse.ptp.internal.debug.core.model.PVariable;

public class PRegister
extends PVariable
implements IPRegister {
    protected PRegister(PRegisterGroup parent, IPRegisterDescriptor descriptor) {
        super(parent, ((PRegisterDescriptor)descriptor).getPDIDescriptor());
        this.setFormat(PVariableFormat.getFormat(Preferences.getInt((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    protected PRegister(PRegisterGroup parent, IPRegisterDescriptor descriptor, String message) {
        super(parent, ((PRegisterDescriptor)descriptor).getPDIDescriptor(), message);
        this.setFormat(PVariableFormat.getFormat(Preferences.getInt((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    @Override
    public boolean canEnableDisable() {
        return true;
    }

    @Override
    public void dispose() {
        this.internalDispose(true);
        this.setDisposed(true);
    }

    @Override
    public IAIF getAIF() throws DebugException {
        return this.getValue().getAIF();
    }

    public IRegisterGroup getRegisterGroup() throws DebugException {
        return (IRegisterGroup)this.getParent();
    }

    @Override
    public void handleDebugEvents(IPDIEvent[] events) {
        IPDIEvent[] iPDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIEvent event2 = iPDIEventArray[n2];
            IPDIEvent event = event2;
            if (event.contains(this.getTasks())) {
                if (event instanceof IPDIChangedEvent) {
                    IPDISessionObject reason = ((IPDIChangedEvent)event).getReason();
                    if (reason instanceof IPDIMemoryBlockInfo) {
                        this.resetValue();
                        return;
                    }
                } else if (event instanceof IPDIResumedEvent) {
                    this.setChanged(false);
                }
            }
            ++n2;
        }
        super.handleDebugEvents(events);
    }

    @Override
    protected void createOriginal(IPDIVariableDescriptor vo) {
        if (vo != null) {
            this.setName(vo.getName());
            this.setOriginal(new InternalVariable(this, vo));
        }
    }

    protected IPStackFrame getCurrentStackFrame() {
        return this.fSession.getRegisterManager().getCurrentFrame(this.getTasks());
    }

    @Override
    protected IPStackFrame getStackFrame() {
        IPStackFrame frame = super.getStackFrame();
        if (frame == null) {
            frame = this.getCurrentStackFrame();
        }
        return frame;
    }

    @Override
    protected boolean isBookkeepingEnabled() {
        return false;
    }

    private class InternalVariable
    implements PVariable.IInternalVariable {
        private boolean fChanged = false;
        private IPDIRegister fPDIRegister;
        private IPDIVariableDescriptor fPDIVariableObject;
        private String fQualifiedName;
        private IPValue fValue = PValueFactory.NULL_VALUE;
        private PVariable fVariable;

        public InternalVariable(PVariable var, IPDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setPDIVariableObject(varObject);
            this.setPDIRegister(varObject instanceof IPDIRegister ? (IPDIRegister)varObject : null);
        }

        @Override
        public PVariable.IInternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getPDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (PDIException e) {
                PRegister.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        @Override
        public PVariable.IInternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getPDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (PDIException e) {
                PRegister.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        @Override
        public void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getPDIVariableObject().equals(((InternalVariable)obj).getPDIVariableObject());
            }
            return false;
        }

        @Override
        public String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fPDIVariableObject != null ? this.fPDIVariableObject.getQualifiedName() : null;
                }
                catch (PDIException e) {
                    PRegister.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        @Override
        public synchronized IPValue getValue() throws DebugException {
            IPDIRegister reg;
            if (this.fValue.equals(PValueFactory.NULL_VALUE) && (reg = this.getPDIRegister()) != null) {
                try {
                    IAIF aif = reg.getAIF(PRegister.this.getCurrentStackFrame().getPDIStackFrame());
                    if (aif != null && aif.getType() instanceof IAIFTypeArray) {
                        IAIFTypeRange range = ((IAIFTypeArray)aif.getType()).getRange();
                        this.fValue = PValueFactory.createIndexedValue(this.getVariable(), reg, 0, range.getSize());
                    } else {
                        this.fValue = PValueFactory.createValue(this.getVariable(), reg);
                    }
                }
                catch (PDIException e) {
                    PRegister.requestFailed(e.getMessage(), e);
                }
            }
            return this.fValue;
        }

        @Override
        public void invalidateValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).dispose();
                this.fValue = PValueFactory.NULL_VALUE;
            }
        }

        @Override
        public boolean isArgument() {
            return this.getPDIVariableObject() instanceof IPDIArgumentDescriptor;
        }

        @Override
        public boolean isChanged() {
            return this.fChanged;
        }

        @Override
        public boolean isEditable() throws DebugException {
            IPDIRegister reg = this.getPDIRegister();
            if (reg != null) {
                try {
                    return reg.isEditable();
                }
                catch (PDIException pDIException) {}
            }
            return false;
        }

        @Override
        public boolean isSameDescriptor(IPDIVariableDescriptor desc) {
            return this.getPDIVariableObject().equals(desc);
        }

        @Override
        public boolean isSameVariable(IPDIVariable pdiVar) {
            return this.fPDIRegister != null ? this.fPDIRegister.equals(pdiVar) : false;
        }

        @Override
        public synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).preserve();
            }
        }

        @Override
        public void resetValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).reset();
            }
        }

        @Override
        public synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        @Override
        public void setValue(String expression) throws DebugException {
            IPDIRegister pdiRegister = null;
            try {
                pdiRegister = this.getPDIRegister();
                if (pdiRegister != null) {
                    pdiRegister.setValue(expression);
                } else {
                    PRegister.requestFailed("CoreModelMessages", null);
                }
            }
            catch (PDIException e) {
                PRegister.targetRequestFailed(e.getMessage(), null);
            }
        }

        @Override
        public int sizeof() {
            if (this.getPDIVariableObject() != null) {
                try {
                    return this.getPDIVariableObject().sizeof();
                }
                catch (PDIException pDIException) {}
            }
            return 0;
        }

        private synchronized IPDIRegister getPDIRegister() throws DebugException {
            if (this.fPDIRegister == null) {
                try {
                    this.fPDIRegister = PRegister.this.getPDITarget().createRegister((IPDIRegisterDescriptor)this.getPDIVariableObject());
                }
                catch (PDIException e) {
                    PRegister.requestFailed(e.getMessage(), null);
                }
            }
            return this.fPDIRegister;
        }

        private IPDIVariableDescriptor getPDIVariableObject() {
            if (this.fPDIRegister != null) {
                return this.fPDIRegister;
            }
            return this.fPDIVariableObject;
        }

        private synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fPDIRegister != null) {
                    this.fPDIRegister.dispose();
                }
            }
            catch (PDIException e) {
                PRegister.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setPDIRegister(null);
        }

        private void setPDIRegister(IPDIRegister register) {
            this.fPDIRegister = register;
        }

        private void setPDIVariableObject(IPDIVariableDescriptor variableObject) {
            this.fPDIVariableObject = variableObject;
        }

        private void setVariable(PVariable variable) {
            this.fVariable = variable;
        }

        private PVariable getVariable() {
            return this.fVariable;
        }
    }
}

