/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi;

import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDILocation;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIBreakpointManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventRequestManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIExpressionManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIMemoryManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIRegisterManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISignalManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISourceManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITargetManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIThreadManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStartDebuggerRequest;
import org.eclipse.ptp.internal.debug.core.PDebugOptions;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public class Session
implements IPDISession {
    private final IPDIBreakpointManager breakpointManager;
    private final IPDIEventManager eventManager;
    private final IPDIEventRequestManager eventRequestManager;
    private final IPDITaskManager taskManager;
    private final IPDITargetManager targetManager;
    private final IPDIThreadManager threadManager;
    private final IPDIExpressionManager expressionManager;
    private final IPDIVariableManager variableManager;
    private final IPDISourceManager sourceManager;
    private final IPDIMemoryManager memoryManager;
    private final IPDISignalManager signalManager;
    private final IPDIRegisterManager registerManager;
    private final IPDIDebugger debugger;
    private final IPDIRequestFactory requestFactory;
    private final IPDIEventFactory eventFactory;
    private final IPDIModelFactory modelFactory;
    private final ILaunchConfiguration config;
    private final ReentrantLock waitLock = new ReentrantLock();
    private final NotifyJob notifyJob = new NotifyJob();
    private final String job_id;
    private int total_tasks = 0;
    private int status = 0;
    private long timeout = 30000L;

    public Session(IPDIManagerFactory managerFactory, IPDIRequestFactory requestFactory, IPDIEventFactory eventFactory, IPDIModelFactory modelFactory, ILaunchConfiguration config, long timeout, IPDIDebugger debugger, String job_id, int total_tasks) throws PDIException {
        this.config = config;
        this.timeout = timeout;
        this.debugger = debugger;
        this.job_id = job_id;
        this.total_tasks = total_tasks;
        this.requestFactory = requestFactory;
        this.eventFactory = eventFactory;
        this.modelFactory = modelFactory;
        this.eventRequestManager = managerFactory.newEventRequestManager(this);
        this.eventManager = managerFactory.newEventManager(this);
        this.taskManager = managerFactory.newTaskManager(this);
        this.targetManager = managerFactory.newTargetManager(this);
        this.threadManager = managerFactory.newThreadManager(this);
        this.breakpointManager = managerFactory.newBreakpointManager(this);
        this.expressionManager = managerFactory.newExpressionManager(this);
        this.variableManager = managerFactory.newVariableManager(this);
        this.sourceManager = managerFactory.newSourceManager(this);
        this.memoryManager = managerFactory.newMemoryManager(this);
        this.signalManager = managerFactory.newSignalManager(this);
        this.registerManager = managerFactory.newRegisterManager(this);
    }

    @Override
    public void connectToDebugger(IProgressMonitor monitor, String app, String path, String dir, String[] args) throws PDIException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.total_tasks + 10));
        try {
            this.setStatus(1);
            if (!this.getDebugger().isConnected((IProgressMonitor)progress.newChild(10))) {
                this.setStatus(0);
                throw new PDIException(this.getTasks(), Messages.Session_0);
            }
            this.getDebugger().addEventManager(this.eventManager);
            progress.subTask(NLS.bind((String)Messages.Session_1, (Object)this.total_tasks));
            IPDIStartDebuggerRequest request = this.getRequestFactory().getStartDebuggerRequest(this.getTasks(), app, path, dir, args);
            this.eventRequestManager.addEventRequest(request);
            request.waitUntilCompleted(null, (IProgressMonitor)progress.newChild(this.total_tasks));
            this.setStatus(2);
            this.eventManager.fireEvent(this.getEventFactory().newStartedEvent(this, this.getTasks()));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void exit() throws PDIException {
        if (this.status != 4 && this.status != 5) {
            this.setStatus(4);
            this.eventRequestManager.flushEventRequests();
            TaskSet tasks = this.getTasks();
            this.taskManager.getRunningTasks(tasks);
            if (!tasks.isEmpty()) {
                this.eventRequestManager.addEventRequest(this.getRequestFactory().getSuspendRequest(tasks, false));
            }
            tasks = this.getTasks();
            this.taskManager.getNonTerminatedTasks(tasks);
            if (!tasks.isEmpty()) {
                this.eventRequestManager.addEventRequest(this.getRequestFactory().getTerminateRequest(tasks));
            }
            this.eventRequestManager.addEventRequest(this.getRequestFactory().getStopDebuggerRequest(new TaskSet(this.total_tasks)));
            this.taskManager.setPendingTasks(true, tasks);
        }
    }

    @Override
    public IPDITarget findTarget(TaskSet qTasks) throws PDIException {
        IPDITarget target = this.targetManager.getTarget(qTasks);
        if (target == null) {
            throw new PDIException(qTasks, Messages.Session_14);
        }
        return target;
    }

    @Override
    public IPDIBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public ILaunchConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public IPDIDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public IPDIEventFactory getEventFactory() {
        return this.eventFactory;
    }

    @Override
    public IPDIEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public IPDIEventRequestManager getEventRequestManager() {
        return this.eventRequestManager;
    }

    @Override
    public IPDIExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    @Override
    public String getJobID() {
        return this.job_id;
    }

    @Override
    public IPDIMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public IPDIModelFactory getModelFactory() {
        return this.modelFactory;
    }

    @Override
    public IPDIRegisterManager getRegisterManager() {
        return this.registerManager;
    }

    @Override
    public IPDIRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public IPDISession getSession() {
        return this;
    }

    @Override
    public IPDISignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public IPDISourceManager getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public IPDITargetManager getTargetManager() {
        return this.targetManager;
    }

    @Override
    public IPDITaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public TaskSet getTasks() {
        TaskSet tasks = new TaskSet(this.total_tasks);
        tasks.set(0, this.total_tasks);
        return tasks;
    }

    @Override
    public IPDIThreadManager getThreadManager() {
        return this.threadManager;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getTotalTasks() {
        return this.total_tasks;
    }

    @Override
    public IPDIVariableManager getVariableManager() {
        return this.variableManager;
    }

    @Override
    public boolean isSuspended(TaskSet tasks) {
        return this.taskManager.isAllSuspended(tasks);
    }

    @Override
    public boolean isTerminated(TaskSet tasks) {
        return this.taskManager.isAllTerminated(tasks);
    }

    @Override
    public synchronized void processRunningEvent(TaskSet tasks) {
        IPDITarget[] targets;
        IPDITarget[] iPDITargetArray = targets = this.targetManager.getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            final IPDITarget target = iPDITargetArray[n2];
            if (target.getTasks().intersects(tasks)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        target.setSupended(false);
                    }
                };
                this.queueRunnable(runnable);
            }
            ++n2;
        }
    }

    @Override
    public synchronized void processSupsendedEvent(TaskSet tasks, final int thread_id, final String[] vars) {
        IPDITarget[] targets;
        IPDITarget[] iPDITargetArray = targets = this.targetManager.getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            final IPDITarget target = iPDITargetArray[n2];
            if (target.getTasks().intersects(tasks)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        target.setSupended(true);
                        target.updateState(thread_id);
                        try {
                            IPDIThread pthread = target.getCurrentThread();
                            if (pthread == null) {
                                return;
                            }
                            pthread.getCurrentStackFrame();
                        }
                        catch (PDIException pDIException) {
                            return;
                        }
                        try {
                            if (Session.this.variableManager.isAutoUpdate()) {
                                Session.this.variableManager.update(target.getTasks(), vars);
                            }
                            if (Session.this.expressionManager.isAutoUpdate()) {
                                Session.this.expressionManager.update(target.getTasks(), vars);
                            }
                            if (Session.this.registerManager.isAutoUpdate()) {
                                Session.this.registerManager.update(target.getTasks());
                            }
                            if (Session.this.memoryManager.isAutoUpdate()) {
                                Session.this.memoryManager.update(target.getTasks());
                            }
                            if (Session.this.breakpointManager.isAutoUpdate()) {
                                Session.this.breakpointManager.update(target.getTasks());
                            }
                            if (Session.this.signalManager.isAutoUpdate()) {
                                Session.this.signalManager.update(target.getTasks());
                            }
                            if (Session.this.sourceManager.isAutoUpdate()) {
                                Session.this.sourceManager.update(target.getTasks());
                            }
                        }
                        catch (PDIException pDIException) {
                            return;
                        }
                    }
                };
                this.queueRunnable(runnable);
            }
            ++n2;
        }
    }

    @Override
    public void queueRunnable(Runnable runnable) {
        this.notifyJob.addRunnable(runnable);
    }

    @Override
    public void restart(TaskSet tasks) throws PDIException {
        this.checkStatus();
        throw new PDIException(tasks, Messages.Session_2);
    }

    @Override
    public void resume(TaskSet tasks, boolean passSignal) throws PDIException {
        this.checkStatus();
        if (passSignal) {
            throw new PDIException(tasks, Messages.Session_3);
        }
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getResumeRequest(tasks, passSignal));
    }

    @Override
    public void resume(TaskSet tasks, IPDILocation location) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_5);
    }

    @Override
    public void resume(TaskSet tasks, IPDISignal signal) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_6);
    }

    @Override
    public void setRequestTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setStatus(int status) {
        this.waitLock.lock();
        try {
            this.status = status;
        }
        finally {
            this.waitLock.unlock();
        }
    }

    @Override
    public void shutdown(boolean force) {
        try {
            try {
                if (!force) {
                    this.exit();
                } else {
                    this.setStatus(4);
                }
                this.debugger.removeEventManager(this.eventManager);
                this.debugger.stopDebugger();
            }
            catch (PDIException e) {
                e.printStackTrace();
                this.variableManager.shutdown();
                this.expressionManager.shutdown();
                this.breakpointManager.shutdown();
                this.eventManager.shutdown();
                this.sourceManager.shutdown();
                this.taskManager.shutdown();
                this.targetManager.shutdown();
                this.threadManager.shutdown();
                this.memoryManager.shutdown();
                this.signalManager.shutdown();
                this.eventRequestManager.shutdown();
                this.notifyJob.schedule();
            }
        }
        finally {
            this.variableManager.shutdown();
            this.expressionManager.shutdown();
            this.breakpointManager.shutdown();
            this.eventManager.shutdown();
            this.sourceManager.shutdown();
            this.taskManager.shutdown();
            this.targetManager.shutdown();
            this.threadManager.shutdown();
            this.memoryManager.shutdown();
            this.signalManager.shutdown();
            this.eventRequestManager.shutdown();
            this.notifyJob.schedule();
        }
    }

    @Override
    public void start(TaskSet tasks) throws PDIException {
        this.checkStatus();
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getResumeRequest(tasks, false));
    }

    @Override
    public void stepInto(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getStepIntoRequest(tasks, count));
    }

    @Override
    public void stepIntoInstruction(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_7);
    }

    @Override
    public void stepOver(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getStepOverRequest(tasks, count));
    }

    @Override
    public void stepOverInstruction(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_8);
    }

    @Override
    public void stepReturn(TaskSet tasks, IAIF aif) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_9);
    }

    @Override
    public void stepReturn(TaskSet tasks, int count) throws PDIException {
        this.checkStatus();
        this.taskManager.getCanStepReturnTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getStepFinishRequest(tasks, count));
    }

    @Override
    public void stepUntil(TaskSet tasks, IPDILocation location) throws PDIException {
        this.checkStatus();
        this.taskManager.getSuspendedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_4);
        }
        throw new PDIException(tasks, Messages.Session_10);
    }

    @Override
    public void suspend(TaskSet tasks) throws PDIException {
        this.checkStatus();
        this.taskManager.getRunningTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_11);
        }
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getSuspendRequest(tasks));
    }

    @Override
    public void terminate(TaskSet tasks) throws PDIException {
        this.checkStatus();
        this.taskManager.getNonTerminatedTasks(tasks);
        if (tasks.isEmpty()) {
            throw new PDIException(tasks, Messages.Session_12);
        }
        TaskSet nonTerTasks = tasks.copy();
        this.taskManager.getRunningTasks(nonTerTasks);
        if (!nonTerTasks.isEmpty()) {
            this.eventRequestManager.addEventRequest(this.getRequestFactory().getSuspendRequest(nonTerTasks, false));
        }
        this.eventRequestManager.addEventRequest(this.getRequestFactory().getTerminateRequest(tasks));
        this.taskManager.setPendingTasks(true, tasks);
    }

    @Override
    public void validateStepReturn(TaskSet tasks) throws PDIException {
    }

    protected void checkStatus() throws PDIException {
        if (this.status == 4 || this.status == 5) {
            throw new PDIException(null, Messages.Session_13);
        }
    }

    private class NotifyJob
    extends Job {
        private final Vector<Runnable> fRunnables;

        public NotifyJob() {
            super(Messages.Session_15);
            this.setSystem(true);
            this.fRunnables = new Vector(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRunnable(Runnable runnable) {
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                this.fRunnables.add(runnable);
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Runnable[] runnables;
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                runnables = this.fRunnables.toArray(new Runnable[0]);
                this.fRunnables.clear();
            }
            MultiStatus failed = null;
            monitor.beginTask(this.getName(), runnables.length);
            PDebugOptions.trace(String.valueOf(Messages.Session_16) + runnables.length);
            Runnable[] runnableArray = runnables;
            int n = runnables.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable runnable = runnableArray[n2];
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.Session_17, null);
                    }
                    failed.add((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.Session_17, (Throwable)e));
                }
                monitor.worked(1);
                ++n2;
            }
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }

        public boolean shouldRun() {
            return !this.fRunnables.isEmpty();
        }
    }
}

